/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.edit;

import de.grogra.graph.GraphState;
import de.grogra.imp.PickList;
import de.grogra.imp2d.AWTCanvas2D;
import de.grogra.imp2d.DragEvent2D;
import de.grogra.imp2d.edit.EditTool;
import de.grogra.imp2d.edit.Editable;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.imp2d.objects.NURBSShape2D;
import de.grogra.imp2d.objects.Shape2DBase;
import de.grogra.math.BezierCurve;
import de.grogra.math.Transform2D;
import de.grogra.persistence.IndirectField;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.reflect.FieldChain;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;

public class BezierCurveEdit
implements Editable {
    private static final IndirectField FIELD = BezierCurve.data$FIELD.getArrayChain(1);

    private static BezierCurve getCurve(EditTool editTool) {
        Object object = editTool.getTool().getObjectOfObject(Attributes.CURVE, null);
        if (object instanceof BezierCurve) {
            editTool.getGraphState().setObjectContext(editTool.getToolTarget(), editTool.isTargetNode());
            return (BezierCurve)object;
        }
        return null;
    }

    public void drawTool(AWTCanvas2D aWTCanvas2D, Matrix3d matrix3d, EditTool editTool) {
        BezierCurve bezierCurve = BezierCurveEdit.getCurve(editTool);
        if (bezierCurve == null) {
            return;
        }
        float[] fArray = aWTCanvas2D.pool.getFloatArray(0, 2);
        GraphState graphState = aWTCanvas2D.getRenderGraphState();
        for (int i = 0; i < bezierCurve.getSize(graphState); ++i) {
            bezierCurve.getVertex(fArray, i, graphState);
            EditTool.drawHandle(aWTCanvas2D, matrix3d, fArray[0], fArray[1]);
        }
    }

    public void pickTool(Point2d point2d, Matrix3d matrix3d, PickList pickList, EditTool editTool) {
        BezierCurve bezierCurve = BezierCurveEdit.getCurve(editTool);
        if (bezierCurve == null) {
            return;
        }
        float[] fArray = pickList.getFloatArray(0, 2);
        GraphState graphState = pickList.getGraphState();
        for (int i = 0; i < bezierCurve.getSize(graphState); ++i) {
            bezierCurve.getVertex(fArray, i, graphState);
            if (!editTool.pickHandle(matrix3d, pickList, fArray[0], fArray[1], i)) continue;
            return;
        }
        Object object = editTool.getToolTarget();
        ((Shape2DBase)(object instanceof Shape2DBase ? object : NURBSShape2D.$TYPE.getRepresentative())).pick(object, editTool.isTargetNode(), point2d, matrix3d, pickList);
        if (pickList.containsCurrent()) {
            editTool.setPickId(-1);
        }
    }

    public void toolEventOccured(EditEvent editEvent, EditTool editTool) {
        BezierCurve bezierCurve = BezierCurveEdit.getCurve(editTool);
        if (bezierCurve == null) {
            return;
        }
        if (editEvent instanceof DragEvent2D) {
            DragEvent2D dragEvent2D = (DragEvent2D)editEvent;
            int n = editTool.getPickId();
            float[] fArray = editTool.pool.getFloatArray(0, 2);
            GraphState graphState = editTool.getGraphState();
            if (dragEvent2D.draggingStarted()) {
                if (n == -1 || n >= 0 && n < bezierCurve.getSize(graphState)) {
                    Point2d point2d = new Point2d(dragEvent2D.point);
                    Math2.invTransformPoint((Matrix3d)editTool.getTargetTransformation(), (Tuple2d)point2d);
                    if (n != -1) {
                        bezierCurve.getVertex(fArray, n, graphState);
                        point2d.x -= (double)fArray[0];
                        point2d.y -= (double)fArray[1];
                    }
                    editTool.setObject(point2d);
                } else {
                    editTool.setObject(null);
                }
            } else if (dragEvent2D.draggingContinued()) {
                Point2d point2d = editTool.pool.p2d0;
                Point2d point2d2 = (Point2d)editTool.getObject();
                if (point2d2 == null) {
                    return;
                }
                point2d.set((Tuple2d)dragEvent2D.point);
                Math2.invTransformPoint((Matrix3d)editTool.getTargetTransformation(), (Tuple2d)point2d);
                point2d.sub((Tuple2d)point2d2);
                if (n == -1) {
                    Matrix3d matrix3d = editTool.pool.m3d1;
                    Transform2D transform2D = (Transform2D)editTool.getTool().getObjectOfObject(Attributes.TRANSFORM, null);
                    if (transform2D != null) {
                        editTool.pool.m3d0.setIdentity();
                        transform2D.transform(editTool.pool.m3d0, matrix3d);
                    } else {
                        matrix3d.setIdentity();
                    }
                    Math2.transformVector((Matrix3d)matrix3d, (Tuple2d)point2d);
                    matrix3d.m02 += point2d.x;
                    matrix3d.m12 += point2d.y;
                    editTool.setTransform(matrix3d);
                } else if (n >= 0 && n < bezierCurve.getSize(graphState)) {
                    int[] nArray = new int[]{2 * n};
                    editTool.getTool().setSubfield(Attributes.CURVE, (FieldChain)FIELD, nArray, (Object)new Float(point2d.x));
                    nArray[0] = 2 * n + 1;
                    editTool.getTool().setSubfield(Attributes.CURVE, (FieldChain)FIELD, nArray, (Object)new Float(point2d.y));
                }
            }
        }
    }
}

