/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.ColorMapNode;
import de.grogra.math.ChannelData;
import de.grogra.math.ChannelMap;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public abstract class SurfaceMap
extends ColorMapNode {
    public static final Node.NType $TYPE = new Node.NType(SurfaceMap.class);

    protected float getDu() {
        return 0.005f;
    }

    protected float getDv() {
        return 0.005f;
    }

    public float getFloatValue(ChannelData channelData, int n) {
        ChannelData channelData2 = this.getInputData(channelData);
        float f = channelData2.getFloatValue(channelData, 16);
        float f2 = channelData2.getFloatValue(channelData, 17);
        boolean bl = n >= 8 && n <= 10;
        if (bl || n >= 12 && n <= 14) {
            float f3;
            float f4 = this.getFloatValueImpl(f, f2, channelData, n & 3);
            if (bl) {
                f3 = this.getDu();
                f += f3;
            } else {
                f3 = this.getDv();
                f2 += f3;
            }
            f = (this.getFloatValueImpl(f, f2, channelData, n & 3) - f4) / f3;
        } else {
            f = this.getFloatValueImpl(f, f2, channelData, n);
        }
        return f;
    }

    protected float getFloatValueImpl(float f, float f2, ChannelData channelData, int n) {
        throw new AssertionError((Object)("Method not implemented in " + ((Object)((Object)this)).getClass()));
    }

    protected void renderLine(BufferedImage bufferedImage, int n, int n2, boolean bl, Map map) {
        ChannelData channelData = (ChannelData)map.get("src");
        if (channelData == null) {
            channelData = new ChannelData();
            map.put("src", channelData);
        }
        ChannelData channelData2 = channelData.createSink((ChannelMap)this);
        channelData2.setProperty("ignoreInput", (Object)(!bl ? 1 : 0));
        Vector4f vector4f = channelData.v4f0;
        Vector3f vector3f = channelData.v3f2;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        for (int i = 0; i < n3; ++i) {
            vector4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            for (int j = 0; j < n; ++j) {
                float f = (float)(2 * n * n4 - (2 * (n * n2 + j) + 1)) / (float)(2 * n * n4);
                for (int k = 0; k < n; ++k) {
                    float f2 = (float)(2 * (n * i + k) + 1) / (float)(2 * n * n3);
                    channelData.setFloat(16, f2);
                    channelData.setFloat(17, f);
                    channelData2.getTuple3f((Tuple3f)vector3f, null, 24);
                    vector4f.x += vector3f.x;
                    vector4f.y += vector3f.y;
                    vector4f.z += vector3f.z;
                    vector4f.w += channelData2.getFloatValue(null, 27);
                }
            }
            vector4f.clamp(0.0f, (float)(n * n));
            vector4f.scale(255.99f / (float)(n * n));
            bufferedImage.setRGB(i, n2, ((int)vector4f.w << 24) + ((int)vector4f.x << 16) + ((int)vector4f.y << 8) + (int)vector4f.z);
        }
    }

    static {
        $TYPE.validate();
    }
}

