/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.ray.RTObject;
import de.grogra.ray.intersection.BoundingBox;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class RTFrustum
extends RaytracerLeaf
implements RTObject {
    public final Intersections.FrustumInput m_frustumInput = new Intersections.FrustumInput();
    public final Intersections.FrustumLocalVariables m_frustumLocalVariables = new Intersections.FrustumLocalVariables();
    public final Intersections.ObjectOutput m_frustumOutput = new Intersections.ObjectOutput();
    private final Vector3f m_vec1 = new Vector3f();
    private final Vector3f m_vec2 = new Vector3f();
    private final Vector3f m_vec3 = new Vector3f();
    private final Vector3f m_vec4 = new Vector3f();
    private final Matrix4f m_axisTransform = new Matrix4f();
    private boolean m_shadeable = true;
    private BoundingBox m_boundingVolume = null;

    public RTFrustum(Object object, boolean bl, long l, float f, float f2, Vector3f vector3f, boolean bl2, boolean bl3) {
        super(object, bl, l);
        float f3;
        if (f == 0.0f && f2 == 0.0f) {
            this.m_shadeable = false;
            return;
        }
        if (f2 == 0.0f) {
            this.m_vec3.negate((Tuple3f)vector3f);
            this.m_vec4.set((Tuple3f)vector3f);
            f3 = f;
            this.m_frustumInput.top_normal.normalize(vector3f);
            this.m_frustumInput.top_normal.negate();
            this.m_frustumInput.open_top = false;
            this.m_frustumInput.open_bottom = false;
            this.m_frustumInput.radius_ratio = f2 / f;
            this.m_frustumInput.radius_ratio_sq = this.m_frustumInput.radius_ratio * this.m_frustumInput.radius_ratio;
        } else {
            this.m_vec3.set((Tuple3f)vector3f);
            this.m_vec4.set(0.0f, 0.0f, 0.0f);
            f3 = f2;
            this.m_frustumInput.top_normal.normalize(vector3f);
            this.m_frustumInput.open_top = false;
            this.m_frustumInput.open_bottom = false;
            this.m_frustumInput.radius_ratio = f / f2;
            this.m_frustumInput.radius_ratio_sq = this.m_frustumInput.radius_ratio * this.m_frustumInput.radius_ratio;
        }
        if (this.m_vec3.x == 0.0f && this.m_vec3.z == 0.0f) {
            this.m_vec2.set(0.0f, 0.0f, -1.0f);
        } else {
            this.m_vec2.set(0.0f, 1.0f, 0.0f);
        }
        this.m_vec1.cross(this.m_vec2, this.m_vec3);
        this.m_vec2.cross(this.m_vec3, this.m_vec1);
        this.m_vec1.normalize();
        this.m_vec2.normalize();
        this.m_vec1.scale(f3);
        this.m_vec2.scale(f3);
        this.m_axisTransform.setIdentity();
        this.m_axisTransform.m00 = this.m_vec1.x;
        this.m_axisTransform.m10 = this.m_vec1.y;
        this.m_axisTransform.m20 = this.m_vec1.z;
        this.m_axisTransform.m01 = this.m_vec2.x;
        this.m_axisTransform.m11 = this.m_vec2.y;
        this.m_axisTransform.m21 = this.m_vec2.z;
        this.m_axisTransform.m02 = this.m_vec3.x;
        this.m_axisTransform.m12 = this.m_vec3.y;
        this.m_axisTransform.m22 = this.m_vec3.z;
        this.m_axisTransform.m03 = this.m_vec4.x;
        this.m_axisTransform.m13 = this.m_vec4.y;
        this.m_axisTransform.m23 = this.m_vec4.z;
        this.m_frustumInput.top_tangenteU.set((Tuple3f)this.m_vec1);
        this.m_frustumInput.top_tangenteV.set((Tuple3f)this.m_vec2);
    }

    public void setTransformation(Matrix4f matrix4f) {
        super.setTransformation(matrix4f);
        if (this.m_shadeable) {
            matrix4f.transform(this.m_frustumInput.top_normal);
            this.m_frustumInput.transformation.mul(matrix4f, this.m_axisTransform);
            this.m_frustumInput.invers_transformation.invert(this.m_frustumInput.transformation);
            this.setShader(this.shader);
            if (this.interior != null) {
                this.setMedium(this.interior);
            }
        }
    }

    public boolean isShadeable() {
        return this.m_shadeable;
    }

    public boolean isSolid() {
        return !this.m_frustumInput.open_top && !this.m_frustumInput.open_bottom;
    }

    public boolean isConvex() {
        return !this.m_frustumInput.open_top && !this.m_frustumInput.open_bottom;
    }

    public float getDistance(Ray ray, RayContext rayContext) {
        this.m_frustumInput.ray.setRay(ray);
        this.m_frustumInput.minIndex = this.getUserData().isInside ? 1 : 0;
        if (this.isSolid()) {
            Intersections.getSolidFrustum_T((Intersections.FrustumInput)this.m_frustumInput, (Intersections.ObjectOutput)this.m_frustumOutput, (Intersections.FrustumLocalVariables)this.m_frustumLocalVariables);
        } else {
            Intersections.getFrustum_T((Intersections.FrustumInput)this.m_frustumInput, (Intersections.ObjectOutput)this.m_frustumOutput, (Intersections.FrustumLocalVariables)this.m_frustumLocalVariables);
        }
        if (!this.m_frustumOutput.hasIntersection) {
            return Float.NaN;
        }
        return this.m_frustumOutput.t;
    }

    public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
        Intersections.getFrustum_IntersectionDescription((Intersections.FrustumInput)this.m_frustumInput, (int)this.shader.getFlags(), (IntersectionDescription)intersectionDescription, (Intersections.FrustumLocalVariables)this.m_frustumLocalVariables);
        intersectionDescription.setRTObject((RTObject)this);
    }

    public BoundingVolume getBoundingVolume() {
        if (this.m_boundingVolume == null) {
            Point3f[] point3fArray = new Point3f[8];
            Vector3f vector3f = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            Vector3f vector3f2 = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            point3fArray[0] = new Point3f(1.0f, 1.0f, 1.0f);
            point3fArray[1] = new Point3f(-1.0f, 1.0f, 1.0f);
            point3fArray[2] = new Point3f(-1.0f, -1.0f, 1.0f);
            point3fArray[3] = new Point3f(1.0f, -1.0f, 1.0f);
            point3fArray[4] = new Point3f(1.0f, 1.0f, 0.0f);
            point3fArray[5] = new Point3f(-1.0f, 1.0f, 0.0f);
            point3fArray[6] = new Point3f(-1.0f, -1.0f, 0.0f);
            point3fArray[7] = new Point3f(1.0f, -1.0f, 0.0f);
            for (int i = 0; i < 8; ++i) {
                this.m_frustumInput.transformation.transform(point3fArray[i]);
                if (point3fArray[i].x < vector3f.x) {
                    vector3f.x = point3fArray[i].x;
                }
                if (point3fArray[i].y < vector3f.y) {
                    vector3f.y = point3fArray[i].y;
                }
                if (point3fArray[i].z < vector3f.z) {
                    vector3f.z = point3fArray[i].z;
                }
                if (point3fArray[i].x > vector3f2.x) {
                    vector3f2.x = point3fArray[i].x;
                }
                if (point3fArray[i].y > vector3f2.y) {
                    vector3f2.y = point3fArray[i].y;
                }
                if (!(point3fArray[i].z > vector3f2.z)) continue;
                vector3f2.z = point3fArray[i].z;
            }
            this.m_boundingVolume = new BoundingBox(vector3f, vector3f2);
        }
        return this.m_boundingVolume;
    }
}

