/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.Polygonization;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.math.Pool;
import de.grogra.math.VertexList;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Polygon
extends ShadedNull
implements Pickable,
Polygonizable,
Renderable {
    VertexList vertices;
    int visibleSides = 2;
    public static final Node.NType $TYPE = new Node.NType((Node)new Polygon());
    public static final Node.NType.Field vertices$FIELD = new _Field("vertices", 0x200000, (Type)ClassAdapter.wrap(VertexList.class), null, 0);
    public static final Node.NType.Field visibleSides$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Polygon();
    }

    public int getVisibleSides() {
        return this.visibleSides;
    }

    public void setVisibleSides(int n) {
        this.visibleSides = n;
    }

    public VertexList getVertices() {
        return this.vertices;
    }

    public void setVertices(VertexList vertexList) {
        vertices$FIELD.setObject((Object)this, (Object)vertexList);
    }

    public Polygon() {
        this((VertexList)null);
    }

    public Polygon(VertexList vertexList) {
        this.vertices = vertexList;
        this.setLayer(1);
    }

    public ContextDependent getPolygonizableSource(GraphState graphState) {
        return this.vertices;
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        Sphere.pick(1.0f, point3d, vector3d, pickList);
    }

    public Polygonization getPolygonization() {
        final class Poly
        implements Polygonization {
            final int visibleSides;

            Poly() {
                this.visibleSides = Polygon.this.visibleSides;
            }

            public void polygonize(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
                Polygon.this.polygonizeImpl(contextDependent, graphState, polygonArray, n, f);
            }

            public boolean equals(Object object) {
                if (!(object instanceof Poly)) {
                    return false;
                }
                Poly poly = (Poly)object;
                return poly.visibleSides == this.visibleSides;
            }

            public int hashCode() {
                return this.visibleSides;
            }
        }
        return new Poly();
    }

    void polygonizeImpl(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
        int n2;
        polygonArray.init(3);
        if (this.vertices != null && (n2 = this.vertices.getSize(graphState)) > 2) {
            int n3;
            float f2;
            float f3;
            boolean bl = (n & 1) != 0;
            boolean bl2 = (n & 2) != 0;
            boolean bl3 = this.vertices.isRational(graphState);
            polygonArray.edgeCount = 3;
            polygonArray.planar = true;
            polygonArray.closed = false;
            float[] fArray = Pool.get((GraphState)graphState).getFloatArray(0, 4);
            float[] fArray2 = Pool.get((GraphState)graphState).getFloatArray(1, 4);
            int n4 = this.vertices.getVertex(fArray, 0, graphState);
            if (!(n4 != this.vertices.getVertex(fArray2, n2 - 1, graphState) || bl3 && Math.abs(fArray[--n4] - fArray2[n4]) > 1.0E-5f)) {
                f3 = 0.0f;
                f2 = 0.0f;
                for (n3 = 0; n3 < n4; ++n3) {
                    f3 += Math.abs(fArray[n3]) + Math.abs(fArray2[n3]);
                    f2 += Math.abs(fArray[n3] - fArray2[n3]);
                }
                if (!(f2 > f3 * 1.0E-5f)) {
                    --n2;
                }
            }
            polygonArray.visibleSides = this.visibleSides;
            if (n2 == 3) {
                for (int i = 0; i < 3; ++i) {
                    n4 = this.vertices.getVertex(fArray, i, graphState);
                    if (bl3) {
                        f2 = 1.0f / fArray[--n4];
                        n3 = n4 - 1;
                        while (n3 >= 0) {
                            int n5 = n3--;
                            fArray[n5] = fArray[n5] * f2;
                        }
                    }
                    polygonArray.vertices.push(fArray[0]).push(n4 > 1 ? fArray[1] : 0.0f).push(n4 > 2 ? fArray[2] : 0.0f);
                    polygonArray.polygons.push(i);
                }
                if (bl) {
                    polygonArray.computeNormal(fArray, 0, 1, 2);
                    polygonArray.setNormal(0, fArray[0], fArray[1], fArray[2]);
                    polygonArray.copyNormal(0, 1);
                    polygonArray.copyNormal(0, 2);
                }
                if (bl2) {
                    polygonArray.uv.push(0.0f).push(0.0f).push(1.0f).push(0.0f).push(0.0f).push(1.0f);
                }
            } else {
                char c;
                f3 = 0.0f;
                f2 = 0.0f;
                float f4 = 0.0f;
                for (int i = 0; i < n2; ++i) {
                    n4 = this.vertices.getVertex(fArray, i, graphState);
                    if (bl3) {
                        float f5 = 1.0f / fArray[--n4];
                        c = n4 - 1;
                        while (c >= '\u0000') {
                            char c2 = c--;
                            fArray[c2] = fArray[c2] * f5;
                        }
                    }
                    polygonArray.vertices.push(fArray[0]).push(n4 > 1 ? fArray[1] : 0.0f).push(n4 > 2 ? fArray[2] : 0.0f);
                    f3 += fArray[0];
                    if (n4 > 1) {
                        f2 += fArray[1];
                        if (n4 > 2) {
                            f4 += fArray[2];
                        }
                    }
                    polygonArray.polygons.push(i == 0 ? n2 - 1 : i - 1).push(i).push(n2);
                }
                float f6 = 1.0f / (float)n2;
                polygonArray.vertices.push(f3 * f6).push(f2 * f6).push(f4 * f6);
                if (bl2) {
                    for (int i = 0; i < n2; ++i) {
                        c = (char)(i * 65536 / n2);
                        polygonArray.uv.push((Math2.ccos((char)c) + 1.0f) * 0.5f).push((Math2.csin((char)c) + 1.0f) * 0.5f);
                    }
                    polygonArray.uv.push(0.5f).push(0.5f);
                }
                if (bl) {
                    float f7;
                    float f8;
                    float f9;
                    polygonArray.computeNormal(fArray, n2 - 1, 0, n2);
                    f6 = fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2];
                    if (f6 > 0.0f) {
                        f6 = 1.0f / (float)Math.sqrt(f6);
                    }
                    float f10 = f9 = f6 * fArray[0];
                    f3 = f9;
                    float f11 = f8 = f6 * fArray[1];
                    f2 = f8;
                    float f12 = f7 = f6 * fArray[2];
                    f4 = f7;
                    for (int i = 1; i < n2; ++i) {
                        polygonArray.computeNormal(fArray, i - 1, i, n2);
                        f6 = fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2];
                        if (f6 > 0.0f) {
                            f6 = 1.0f / (float)Math.sqrt(f6);
                        }
                        float f13 = f10;
                        f10 = f6 * fArray[0];
                        float f14 = f11;
                        f11 = f6 * fArray[1];
                        float f15 = f12;
                        f12 = f6 * fArray[2];
                        polygonArray.setNormal(i - 1, f13 + f10, f14 + f11, f15 + f12);
                        f3 += f10;
                        f2 += f11;
                        f4 += f12;
                    }
                    polygonArray.setNormal(n2 - 1, f10 + f9, f11 + f8, f12 + f7);
                    polygonArray.setNormal(n2, f3, f2, f4);
                }
            }
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        renderState.drawPolygons(this, object, bl, null, -1, null);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)vertices$FIELD);
        visibleSides$FIELD = new _Field("visibleSides", 0x200000, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)visibleSides$FIELD);
        $TYPE.declareFieldAttribute(vertices$FIELD, (Attribute)Attributes.VERTEX_LIST);
        $TYPE.declareFieldAttribute(visibleSides$FIELD, (Attribute)Attributes.VISIBLE_SIDES);
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 1: {
                    ((Polygon)object).visibleSides = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 1: {
                    return ((Polygon)object).getVisibleSides();
                }
            }
            return super.getInt(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((Polygon)object).vertices = (VertexList)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Polygon)object).getVertices();
                }
            }
            return super.getObject(object);
        }
    }
}

