/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Cache;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.objects.GRSVertex;
import de.grogra.imp3d.objects.MeshNode;
import de.grogra.imp3d.objects.Polygons;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;

public class GRSMesh
extends ContextDependentBase
implements Polygons {
    private final Object polygonizeLock = new Object();
    public static final Type $TYPE = new Type(GRSMesh.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void polygonize(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
        int n2;
        IntList intList;
        Object object;
        Object object2;
        MeshNode meshNode = (MeshNode)graphState.getObjectContext().getObject();
        polygonArray.init(3);
        polygonArray.edgeCount = 3;
        polygonArray.planar = true;
        polygonArray.closed = true;
        Matrix4d matrix4d = new Matrix4d();
        ObjectList objectList = new ObjectList(32);
        for (Edge edge = meshNode.getFirstEdge(); edge != null; edge = edge.getNext((Node)meshNode)) {
            object2 = edge.getTarget();
            if (!(object2 instanceof GRSVertex)) continue;
            GRSVertex gRSVertex = (GRSVertex)object2;
            objectList.push((Object)gRSVertex);
            if ((n & 2) != 0) {
                polygonArray.uv.push(gRSVertex.u, gRSVertex.v);
            }
            if ((object = (Object)gRSVertex.getTransform()) instanceof Tuple3d) {
                intList = (Tuple3d)object;
                polygonArray.vertices.push((float)intList.x, (float)intList.y, (float)intList.z);
                continue;
            }
            if (object != null) {
                matrix4d.setIdentity();
                object.transform(matrix4d, matrix4d);
                polygonArray.vertices.push((float)matrix4d.m03, (float)matrix4d.m13, (float)matrix4d.m23);
                continue;
            }
            polygonArray.vertices.push(0.0f, 0.0f, 0.0f);
        }
        int n3 = objectList.size;
        object2 = new long[n3];
        boolean bl = (n & 1) != 0;
        object = bl ? new float[n3 * 3] : null;
        intList = new IntList(20);
        Object object3 = this.polygonizeLock;
        synchronized (object3) {
            GRSVertex gRSVertex;
            for (n2 = 0; n2 < n3; ++n2) {
                gRSVertex = (GRSVertex)objectList.get(n2);
                gRSVertex.meshIndex = n2;
                object2[n2] = (Node)((1L << gRSVertex.neighbors.size) - 1L);
                if (gRSVertex.findAdjacent(false, true, 8192) == null) continue;
                Object object4 = object2;
                int n4 = n2;
                object4[n4] = object4[n4] | Long.MIN_VALUE;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                gRSVertex = (GRSVertex)objectList.get(n2);
                for (int i = 0; i < gRSVertex.neighbors.size && object2[n2] << 1 != 0L; ++i) {
                    int n5;
                    if (((int)(object2[n2] >> i) & 1) == 0) continue;
                    int n6 = 0;
                    intList.clear();
                    float[] fArray = polygonArray.vertices.elements;
                    int n7 = polygonArray.polygons.size;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    float f6 = 0.0f;
                    float f7 = 0.0f;
                    float f8 = 0.0f;
                    float f9 = 0.0f;
                    GRSVertex gRSVertex2 = gRSVertex;
                    int n8 = n2;
                    GRSVertex gRSVertex3 = (GRSVertex)gRSVertex.neighbors.get(i);
                    int n9 = i;
                    int n10 = -1;
                    boolean bl2 = false;
                    do {
                        if (object2[n8] < 0L && gRSVertex2.findAdjacent(false, true, 8192) == gRSVertex3) {
                            bl2 = true;
                        }
                        intList.add(n8);
                        ++n6;
                        Object object5 = object2;
                        int n11 = n8;
                        object5[n11] = object5[n11] & (1L << n9 ^ 0xFFFFFFFFFFFFFFFFL);
                        n5 = gRSVertex3.meshIndex;
                        int n12 = n8 * 3;
                        f2 += fArray[n12];
                        f3 += fArray[n12 + 1];
                        f4 += fArray[n12 + 2];
                        f5 += gRSVertex2.u;
                        f6 += gRSVertex2.v;
                        if (bl) {
                            int n13 = n5 * 3;
                            f7 += fArray[n13 + 1] * fArray[n12 + 2] - fArray[n13 + 2] * fArray[n12 + 1];
                            f8 += fArray[n13 + 2] * fArray[n12] - fArray[n13] * fArray[n12 + 2];
                            f9 += fArray[n13] * fArray[n12 + 1] - fArray[n13 + 1] * fArray[n12];
                        }
                        if (n6 == 3) {
                            if (gRSVertex3 == gRSVertex) {
                                polygonArray.polygons.push(n5, n8, intList.get(1));
                                break;
                            }
                            n10 = polygonArray.vertices.size / 3;
                            polygonArray.polygons.push(n10, intList.get(1), intList.get(0));
                            polygonArray.polygons.push(n10, n8, intList.get(1));
                        }
                        if (n6 >= 3) {
                            polygonArray.polygons.push(n10, n5, n8);
                        }
                        if ((n9 = gRSVertex3.neighbors.indexOf((Object)gRSVertex2) + 1) <= 0) {
                            System.err.println("Inconsistent data: " + gRSVertex3 + " does not have " + gRSVertex2 + " as neighbor");
                            bl2 = true;
                            break;
                        }
                        if (n6 > n3) {
                            System.err.println("Inconsistent data: " + gRSVertex + " leads to loop not containing itself");
                            bl2 = true;
                            break;
                        }
                        if (n9 == gRSVertex3.neighbors.size) {
                            n9 = 0;
                        }
                        gRSVertex2 = gRSVertex3;
                        gRSVertex3 = (GRSVertex)gRSVertex3.neighbors.get(n9);
                        n8 = n5;
                    } while (gRSVertex2 != gRSVertex);
                    if (bl2) {
                        polygonArray.polygons.setSize(n7);
                        continue;
                    }
                    if (n10 >= 0) {
                        float f10 = 1.0f / (float)n6;
                        polygonArray.vertices.push(f2 * f10, f3 * f10, f4 * f10);
                        if ((n & 2) != 0) {
                            polygonArray.uv.push(f5 * f10, f6 * f10);
                        }
                        if (bl) {
                            polygonArray.setNormal(n10, f7, f8, f9);
                        }
                    }
                    if (!bl) continue;
                    while (!intList.isEmpty()) {
                        n5 = intList.pop() * 3;
                        float f11 = 1.0f / (float)Math.sqrt(f7 * f7 + f8 * f8 + f9 * f9);
                        int n14 = n5;
                        object[n14] = object[n14] + f7 * f11;
                        int n15 = n5 + 1;
                        object[n15] = object[n15] + f8 * f11;
                        int n16 = n5 + 2;
                        object[n16] = object[n16] + f9 * f11;
                    }
                }
            }
        }
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                n2 = i * 3;
                polygonArray.setNormal(i, object[n2], object[n2 + 1], object[n2 + 2]);
            }
        }
    }

    public boolean dependsOnContext() {
        return true;
    }

    public void writeStamp(Cache.Entry entry, GraphState graphState) {
        super.writeStamp(entry, graphState);
        MeshNode meshNode = (MeshNode)graphState.getObjectContext().getObject();
        for (Edge edge = meshNode.getFirstEdge(); edge != null; edge = edge.getNext((Node)meshNode)) {
            Node node = edge.getTarget();
            if (!(node instanceof GRSVertex)) continue;
            GRSVertex gRSVertex = (GRSVertex)node;
            entry.write(gRSVertex.hashCode());
            entry.write(gRSVertex.getStamp());
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(GRSMesh gRSMesh, SCOType sCOType) {
            super((Object)gRSMesh, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        public Object newInstance() {
            return new GRSMesh();
        }
    }
}

