/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.GraphState;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.LightBase;
import de.grogra.imp3d.ray.RTDirectionalLight;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class DirectionalLight
extends LightBase
implements Raytraceable {
    float powerDensity = 10.0f;
    public static final Type $TYPE = new Type(DirectionalLight.class);
    public static final SCOType.Field powerDensity$FIELD = Type._addManagedField($TYPE, "powerDensity", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    private static Tuple3f ZERO;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public float getPowerDensity() {
        return this.powerDensity;
    }

    public void setPowerDensity(float f) {
        this.powerDensity = f;
    }

    public int getLightType() {
        return 3;
    }

    protected void draw(Tuple3f tuple3f, RenderState renderState) {
        Vector3f vector3f = renderState.getPool().v3f0;
        vector3f.set(0.0f, 0.0f, 0.0f);
        vector3f.z = 50.0f / renderState.estimateScaleAt((Tuple3f)vector3f);
        renderState.drawLine(ZERO, (Tuple3f)vector3f, tuple3f, -1, null);
    }

    public double getTotalPower(Environment environment) {
        return environment.boundsRadius * environment.boundsRadius * Math.PI * (double)this.powerDensity;
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        Matrix4f matrix4f = environment.localToGlobal;
        Vector3d vector3d = environment.tmpVector0;
        vector3d.set((double)matrix4f.m02, (double)matrix4f.m12, (double)matrix4f.m22);
        Matrix3d matrix3d = environment.tmpMatrix30;
        Math2.getOrthogonalBasis((Tuple3d)vector3d, (Matrix3d)matrix3d, (boolean)true);
        double d = environment.boundsRadius * environment.boundsRadius * Math.PI;
        double d2 = 1.0 / d;
        double d3 = ((double)matrix4f.m03 - environment.boundsCenter.x) * matrix3d.m02 + ((double)matrix4f.m13 - environment.boundsCenter.y) * matrix3d.m12 + ((double)matrix4f.m23 - environment.boundsCenter.z) * matrix3d.m22;
        for (int i = 0; i < rayList.getSize(); ++i) {
            Ray ray = rayList.rays[i];
            int n = random.nextInt();
            double d4 = Math.sqrt((double)(n >>> 16) * 1.52587890625E-5) * environment.boundsRadius;
            char c = (char)n;
            vector3d.x = (double)Math2.ccos((char)c) * d4;
            vector3d.y = (double)Math2.csin((char)c) * d4;
            vector3d.z = d3;
            matrix3d.transform((Tuple3d)vector3d);
            vector3d.add((Tuple3d)environment.boundsCenter);
            ray.origin.set((Tuple3d)vector3d);
            if (i == 0) {
                ray.spectrum.set((Tuple3f)this.color);
                ray.spectrum.scale((double)this.powerDensity * d / ray.spectrum.integrate());
            } else {
                ray.spectrum.set(rayList.rays[0].spectrum);
            }
            ray.originDensity = (float)d2;
        }
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        spectrum.set((Tuple3f)this.color);
        spectrum.scale((double)(this.powerDensity / (this.color.x + this.color.y + this.color.z)));
        return 1.0 / (environment.boundsRadius * environment.boundsRadius * Math.PI);
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        Matrix4f matrix4f = environment.localToGlobal;
        Vector3f vector3f2 = environment.userVector;
        vector3f2.set(matrix4f.m02, matrix4f.m12, matrix4f.m22);
        vector3f2.normalize();
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            Ray ray = rayList.rays[i];
            ray.direction.set((Tuple3f)vector3f2);
            ray.spectrum.set(spectrum);
            ray.directionDensity = 1.0E10f;
        }
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        spectrum2.setZero();
        return 0.0f;
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        Light light = (Light)graphState.getObjectDefault(object, bl, Attributes.LIGHT, null);
        if (light == null) {
            System.err.println("PointLight::createRaytracerLeaf - light is null");
        }
        if (light.getLightType() != 3) {
            System.err.println("DirectionalLight::createRaytracerLeaf - unexpected light type");
        }
        return new RTDirectionalLight(object, bl, l, light);
    }

    public void accept(LightVisitor lightVisitor) {
        lightVisitor.visit(this);
    }

    static {
        powerDensity$FIELD.setQuantity(Quantity.POWER_PER_AREA);
        $TYPE.validate();
        ZERO = new Point3f();
    }

    public static class Type
    extends LightBase.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 3;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(DirectionalLight directionalLight, SCOType sCOType) {
            super(directionalLight, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)LightBase.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((DirectionalLight)object).powerDensity = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((DirectionalLight)object).getPowerDensity();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new DirectionalLight();
        }
    }
}

