/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.glsl.GLDisplay;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.GLSLUpdateCache;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.material.GLSLMaterial;
import de.grogra.imp3d.glsl.renderpass.CopyFloatTexturePass;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.utility.Drawable;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class ToolRenderPass
extends FullRenderPass {
    GLSLShader useTransp = null;
    CopyFloatTexturePass cftp = new CopyFloatTexturePass();
    boolean wrongShader = false;

    protected int getID() {
        return 5;
    }

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        gL.glPopAttrib();
        openGLState.enable('\u0001');
        gL.glStencilFunc(514, 3, 3);
        gL.glStencilOp(7680, 7680, 7680);
        this.cftp.process(gLSLDisplay, openGLState, object);
        openGLState.switchFloatRT();
        openGLState.disable('\u0001');
        gL.glDepthFunc(513);
        ToolRenderPass.deactivateTextures(gL, 2, 34037);
    }

    public void postDrawCallback(Drawable drawable, OpenGLState openGLState, GLSLDisplay gLSLDisplay) {
        GLSLMaterial gLSLMaterial = drawable.getGLSLShader();
        if (gLSLMaterial == null || gLSLMaterial.getShaderProgramNumber() == 0) {
            if (this.wrongShader) {
                this.useTransp.activateShader(openGLState, gLSLDisplay, null);
                this.wrongShader = false;
            }
        } else {
            openGLState.setShaderConfSwitch(6);
            drawable.activateGLSLShader(openGLState, gLSLDisplay);
            openGLState.setShaderConfSwitch(0);
            this.wrongShader = true;
        }
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        GL gL = openGLState.getGL();
        openGLState.switchFloatRT();
        GLSLDisplay.printDebugInfoN("Render Tool to: " + (4 + openGLState.getFloatRT()));
        openGLState.getHDRFBO().drawBuffer(openGLState, openGLState.getFloatRT());
        openGLState.setActiveProgram(0);
        gL.glPushAttrib(2048);
        gL.glViewport(0, 0, openGLState.width, openGLState.height);
        gL.glDepthFunc(514);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRTLast(), 0);
        openGLState.getAlphaFBO().bindAttachmentAsTexture(openGLState, 0, 1);
        openGLState.enable('\u0001');
        gL.glStencilFunc(519, 3, 3);
        gL.glStencilOp(7680, 7680, 7681);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        if (this.useTransp == null) {
            this.useTransp = new DrawWithTranspShader(openGLState);
        }
        GLDisplay.GLVisitor gLVisitor = gLSLDisplay.getVisitor();
        if (this.newVisit == null) {
            this.newVisit = new GLSLUpdateCache(gLSLDisplay);
        }
        this.newVisit.init(gLSLDisplay.getRenderGraphState(), openGLState.getWorldToView(), 0);
        gLSLDisplay.setVisitor(this.newVisit);
        this.useTransp.activateShader(openGLState, gLSLDisplay, null);
        this.wrongShader = false;
        if (gLSLDisplay.isOptionShowGrid()) {
            gLSLDisplay.drawGrid(openGLState.getGL());
        }
        gLSLDisplay.setVisitor(gLVisitor);
        this.renderVector(gLSLDisplay, openGLState.getWorldToView(), true, openGLState.deferredToolRenderable);
        GL gL = openGLState.getGL();
    }

    class DrawWithTranspShader
    extends GLSLShader {
        String[] vertexShader;
        String[] fragShader;

        public DrawWithTranspShader(OpenGLState openGLState) {
            super(openGLState);
            this.vertexShader = new String[]{"#version 110\n", "void main() {\n", "gl_FrontColor = gl_Color;\n", "gl_BackColor = gl_Color;\n", "gl_Position = ftransform();\n", "}"};
            this.fragShader = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect inputTex;\n", "uniform sampler2DRect alphaTex;\n", "void main() {\n", " vec4 lastCol = texture2DRect(inputTex, gl_FragCoord.st);\n", " vec4 alpha = texture2DRect(alphaTex, gl_FragCoord.st);\n", " gl_FragColor = clamp(vec4(alpha.rgb, 1.0) * gl_Color + lastCol, 0.0, 1.0);\n", "}"};
        }

        protected String[] getVertexShader(Object object) {
            return this.vertexShader;
        }

        protected String[] getFragmentShader(Object object) {
            return this.fragShader;
        }

        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 0);
            int n2 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "alphaTex");
            gL.glUniform1i(n2, 1);
        }
    }
}

