/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.renderpass.ReduceImagePass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;

public class ToneMappingPass
extends FullRenderPass {
    GLSLShader presentToneMapped = null;
    GLSLShader presentBlaToneMapped = null;
    GLSLShader presentStaticToneMapped = null;
    ReduceImagePass rip = new ReduceImagePass();
    FloatBuffer buf = FloatBuffer.allocate(4);

    protected int getID() {
        return 4;
    }

    protected void pickColors(GLSLDisplay gLSLDisplay, OpenGLState openGLState) {
        openGLState.getDeferredShadingFBO().drawBuffers(openGLState, 2);
        for (int i = 0; i < 2; ++i) {
            this.buf.clear();
            openGLState.getGL().glReadBuffer(36064 + i);
            openGLState.getGL().glReadPixels(0, 0, 1, 1, 32993, 5126, (Buffer)this.buf);
            System.out.println("Att" + i + ":\nB: " + this.buf.get(0) + "\n" + "G: " + this.buf.get(1) + "\n" + "R: " + this.buf.get(2) + "\n" + "A: " + this.buf.get(3));
        }
    }

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        ToneMappingPass.deactivateTextures(gL, 3);
        openGLState.setDepthMask(true);
        ToneMappingPass.ViewPerspective(openGLState);
        gL.glPopAttrib();
        openGLState.enable('\u0002');
        openGLState.disable('\u0001');
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        if (gLSLDisplay.isOptionAutoAdjustBrightness()) {
            this.rip.process(gLSLDisplay, openGLState, object);
        }
        GL gL = openGLState.getGL();
        openGLState.switchFloatRT();
        openGLState.getHDRFBO().drawBuffer(openGLState, openGLState.getFloatRT());
        GLSLDisplay.printDebugInfoN("Tonemapping to: " + (4 + openGLState.getFloatRT()) + " from " + (4 + openGLState.getFloatRTLast()));
        gL.glPushAttrib(2048);
        openGLState.disable('\u0002');
        openGLState.disable('\u0001');
        if (this.presentToneMapped == null) {
            this.presentToneMapped = new SimpleTonemappingShader(openGLState);
        }
        if (this.presentStaticToneMapped == null) {
            this.presentStaticToneMapped = new StaticTonemappingShader(openGLState);
        }
        if (this.presentBlaToneMapped == null) {
            this.presentBlaToneMapped = new BlaTonemappingShader(openGLState);
        }
        if (!gLSLDisplay.isOptionAutoAdjustBrightness()) {
            this.presentStaticToneMapped.activateShader(openGLState, gLSLDisplay, object);
        } else {
            switch (gLSLDisplay.getTonemapping()) {
                case 0: {
                    this.presentToneMapped.activateShader(openGLState, gLSLDisplay, gLSLDisplay);
                    break;
                }
                case 1: {
                    this.presentBlaToneMapped.activateShader(openGLState, gLSLDisplay, gLSLDisplay);
                    break;
                }
            }
        }
        ToneMappingPass.ViewOrtho(openGLState);
        openGLState.setDepthMask(false);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRTLast(), 2);
        openGLState.getDeferredShadingFBO().bindAllAttachmentsAsTextures(openGLState, 2);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        ToneMappingPass.drawPrjQuad(openGLState, camera);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BlaTonemappingShader
    extends GLSLShader {
        final String[] toneMappedS;

        public BlaTonemappingShader(OpenGLState openGLState) {
            super(openGLState);
            this.toneMappedS = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect inputTex;\n", "uniform sampler2DRect luminTex;\n", "uniform sampler2DRect averageTex;\n", "void tone(inout vec3 rgb, float f_i, float m, float a, float c, vec3 Cav, float Lav, float Lmin, float Lmax) {\n", "float f = exp(-f_i);\n", "vec3 LUMINANCE = vec3(0.2125, 0.7154, 0.0721);\n", "float L = dot(rgb, LUMINANCE);\n", "vec3 I_l = c * rgb + (1.0-c) * L;\n", "vec3 I_g = c * Cav + (1.0-c) * Lav;\n", "vec3 I_a = a * I_l + (1.0-a) * I_g;\n", "rgb /= (rgb + vec3 (\t pow(f * I_a.r, m),\n\t\t\t\t\t\t pow(f * I_a.g, m),\n\t\t\t\t\t\t pow(f * I_a.b, m)\n\t\t\t)\t\t\t);\n", "}\n", "void main() {\n", " vec4 color = texture2DRect(inputTex, gl_FragCoord.st);\n", " vec3 col = color.rgb;\n", " vec4 Cav = texture2DRect(averageTex, vec2(0.5));\n", " vec4 lumin = texture2DRect(luminTex, vec2(0.5));\n", " float Lmin = lumin.r;\n", " float Lav = lumin.g;\n", " float Lmax = lumin.b;\n", " float Colmax = Cav.a;\n", " if(Colmax==0.0) {\n", "  gl_FragColor = vec4(vec3(0.0), color.a);", "  return;", " }", " float f = 0.0;", "\tfloat a = 0.0;", "\tfloat c = 1.0;", " float m = 0.3 + 0.7 * pow( (log(Lmax) - log(Lav)) / (log(Lmax) - log(Lmin)), 1.4 );", " tone(col, f, m, a, c, Cav.rgb, Lav, Lmin, Lmax);", " vec3 colScaled = color.rgb / Lmax;", " gl_FragColor = vec4(colScaled, color.a);", "}"};
        }

        @Override
        protected String[] getFragmentShader(Object object) {
            return this.toneMappedS;
        }

        @Override
        public GLSLShader getInstance() {
            return this;
        }

        @Override
        public Class<?> instanceFor() {
            return null;
        }

        @Override
        public boolean needsRecompilation(Object object) {
            return false;
        }

        @Override
        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 2);
            n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "luminTex");
            gL.glUniform1i(n, 0);
            n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "averageTex");
            gL.glUniform1i(n, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SimpleTonemappingShader
    extends GLSLShader {
        final String[] toneMappedS;

        public SimpleTonemappingShader(OpenGLState openGLState) {
            super(openGLState);
            this.toneMappedS = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect inputTex;\n", "uniform sampler2DRect luminTex;\n", "uniform sampler2DRect averageTex;\n", "varying vec2 TexUnit;\n", "void tone(inout vec3 rgb, float f_i, float m, float a, float c, vec3 Cav, float Lav, float Lmin, float Lmax) {\n", "float f = exp(-f_i);\n", "vec3 LUMINANCE = vec3(0.2125, 0.7154, 0.0721);\n", "float L = dot(rgb, LUMINANCE);\n", "vec3 I_l = c * rgb + (1.0-c) * L;\n", "vec3 I_g = c * Cav + (1.0-c) * Lav;\n", "vec3 I_a = a * I_l + (1.0-a) * I_g;\n", "rgb /= (rgb + vec3 (\t pow(f * I_a.r, m),\n\t\t\t\t\t\t pow(f * I_a.g, m),\n\t\t\t\t\t\t pow(f * I_a.b, m)\n\t\t\t)\t\t\t);\n", "}\n", "void main() {\n", " vec4 color = texture2DRect(inputTex, gl_FragCoord.st);\n", " vec3 col = color.rgb;\n", " vec4 Cav = texture2DRect(averageTex, vec2(0.5));\n", " vec4 lumin = texture2DRect(luminTex, vec2(0.5));\n", " float Lmin = lumin.r;\n", " float Lav = lumin.g;\n", " float Lmax = lumin.b;\n", " float Colmax = Cav.a;\n", " Colmax = Colmax != 0.0 ? 1.0/Colmax : 1.0;\n", " gl_FragColor = vec4( (color.rgb) * (Colmax) , color.a);\n", "}"};
        }

        @Override
        protected String[] getFragmentShader(Object object) {
            return this.toneMappedS;
        }

        @Override
        public GLSLShader getInstance() {
            return this;
        }

        @Override
        public Class<?> instanceFor() {
            return null;
        }

        @Override
        public boolean needsRecompilation(Object object) {
            return false;
        }

        @Override
        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 2);
            n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "luminTex");
            gL.glUniform1i(n, 0);
            n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "averageTex");
            gL.glUniform1i(n, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StaticTonemappingShader
    extends GLSLShader {
        final String[] toneMappedS;
        int brightnessLoc;

        public StaticTonemappingShader(OpenGLState openGLState) {
            super(openGLState);
            this.toneMappedS = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect inputTex;\n", "uniform float brightness;\n", "void main() {\n", " vec4 color = texture2DRect(inputTex, gl_FragCoord.st);\n", " vec3 col = color.rgb;\n", " gl_FragColor = vec4( (color.rgb) * (brightness != 0.0 ? brightness : 1.0) , color.a);\n", "}"};
            this.brightnessLoc = -1;
        }

        @Override
        protected String[] getFragmentShader(Object object) {
            return this.toneMappedS;
        }

        @Override
        public GLSLShader getInstance() {
            return this;
        }

        @Override
        public Class<?> instanceFor() {
            return null;
        }

        @Override
        public boolean needsRecompilation(Object object) {
            return false;
        }

        @Override
        protected void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
            gL.glUniform1f(this.brightnessLoc, gLSLDisplay.getBrightness());
        }

        @Override
        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 2);
            this.brightnessLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), "brightness");
        }
    }
}

