/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class PreprocessPass
extends FullRenderPass {
    GLSLShader cs = null;

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof LightPos);
        GL gL = openGLState.getGL();
        openGLState.disable('\u0001');
        openGLState.setDepthMask(true);
        openGLState.enable('\u0002');
        PreprocessPass.ViewPerspective(openGLState);
        gL.glPopAttrib();
        PreprocessPass.deactivateTextures(gL, 4);
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        GL gL = openGLState.getGL();
        openGLState.switchFloatRT();
        openGLState.getHDRFBO().drawBuffer(openGLState, openGLState.getFloatRT());
        gL.glPushAttrib(2048);
        gL.glViewport(0, 0, openGLState.width, openGLState.height);
        GLSLDisplay.printDebugInfoN("Preprocessing: " + (4 + openGLState.getFloatRT()));
        if (this.cs == null) {
            this.cs = new PrepareLightingShader(openGLState);
        }
        this.cs.activateShader(openGLState, gLSLDisplay, null);
        PreprocessPass.ViewOrtho(openGLState);
        openGLState.disable('\u0002');
        openGLState.setDepthMask(false);
        openGLState.getDeferredShadingFBO().bindAllAttachmentsAsTextures(openGLState);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRTLast(), 4);
        openGLState.enable('\u0001');
        gL.glStencilFunc(514, 1, 1);
        gL.glStencilOp(7680, 7680, 7680);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        PreprocessPass.drawPrjQuad(openGLState, camera);
    }

    class PrepareLightingShader
    extends GLSLShader {
        final String[] baseLightF;

        public PrepareLightingShader(OpenGLState openGLState) {
            super(openGLState);
            this.baseLightF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect firstTex;\n", "uniform sampler2DRect secondTex;\n", "uniform sampler2DRect thirdTex;\n", "uniform sampler2DRect fourthTex;\n", "uniform sampler2DRect fithTex;\n", "void main() {\n", "\tvec4 diffuse = texture2DRect(secondTex, gl_FragCoord.st);\n", "\tvec4 em = texture2DRect(thirdTex, gl_FragCoord.st);\n", "\tvec4 alpha = texture2DRect(fourthTex, gl_FragCoord.st);\n", "\tgl_FragColor = (vec4(alpha.rgb, alpha.r)) * texture2DRect(fithTex, gl_FragCoord.st) + (vec4(1.) - vec4(alpha.rgb, alpha.r)) * vec4(em.rgb, 0.0);\n", "}"};
        }

        public String[] getFragmentShader(Object object) {
            return this.baseLightF;
        }

        public void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "firstTex");
            int n2 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "secondTex");
            int n3 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "thirdTex");
            int n4 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "fourthTex");
            int n5 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "fithTex");
            gL.glUniform1i(n, 0);
            gL.glUniform1i(n2, 1);
            gL.glUniform1i(n3, 2);
            gL.glUniform1i(n4, 3);
            gL.glUniform1i(n5, 4);
        }
    }
}

