/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.vecmath.Math2;
import java.awt.image.BufferedImage;

public class SimplexNoise {
    static final String simplexSig = "void simplex( const in vec3 P, out vec3 offset1, out vec3 offset2 )";
    static final String simplex = "\t\t\tvec3 offset0;\n\t\t\tvec2 isX = step( P.yz, P.xx );\n\t\t\toffset0.x  = dot( isX, vec2( 1.0 ) );\n\t\t\toffset0.yz = 1.0 - isX;\n\t\t\tfloat isY = step( P.z, P.y );\n\t\t\toffset0.y += isY;\n\t\t\toffset0.z += 1.0 - isY;\n\t\t\toffset2 = clamp(   offset0, 0.0, 1.0 );\n\t\t\toffset1 = clamp( --offset0, 0.0, 1.0 );";
    static final String noise3dSig = "float inoise(vec3 P)";
    static final String noise3dbody = "\t\t#define ONE 0.00390625\n\t\t#define ONEHALF 0.001953125\n\t\t#define F3 0.333333333333\n\t\t#define G3 0.166666666667\n\t\t  float s = (P.x + P.y + P.z) * F3;\n\t\t  vec3 Pi = floor(P + s);\n\t\t  float t = (Pi.x + Pi.y + Pi.z) * G3;\n\t\t  vec3 P0 = Pi - t;\n\t\t  Pi = Pi * ONE + ONEHALF;\n\t\t  vec3 Pf0 = P - P0;\n\t\t  vec3 o1;\n\t\t  vec3 o2;\n\t\t  simplex(Pf0, o1, o2);\n\t\t  float perm0 = perm(Pi.xy).a;\n\t\t  vec3  grad0 = perm(vec2(perm0, Pi.z)).rgb * 4.0 - 1.0;\n\t\t  float t0 = 0.6 - dot(Pf0, Pf0);\n\t\t  float t20 = 0.0;\n\t\t  float t40 = 0.0;\n\t\t  float n0;\n\t\t  if (t0 < 0.0) n0 = 0.0;\n\t\t  else {\n\t\t    t20 = t0 * t0;\n\t\t    t40 = t20 * t20;\n\t\t    n0 = t40 * dot(grad0, Pf0);\n\t\t  }\n\t\t  vec3 Pf1 = Pf0 - o1 + G3;\n\t\t  float perm1 = perm(Pi.xy + o1.xy*ONE).a;\n\t\t  vec3  grad1 = perm(vec2(perm1, Pi.z + o1.z*ONE)).rgb * 4.0 - 1.0;\n\t\t  float t1 = 0.6 - dot(Pf1, Pf1);\n\t\t  float t21 = 0.0;\n\t\t  float t41 = 0.0;\n\t\t  float n1;\n\t\t  if (t1 < 0.0) n1 = 0.0;\n\t\t  else {\n\t\t    t21 = t1 * t1;\n\t\t    t41 = t21 * t21;\n\t\t    n1 = t41 * dot(grad1, Pf1);\n\t\t  }\n\t\t  vec3 Pf2 = Pf0 - o2 + 2.0 * G3;\n\t\t  float perm2 = perm(Pi.xy + o2.xy*ONE).a;\n\t\t  vec3  grad2 = perm(vec2(perm2, Pi.z + o2.z*ONE)).rgb * 4.0 - 1.0;\n\t\t  float t2 = 0.6 - dot(Pf2, Pf2);\n\t\t  float t22 = 0.0;\n\t\t  float t42 = 0.0;\n\t\t  float n2;\n\t\t  if (t2 < 0.0) n2 = 0.0;\n\t\t  else {\n\t\t    t22 = t2 * t2;\n\t\t    t42 = t22 * t22;\n\t\t    n2 = t42 * dot(grad2, Pf2);\n\t\t  }\n\t\t  vec3 Pf3 = Pf0 - vec3(1.0-3.0*G3);\n\t\t  float perm3 = perm(Pi.xy + vec2(ONE, ONE)).a;\n\t\t  vec3  grad3 = perm(vec2(perm3, Pi.z + ONE)).rgb * 4.0 - 1.0;\n\t\t  float t3 = 0.6 - dot(Pf3, Pf3);\n\t\t  float t23 = 0.0;\n\t\t  float t43 = 0.0;\n\t\t  float n3;\n\t\t  if(t3 < 0.0) n3 = 0.0;\n\t\t  else {\n\t\t    t23 = t3 * t3;\n\t\t    t43 = t23 * t23;\n\t\t    n3 = t43 * dot(grad3, Pf3);\n\t\t  }\n";
    static final String noise3d = "\t\t#define ONE 0.00390625\n\t\t#define ONEHALF 0.001953125\n\t\t#define F3 0.333333333333\n\t\t#define G3 0.166666666667\n\t\t  float s = (P.x + P.y + P.z) * F3;\n\t\t  vec3 Pi = floor(P + s);\n\t\t  float t = (Pi.x + Pi.y + Pi.z) * G3;\n\t\t  vec3 P0 = Pi - t;\n\t\t  Pi = Pi * ONE + ONEHALF;\n\t\t  vec3 Pf0 = P - P0;\n\t\t  vec3 o1;\n\t\t  vec3 o2;\n\t\t  simplex(Pf0, o1, o2);\n\t\t  float perm0 = perm(Pi.xy).a;\n\t\t  vec3  grad0 = perm(vec2(perm0, Pi.z)).rgb * 4.0 - 1.0;\n\t\t  float t0 = 0.6 - dot(Pf0, Pf0);\n\t\t  float t20 = 0.0;\n\t\t  float t40 = 0.0;\n\t\t  float n0;\n\t\t  if (t0 < 0.0) n0 = 0.0;\n\t\t  else {\n\t\t    t20 = t0 * t0;\n\t\t    t40 = t20 * t20;\n\t\t    n0 = t40 * dot(grad0, Pf0);\n\t\t  }\n\t\t  vec3 Pf1 = Pf0 - o1 + G3;\n\t\t  float perm1 = perm(Pi.xy + o1.xy*ONE).a;\n\t\t  vec3  grad1 = perm(vec2(perm1, Pi.z + o1.z*ONE)).rgb * 4.0 - 1.0;\n\t\t  float t1 = 0.6 - dot(Pf1, Pf1);\n\t\t  float t21 = 0.0;\n\t\t  float t41 = 0.0;\n\t\t  float n1;\n\t\t  if (t1 < 0.0) n1 = 0.0;\n\t\t  else {\n\t\t    t21 = t1 * t1;\n\t\t    t41 = t21 * t21;\n\t\t    n1 = t41 * dot(grad1, Pf1);\n\t\t  }\n\t\t  vec3 Pf2 = Pf0 - o2 + 2.0 * G3;\n\t\t  float perm2 = perm(Pi.xy + o2.xy*ONE).a;\n\t\t  vec3  grad2 = perm(vec2(perm2, Pi.z + o2.z*ONE)).rgb * 4.0 - 1.0;\n\t\t  float t2 = 0.6 - dot(Pf2, Pf2);\n\t\t  float t22 = 0.0;\n\t\t  float t42 = 0.0;\n\t\t  float n2;\n\t\t  if (t2 < 0.0) n2 = 0.0;\n\t\t  else {\n\t\t    t22 = t2 * t2;\n\t\t    t42 = t22 * t22;\n\t\t    n2 = t42 * dot(grad2, Pf2);\n\t\t  }\n\t\t  vec3 Pf3 = Pf0 - vec3(1.0-3.0*G3);\n\t\t  float perm3 = perm(Pi.xy + vec2(ONE, ONE)).a;\n\t\t  vec3  grad3 = perm(vec2(perm3, Pi.z + ONE)).rgb * 4.0 - 1.0;\n\t\t  float t3 = 0.6 - dot(Pf3, Pf3);\n\t\t  float t23 = 0.0;\n\t\t  float t43 = 0.0;\n\t\t  float n3;\n\t\t  if(t3 < 0.0) n3 = 0.0;\n\t\t  else {\n\t\t    t23 = t3 * t3;\n\t\t    t43 = t23 * t23;\n\t\t    n3 = t43 * dot(grad3, Pf3);\n\t\t  }\nreturn 0.00104006 + 32.741 * (n0 + n1 + n2 + n3);";
    static final String dnoise3dSig = "vec3 dinoise(vec3 P)";
    static final String dnoise3d = "\t\t#define ONE 0.00390625\n\t\t#define ONEHALF 0.001953125\n\t\t#define F3 0.333333333333\n\t\t#define G3 0.166666666667\n\t\t  float s = (P.x + P.y + P.z) * F3;\n\t\t  vec3 Pi = floor(P + s);\n\t\t  float t = (Pi.x + Pi.y + Pi.z) * G3;\n\t\t  vec3 P0 = Pi - t;\n\t\t  Pi = Pi * ONE + ONEHALF;\n\t\t  vec3 Pf0 = P - P0;\n\t\t  vec3 o1;\n\t\t  vec3 o2;\n\t\t  simplex(Pf0, o1, o2);\n\t\t  float perm0 = perm(Pi.xy).a;\n\t\t  vec3  grad0 = perm(vec2(perm0, Pi.z)).rgb * 4.0 - 1.0;\n\t\t  float t0 = 0.6 - dot(Pf0, Pf0);\n\t\t  float t20 = 0.0;\n\t\t  float t40 = 0.0;\n\t\t  float n0;\n\t\t  if (t0 < 0.0) n0 = 0.0;\n\t\t  else {\n\t\t    t20 = t0 * t0;\n\t\t    t40 = t20 * t20;\n\t\t    n0 = t40 * dot(grad0, Pf0);\n\t\t  }\n\t\t  vec3 Pf1 = Pf0 - o1 + G3;\n\t\t  float perm1 = perm(Pi.xy + o1.xy*ONE).a;\n\t\t  vec3  grad1 = perm(vec2(perm1, Pi.z + o1.z*ONE)).rgb * 4.0 - 1.0;\n\t\t  float t1 = 0.6 - dot(Pf1, Pf1);\n\t\t  float t21 = 0.0;\n\t\t  float t41 = 0.0;\n\t\t  float n1;\n\t\t  if (t1 < 0.0) n1 = 0.0;\n\t\t  else {\n\t\t    t21 = t1 * t1;\n\t\t    t41 = t21 * t21;\n\t\t    n1 = t41 * dot(grad1, Pf1);\n\t\t  }\n\t\t  vec3 Pf2 = Pf0 - o2 + 2.0 * G3;\n\t\t  float perm2 = perm(Pi.xy + o2.xy*ONE).a;\n\t\t  vec3  grad2 = perm(vec2(perm2, Pi.z + o2.z*ONE)).rgb * 4.0 - 1.0;\n\t\t  float t2 = 0.6 - dot(Pf2, Pf2);\n\t\t  float t22 = 0.0;\n\t\t  float t42 = 0.0;\n\t\t  float n2;\n\t\t  if (t2 < 0.0) n2 = 0.0;\n\t\t  else {\n\t\t    t22 = t2 * t2;\n\t\t    t42 = t22 * t22;\n\t\t    n2 = t42 * dot(grad2, Pf2);\n\t\t  }\n\t\t  vec3 Pf3 = Pf0 - vec3(1.0-3.0*G3);\n\t\t  float perm3 = perm(Pi.xy + vec2(ONE, ONE)).a;\n\t\t  vec3  grad3 = perm(vec2(perm3, Pi.z + ONE)).rgb * 4.0 - 1.0;\n\t\t  float t3 = 0.6 - dot(Pf3, Pf3);\n\t\t  float t23 = 0.0;\n\t\t  float t43 = 0.0;\n\t\t  float n3;\n\t\t  if(t3 < 0.0) n3 = 0.0;\n\t\t  else {\n\t\t    t23 = t3 * t3;\n\t\t    t43 = t23 * t23;\n\t\t    n3 = t43 * dot(grad3, Pf3);\n\t\t  }\nvec3 D = -8. * t20 * t0 * Pf0 * dot(grad0, Pf0) + t40 * grad0;\nD += -8. * t21 * t1 * Pf1 * dot(grad1, Pf1) + t41 * grad1;\nD += -8. * t22 * t2 * Pf2 * dot(grad2, Pf2) + t42 * grad2;\nD += -8. * t23 * t3 * Pf3 * dot(grad3, Pf3) + t43 * grad3;\nreturn D * 16.9446;\n";
    static final String turb3dSig = "float turbulence(vec3 f, int octaves, float lambda, float omega)";
    static final String turb3d = "float v = inoise (f);float l = lambda, o = omega;for (int i = octaves-1; i > 0; --i){v += o * inoise (f * l);if (i > 1){l *= lambda;o *= omega;}}return v;";
    static final String dturb3dSig = "vec3 dturbulence(vec3 f, int octaves, float lambda, float omega)";
    static final String dturb3d = "vec3 v = dinoise (f);float l = lambda, o = omega;for (int i = octaves-1; i > 0; --i){v += o * dinoise (f * l);if (i > 1){l *= lambda;o *= omega;}}return v;";
    static BufferedImage permImage;
    static BufferedImage gradImage;
    static String permSampler;
    static boolean init;
    static int PermutationTexture;
    static final int[][] grad3;

    public static BufferedImage generatePermutationTexture() {
        BufferedImage bufferedImage = new BufferedImage(256, 256, 2);
        int[] nArray = new int[4];
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            for (int n = 0; n < 256; n = (int)((char)(n + 1))) {
                char c2 = Math2.random((char)((char)(n + Math2.random((char)c) & 0xFF)));
                nArray[0] = grad3[c2 & 0xF][0] * 64 + 64;
                nArray[1] = grad3[c2 & 0xF][1] * 64 + 64;
                nArray[2] = grad3[c2 & 0xF][2] * 64 + 64;
                nArray[3] = c2;
                bufferedImage.setRGB(n, c, nArray[3] << 24 | nArray[0] << 16 | nArray[1] << 8 | nArray[2]);
            }
        }
        return bufferedImage;
    }

    static void regLookUpTexture(ShaderConfiguration shaderConfiguration) {
        if (!init) {
            permImage = SimplexNoise.generatePermutationTexture();
            init = true;
        }
        permSampler = shaderConfiguration.registerTexture(permImage);
    }

    public static String registerTurbWithUnroll(ShaderConfiguration shaderConfiguration, int n) {
        String string = "float turbulence_" + n + "(vec3 f, float lambda, float omega)";
        String string2 = "float v = inoise (f);float l = lambda, o = omega;";
        for (int i = n - 1; i > 1; --i) {
            string2 = string2 + "v += o * inoise (f * l);l *= lambda;o *= omega;";
        }
        if (n - 1 > 1) {
            string2 = string2 + "v += o * inoise (f * l);";
        }
        string2 = string2 + "return v;";
        shaderConfiguration.registerFunc(string, string2);
        return "turbulence_" + n;
    }

    public static String registerDTurbWithUnroll(ShaderConfiguration shaderConfiguration, int n) {
        String string = "vec3 dturbulence_" + n + "(vec3 f, float lambda, float omega)";
        String string2 = "vec3 v = dinoise (f);float l = lambda, o = omega;";
        for (int i = n - 1; i > 1; --i) {
            string2 = string2 + "v += o * dinoise (f * l);l *= lambda;o *= omega;";
        }
        if (n - 1 > 1) {
            string2 = string2 + "v += o * dinoise (f * l);";
        }
        string2 = string2 + "return v;";
        shaderConfiguration.registerFunc(string, string2);
        return "dturbulence_" + n;
    }

    public static void registerNoiseFunctions(ShaderConfiguration shaderConfiguration) {
        SimplexNoise.regLookUpTexture(shaderConfiguration);
        shaderConfiguration.registerFunc("vec4 perm(vec2 x)", "return texture2D(" + permSampler + ", x);");
        shaderConfiguration.registerFunc(simplexSig, simplex);
        shaderConfiguration.registerFunc(noise3dSig, noise3d);
        shaderConfiguration.registerFunc(turb3dSig, turb3d);
    }

    public static void registerdNoiseFunctions(ShaderConfiguration shaderConfiguration) {
        SimplexNoise.regLookUpTexture(shaderConfiguration);
        shaderConfiguration.registerFunc("vec4 perm(vec2 x)", "return texture2D(" + permSampler + ", x);");
        shaderConfiguration.registerFunc(simplexSig, simplex);
        shaderConfiguration.registerFunc(dnoise3dSig, dnoise3d);
        shaderConfiguration.registerFunc(dturb3dSig, dturb3d);
    }

    static {
        init = false;
        PermutationTexture = 0;
        grad3 = new int[][]{{0, 1, 1}, {0, 1, -1}, {0, -1, 1}, {0, -1, -1}, {1, 0, 1}, {1, 0, -1}, {-1, 0, 1}, {-1, 0, -1}, {1, 1, 0}, {1, -1, 0}, {-1, 1, 0}, {-1, -1, 0}, {1, 0, -1}, {-1, 0, -1}, {0, -1, 1}, {0, 1, 1}};
    }
}

