/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

public class Result {
    public static final int ET_UNKNOWN = -1;
    public static final int ET_FLOAT = 0;
    public static final int ET_VEC2 = 1;
    public static final int ET_VEC3 = 2;
    public static final int ET_VEC4 = 3;
    public static final int ET_BOOL = 4;
    String term;
    int returnType;
    private static final String[] typeNames = new String[]{"float", "vec2", "vec3", "vec4", "bool"};
    private static final String[][][] convMat = new String[][][]{{{"", ""}, {"vec2(", ")"}, {"vec3(", ")"}, {"vec4(vec3(", "),1.0)"}}, {{"dot(", ",vec2(.5))"}, {"", ""}, {"vec3(", ",0.0)"}, {"vec4(", ", 0.0, 1.0)"}}, {{"dot(", ",vec3(1./3.))"}, {"(", ").xy"}, {"", ""}, {"vec4(", ",1.0)"}}, {{"dot(", ",vec4(.25))"}, {"(", ").xy"}, {"(", ").xyz"}, {"", ""}}};
    private static final String[][][] reduceMat = new String[][][]{{{"", ""}, {"vec2(", ",0.)"}, {"vec3(", ",0.,0.)"}, {"vec4(", "0.,1.,0.)"}}, {{"(", ").x"}, {"", ""}, {"vec3(", ",0.)"}, {"vec4(", ", 1.,0.)"}}, {{"(", ").x"}, {"(", ").xy"}, {"", ""}, {"vec4(", ",0.)"}}, {{"(", ").x"}, {"(", ").xy"}, {"(", ").xyz"}, {"", ""}}};

    public int getReturnType() {
        return this.returnType;
    }

    public Result(String string, int n) {
        this.term = string;
        this.returnType = n;
    }

    public static String getTypeString(int n) {
        return typeNames[n];
    }

    public String convert(int n) {
        if (this.returnType > 3 || n > 3) {
            return this.term;
        }
        return convMat[this.returnType][n][0] + this.term + convMat[this.returnType][n][1];
    }

    public String reduce(int n) {
        if (this.returnType > 3 || n > 3) {
            return this.term;
        }
        return reduceMat[this.returnType][n][0] + this.term + reduceMat[this.returnType][n][1];
    }

    public String toString() {
        return this.term;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.returnType;
        n = 31 * n + (this.term == null ? 0 : this.term.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Result result = (Result)object;
        if (this.returnType != result.returnType) {
            return false;
        }
        return !(this.term == null ? result.term != null : !this.term.equals(result.term));
    }
}

