/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.light.LightingProcessPass;
import de.grogra.imp3d.glsl.renderpass.CopyFloatTexturePass;
import de.grogra.imp3d.glsl.renderpass.RenderPass;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.Sky;
import de.grogra.vecmath.Math2;
import javax.media.opengl.GL;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ProcessLightingPass
extends RenderPass {
    private LightingProcessPass lpp = new LightingProcessPass();
    private CopyFloatTexturePass cftp = new CopyFloatTexturePass();
    DirectionalLight defaultLight = null;
    Matrix4d defaultLightToWorld = new Matrix4d();
    Point3d p = new Point3d(-3000.0, 3000.0, 10000.0);
    Vector3d v = new Vector3d((Tuple3d)this.p);
    Matrix3d m = new Matrix3d();
    LightPos defaultLightPos = null;

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        this.DrawLights(gLSLDisplay, openGLState);
    }

    public void DrawLights(GLSLDisplay gLSLDisplay, OpenGLState openGLState) {
        boolean bl = false;
        GL gL = openGLState.getGL();
        openGLState.enable('\u0001');
        gL.glStencilFunc(517, 1, 1);
        gL.glStencilOp(7680, 7680, 7680);
        this.cftp.process(gLSLDisplay, openGLState, null);
        if (gLSLDisplay.isOptionLighting()) {
            for (LightPos lightPos : openGLState.defLight) {
                if (!gLSLDisplay.isOptionShowDiffuseSkyLight() && lightPos.getLight() instanceof Sky) continue;
                this.lpp.process(gLSLDisplay, openGLState, lightPos);
                if (lightPos.getLight().getLightType() == 0) continue;
                bl = true;
            }
        }
        if (!bl) {
            LightPos lightPos = this.getDefaultLight(gLSLDisplay);
            this.lpp.process(gLSLDisplay, openGLState, lightPos);
        }
    }

    private LightPos getDefaultLight(GLSLDisplay gLSLDisplay) {
        Math2.makeAffine((Matrix4d)this.defaultLightToWorld);
        Math2.invertAffine((Matrix4d)gLSLDisplay.getCurrentGLState().getWorldToView(), (Matrix4d)this.defaultLightToWorld);
        this.p.set(-3000.0, 3000.0, 10000.0);
        this.v.negate((Tuple3d)this.p);
        this.defaultLightToWorld.transform(this.p);
        this.defaultLightToWorld.transform(this.v);
        Math2.getOrthogonalBasis((Tuple3d)this.v, (Matrix3d)this.m, (boolean)true);
        this.defaultLightToWorld.set(this.m);
        this.defaultLightToWorld.m03 = this.p.x;
        this.defaultLightToWorld.m13 = this.p.y;
        this.defaultLightToWorld.m23 = this.p.z;
        if (this.defaultLight == null) {
            this.defaultLight = new DirectionalLight();
            this.defaultLight.setShadowless(true);
            this.defaultLight.getColor().set(1.0f, 1.0f, 1.0f);
        }
        if (this.defaultLightPos == null) {
            this.defaultLightPos = new LightPos(this.defaultLight, this.defaultLightToWorld);
        } else {
            this.defaultLightPos.setLightPos(this.defaultLightToWorld);
        }
        return this.defaultLightPos;
    }
}

