/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightCollection;
import de.grogra.imp3d.glsl.light.shadow.ShadowLightCollection;
import de.grogra.imp3d.glsl.utility.GLSLManagedShader;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.ray.physics.Light;
import java.util.Iterator;
import javax.media.opengl.GL;

public class LightShaderConfiguration
extends ShaderConfiguration {
    boolean shadow;
    boolean perspective;
    boolean physical;
    private static final String getPosSig = "vec3 getEyePos(vec2 depth)";
    private static final String getPos = " return vec3(TexCoord2.st, -1.0) * dot(fract(depth), vec2(1., 1./1024.)) * farplane;";
    private static final String getPosSigParallel = "vec3 getEyePos(vec2 depth)";
    private static final String getPosParallel = " return vec3(TexCoord2.st, - dot(fract(depth), vec2(1., 0.0009765625) ) * farplane );";
    public static final String getNormalSig = "vec3 getEyeNormal(vec2 encNorm)";
    public static final String getNormal = " encNorm = encNorm*4.0-2.0;\n float f = dot(encNorm,encNorm);\n float g = sqrt(1.0-f*0.25);\n return vec3(encNorm*g,1.0-f*0.5);\n";
    int farLoc = -1;

    protected void setThisToOther(ShaderConfiguration shaderConfiguration) {
        super.setThisToOther(shaderConfiguration);
        assert (shaderConfiguration instanceof LightShaderConfiguration);
        LightShaderConfiguration lightShaderConfiguration = (LightShaderConfiguration)shaderConfiguration;
        this.shadow = lightShaderConfiguration.shadow;
        this.perspective = lightShaderConfiguration.perspective;
        this.physical = lightShaderConfiguration.physical;
    }

    public ShaderConfiguration clone() {
        LightShaderConfiguration lightShaderConfiguration = new LightShaderConfiguration();
        lightShaderConfiguration.setThisToOther(this);
        return lightShaderConfiguration;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.perspective ? 1231 : 1237);
        n = 31 * n + (this.shadow ? 1231 : 1237);
        n = 31 * n + (this.physical ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LightShaderConfiguration lightShaderConfiguration = (LightShaderConfiguration)object;
        if (this.perspective != lightShaderConfiguration.perspective) {
            return false;
        }
        if (this.shadow != lightShaderConfiguration.shadow) {
            return false;
        }
        return this.physical == lightShaderConfiguration.physical;
    }

    public void set(OpenGLState openGLState, GLSLDisplay gLSLDisplay, Object object) {
        super.set(openGLState, gLSLDisplay, object);
        assert (object instanceof Light);
        this.shadow = !((Light)object).isShadowless() && gLSLDisplay.isOptionShowShadows();
        this.perspective = !(gLSLDisplay.getView3D().getCamera().getProjection() instanceof ParallelProjection);
        this.physical = gLSLDisplay.isOptionPhysicalLighting();
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public String toString() {
        return super.toString() + " - Reference: " + (this.getReferenceKeyValue() == null ? "(null)" : this.getReferenceKeyValue().toString()) + " - shadow: " + this.shadow + " - perspective: " + this.perspective + " - physical: " + this.physical;
    }

    public void registerEyePosFunc() {
        if (this.isPerspective()) {
            this.registerFunc("vec3 getEyePos(vec2 depth)", getPos);
        } else {
            this.registerFunc("vec3 getEyePos(vec2 depth)", getPosParallel);
        }
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, int n) {
        super.setupDynamicUniforms(gL, gLSLDisplay, n);
        gL.glUniform1f(this.farLoc, gLSLDisplay.getView3D().getCamera().getZFar());
    }

    public void setupShader(GL gL, GLSLDisplay gLSLDisplay, int n) {
        int n2 = gL.glGetUniformLocation(n, "firstTex");
        int n3 = gL.glGetUniformLocation(n, "secondTex");
        int n4 = gL.glGetUniformLocation(n, "thirdTex");
        int n5 = gL.glGetUniformLocation(n, "fourthTex");
        int n6 = gL.glGetUniformLocation(n, "fithTex");
        int n7 = gL.glGetUniformLocation(n, "alphaTex");
        int n8 = gL.glGetUniformLocation(n, "zTex");
        this.farLoc = gL.glGetUniformLocation(n, "farplane");
        gL.glUniform1i(n2, 0);
        gL.glUniform1i(n3, 1);
        gL.glUniform1i(n4, 2);
        gL.glUniform1i(n5, 3);
        gL.glUniform1i(n6, 4);
        gL.glUniform1i(n7, 5);
        gL.glUniform1i(n8, 8);
    }

    public String[] completeShader(String string) {
        String string2 = "#version " + this.version + "\n#extension GL_ARB_draw_buffers : enable\n#extension GL_ARB_texture_rectangle : enable\n";
        string2 = string2 + "\n";
        string2 = string2 + "varying vec2 TexCoord;\n";
        string2 = string2 + "varying vec2 TexCoord2;\n\n";
        for (int i = 0; i < this.uniform.size(); ++i) {
            string2 = string2 + (String)this.uniform.elementAt(i);
        }
        if (this.uniform.size() > 0) {
            string2 = string2 + "\n";
        }
        string2 = string2 + "uniform float farplane;\n";
        string2 = string2 + "uniform sampler2DRect firstTex;\n";
        string2 = string2 + "uniform sampler2DRect secondTex;\n";
        string2 = string2 + "uniform sampler2DRect thirdTex;\n";
        string2 = string2 + "uniform sampler2DRect fourthTex;\n";
        string2 = string2 + "uniform sampler2DRect fithTex;\n";
        string2 = string2 + "uniform sampler2DRect alphaTex;\n";
        string2 = string2 + "uniform sampler2D zTex;\n";
        this.registerEyePosFunc();
        Iterator iterator = this.funcMap.values().iterator();
        while (iterator.hasNext()) {
            string2 = string2 + (String)iterator.next();
        }
        if (this.funcMap.size() > 0) {
            string2 = string2 + "\n";
        }
        string2 = string2 + "vec2 unpackFromFloat(float src) {\n float exp = floor(log2(src));\n src = (src*(1.0 / exp2(exp))-1.0) * 8.;\n return vec2( (floor(src) * 0.0078125 + exp * 0.0625) * 256. / 255. , fract(src) * 256. / 255. );\n}\n\n";
        string2 = string2 + "void main() {\n";
        for (int i = 0; i < this.var.size(); ++i) {
            string2 = string2 + " " + (String)this.var.elementAt(i);
        }
        if (this.var.size() > 0) {
            string2 = string2 + "\n";
        }
        string2 = string2 + "\tvec4 posshine = texture2DRect(firstTex, gl_FragCoord.st);\n\tvec4 diffuseEm = texture2DRect(secondTex, gl_FragCoord.st);\n\tvec3 diffuse = diffuseEm.rgb;\n\tvec3 emissive = vec3(unpackFromFloat(diffuseEm.a),0.);\n\tvec4 specemdifftransp = texture2DRect(thirdTex, gl_FragCoord.st);\n\tvec3 specular = specemdifftransp.rgb;\n\tvec3 diffTransp = vec3(unpackFromFloat(specemdifftransp.a),0.0);\n\temissive.b = diffTransp.r;\n\tvec4 alpha = texture2DRect(fourthTex, gl_FragCoord.st);\n\tdiffTransp = vec3(diffTransp.g, unpackFromFloat(alpha.a));\n\tvec2 norm = posshine.rg;\n\tfloat shininess = posshine.b;\n\tfloat transpShininess = posshine.a;\n\tvec3 diff = vec3(0.0);\n\tvec3 spec = vec3(0.0);\n\tvec4 frontAlpha = texture2DRect(alphaTex, gl_FragCoord.st);\n\tvec4 zNorm = gl_TextureMatrix[4] * vec4(0., 0., texture2D(zTex, TexCoord.st).r*2.-1., 1.);\n\tzNorm /= zNorm.w;\n";
        string2 = string2 + (this.isPerspective() ? " vec3 pos = vec3(-TexCoord2.st * zNorm.z, zNorm.z) ;\n" : " vec3 pos = vec3(TexCoord2.st, zNorm.z);\n");
        string2 = string2 + string;
        string2 = string2 + "\tvec4 color = texture2DRect(fithTex, gl_FragCoord.st)\n + vec4( ((frontAlpha.rgb) * (1. - alpha.rgb) * (diff * diffuse.rgb + spec * specular)), 0.0);\n\tgl_FragColor = color;\n}";
        String[] stringArray = new String[]{string2};
        return stringArray;
    }

    public GLSLManagedShader getShaderByDefaultCollection(GLSLDisplay gLSLDisplay, Object object) {
        return gLSLDisplay.isOptionShowShadows() && !((Light)object).isShadowless() ? ShadowLightCollection.getGLSLManagedObject(object) : LightCollection.getGLSLManagedObject(object);
    }
}

