/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.light.GLSLLightShader;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.vecmath.Math2;
import javax.media.opengl.GL;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3f;

public class GLSLSpotLight
extends GLSLLightShader {
    static final String SpotLightPrologue = "void SpotLight(in vec3 normal,\nin vec3 eye,\nin vec3 ecPosition3,\nin vec3 lightPos,\nin vec3 spotDirection,\nin float spotCosCutoff,\nin float spotInnerCosCutoff,\nin float shininess,\nin vec3 col0,\nin float fade_distance,\nin float fade_power,\nin float radientPower,\ninout vec3 diffuse,\ninout vec3 specular)";
    static final String SpotLightPre = " float nDotVP;\n float nDotHV;\n float pf;\n float d;\n float attenuation;\n float spotDot;\n float spotAttenuation;\n vec3 \tVP;\n vec3\tR;\n VP = lightPos - ecPosition3;\n d = length(VP);\n VP /= d;\n R = reflect(-VP, normal);\n attenuation = 1.0; spotDot = dot(-VP, normalize(spotDirection));\n if (spotDot <= spotCosCutoff)\n  spotAttenuation = 0.0;\n else {\n  if(spotDot >= spotInnerCosCutoff)\n   spotAttenuation = 1.0;\n  else {\n   float falloff = (spotDot - spotCosCutoff) / (spotInnerCosCutoff - spotCosCutoff);\n   spotAttenuation = (3.0 - 2.0 * falloff) * falloff * falloff;\n  }\n }\n attenuation *= spotAttenuation;\n nDotVP = max(0.0, dot(normal, VP));\n";
    static final String quadraticFallof = " attenuation /= (d*d);";
    static final String SpotLightPerspective = " nDotHV = max(0.0, dot(R, -normalize(ecPosition3)));\n";
    static final String SpotLightParallel = " nDotHV = max(0.0, dot(R, vec3(0.0, 0.0, 1.0)));\n";
    static final String SpotLightPost = " if ((nDotHV <= 0.0) || (shininess >= 65504.0))\n  pf = 0.0;\n else\n  pf = pow(nDotHV, shininess);\n diffuse  += col0 * nDotVP * attenuation * radientPower;\n specular += col0 * nDotVP * pf * attenuation * radientPower;";
    protected String lightPos;
    protected String spotDirection;
    protected String spotCosCutoff;
    protected String spotInnerCosCutoff;
    protected String col0;
    protected String fade_power;
    protected String fade_distance;
    protected String radientPower;
    int rpLoc = -1;
    int posLoc = -1;
    int colLoc = -1;
    int spotdirLoc = -1;
    int spotCosCutLoc = -1;
    int spotInnerCosCutLoc = -1;

    public String getLightFunction() {
        String string = " vec3 normal = getEyeNormal(norm);\n vec3 eye = vec3 (0.0, 0.0, 1.0);\n SpotLight( normal.rgb, eye, pos, " + this.lightPos + ", " + this.spotDirection + ", " + this.spotCosCutoff + ", " + this.spotInnerCosCutoff + ", " + "shininess, " + this.col0 + ", " + this.fade_distance + ", " + this.fade_power + ", " + this.radientPower + ", " + "diff, spec);";
        return string;
    }

    public String[] getFragmentShader(Object object) {
        this.config.clearTmpVariables();
        this.lightPos = this.config.registerNewUniform(2);
        this.col0 = this.config.registerNewUniform(2);
        this.fade_distance = this.config.registerNewUniform(0);
        this.fade_power = this.config.registerNewUniform(0);
        this.radientPower = this.config.registerNewUniform(0);
        this.spotDirection = this.config.registerNewUniform(2);
        this.spotCosCutoff = this.config.registerNewUniform(0);
        this.spotInnerCosCutoff = this.config.registerNewUniform(0);
        this.config.registerFunc("vec3 getEyeNormal(vec2 encNorm)", " encNorm = encNorm*4.0-2.0;\n float f = dot(encNorm,encNorm);\n float g = sqrt(1.0-f*0.25);\n return vec3(encNorm*g,1.0-f*0.5);\n");
        this.config.registerFunc(SpotLightPrologue, SpotLightPre + (this.getLightShaderConfig().isPhysical() ? quadraticFallof : "") + (this.getLightShaderConfig().isPerspective() ? SpotLightPerspective : SpotLightParallel) + SpotLightPost);
        return this.getLightShaderConfig().completeShader(this.getLightFunction());
    }

    public boolean needsRecompilation(Object object) {
        return false;
    }

    public Class instanceFor() {
        return SpotLight.class;
    }

    public GLSLShader getInstance() {
        return new GLSLSpotLight();
    }

    protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
        super.setupShader(gL, gLSLDisplay, object);
        this.rpLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.radientPower);
        this.posLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.lightPos);
        this.colLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.col0);
        this.spotdirLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.spotDirection);
        this.spotCosCutLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.spotCosCutoff);
        this.spotInnerCosCutLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.spotInnerCosCutoff);
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
        LightPos lightPos = null;
        assert (object instanceof LightPos);
        lightPos = (LightPos)object;
        assert (lightPos.getLight() instanceof SpotLight);
        SpotLight spotLight = (SpotLight)lightPos.getLight();
        Point4d point4d = new Point4d(lightPos.getLightPos());
        gLSLDisplay.getCurrentGLState().getWorldToView().transform((Tuple4d)point4d);
        gL.glUniform3f(this.posLoc, (float)point4d.x, (float)point4d.y, (float)point4d.z);
        Vector3f vector3f = new Vector3f((float)lightPos.getLightDir().x, (float)lightPos.getLightDir().y, (float)lightPos.getLightDir().z);
        vector3f.normalize();
        gLSLDisplay.getCurrentGLState().getWorldToView().transform(vector3f);
        gL.glUniform3f(this.spotdirLoc, vector3f.x, vector3f.y, vector3f.z);
        double d = Math.cos(spotLight.getInnerAngle());
        double d2 = Math.cos(spotLight.getOuterAngle());
        gL.glUniform1f(this.spotCosCutLoc, (float)d2);
        gL.glUniform1f(this.spotInnerCosCutLoc, (float)d);
        this.spec.set((Tuple3f)spotLight.getColor());
        this.spec.scale(1.0 / this.spec.integrate());
        gL.glUniform3f(this.colLoc, this.spec.x, this.spec.y, this.spec.z);
        gL.glUniform1f(this.rpLoc, (float)((double)spotLight.getPower() / ((double)Math2.M_2PI * (1.0 - d + (d - d2) / 2.0))));
    }
}

