/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.light.GLSLLightShader;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.objects.AreaLight;
import de.grogra.imp3d.objects.Parallelogram;
import de.grogra.vecmath.Math2;
import javax.media.opengl.GL;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class GLSLAreaLight
extends GLSLLightShader {
    static final String SpotLightPrologue = "void AreaLight(in vec3 normal,\nin vec3 eye,\nin vec3 ecPosition3,\nin float shininess,\nin vec3 col0,\nin float radientPower,\ninout vec3 diffuse,\ninout vec3 specular)";
    static final String SpotLightPre = " float nDotVP;\n float nDotHV;\n float pf;\n float d;\n float attenuation;\n float spotDot;\n float spotAttenuation;\n vec3 \tVP;\n vec3 v1, v2, v3, v4;\n vec3 vn1, vn2, vn3, vn4;\n vec3 R;\n attenuation = 1.0;\n";
    static final String quadraticFallof = " attenuation /= (d*d);";
    static final String SpotLightPerspective = " nDotHV = max(0.0, dot(R, -normalize(ecPosition3)));\n";
    static final String SpotLightParallel = " nDotHV = max(0.0, dot(R, vec3(0.0, 0.0, 1.0)));\n";
    static final String SpotLightPost = " if ((nDotHV <= 0.0) || (shininess >= 65504.0))\n  pf = 0.0;\n else\n  pf = pow(nDotHV, shininess);\n nDotVP = max(0.0, dot(normal, VP));\n diffuse  += col0 * nDotVP * attenuation * radientPower;\n";
    protected String col0;
    protected String radientPower;
    protected String[] v;
    Vector4f vect = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    float[] f = new float[]{-1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f};
    int rpLoc = -1;
    int colLoc = -1;
    int[] vertLoc = new int[4];

    public String getLightFunction() {
        String string = " vec3 normal = getEyeNormal(norm);\n vec3 eye = vec3 (0.0, 0.0, 1.0);\n AreaLight( normal.rgb, eye, pos, shininess, " + this.col0 + ", " + this.radientPower + ", " + "diff, spec);";
        return string;
    }

    public String[] getFragmentShader(Object object) {
        int n;
        this.config.clearTmpVariables();
        this.col0 = this.config.registerNewUniform(2);
        this.radientPower = this.config.registerNewUniform(0);
        String string = "";
        this.v = new String[4];
        for (n = 0; n < 4; ++n) {
            this.v[n] = this.config.registerNewUniform(2);
            string = string + " v" + (n + 1) + " = " + this.v[n] + "-ecPosition3;\n vn" + (n + 1) + " = normalize(v" + (n + 1) + ");\n";
        }
        for (n = 0; n < 4; ++n) {
            string = string + " VP += acos(dot(vn" + (n + 1) + ",vn" + ((n + 1) % 4 + 1) + ")) * normalize(cross(v" + (n + 1) + ",v" + ((n + 1) % 4 + 1) + "));\n";
        }
        this.config.registerFunc("vec3 getEyeNormal(vec2 encNorm)", " encNorm = encNorm*4.0-2.0;\n float f = dot(encNorm,encNorm);\n float g = sqrt(1.0-f*0.25);\n return vec3(encNorm*g,1.0-f*0.5);\n");
        this.config.registerFunc(SpotLightPrologue, SpotLightPre + string + (this.getLightShaderConfig().isPhysical() ? quadraticFallof : "") + (this.getLightShaderConfig().isPerspective() ? SpotLightPerspective : SpotLightParallel) + SpotLightPost);
        return this.getLightShaderConfig().completeShader(this.getLightFunction());
    }

    public boolean needsRecompilation(Object object) {
        return false;
    }

    public Class instanceFor() {
        return Parallelogram.class;
    }

    public GLSLShader getInstance() {
        return new GLSLAreaLight();
    }

    protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
        super.setupShader(gL, gLSLDisplay, object);
        this.rpLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.radientPower);
        this.colLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.col0);
        for (int i = 0; i < 4; ++i) {
            this.vertLoc[i] = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.v[i]);
        }
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
        LightPos lightPos = null;
        assert (object instanceof LightPos);
        lightPos = (LightPos)object;
        assert (lightPos.getLight() instanceof Parallelogram);
        Parallelogram parallelogram = (Parallelogram)lightPos.getLight();
        AreaLight areaLight = parallelogram.getLight();
        Vector3f vector3f = parallelogram.getAxis();
        for (int i = 0; i < 4; ++i) {
            this.vect.set(this.f[4 * i] * vector3f.x, this.f[4 * i + 1] * vector3f.y, this.f[4 * i + 2] * parallelogram.getLength() + this.f[4 * i + 3] * vector3f.z, 1.0f);
            lightPos.getLightTransform().transform((Tuple4f)this.vect);
            gLSLDisplay.getCurrentGLState().getWorldToView().transform((Tuple4f)this.vect);
            gL.glUniform3f(this.vertLoc[i], this.vect.x, this.vect.y, this.vect.z);
        }
        this.spec.set(1.0f, 1.0f, 1.0f);
        if (parallelogram.getShader() != null) {
            this.spec.x = (float)(parallelogram.getShader().getAverageColor() >> 16 & 0xFF) / 255.0f;
            this.spec.y = (float)(parallelogram.getShader().getAverageColor() >> 8 & 0xFF) / 255.0f;
            this.spec.z = (float)(parallelogram.getShader().getAverageColor() & 0xFF) / 255.0f;
        }
        this.spec.scale(1.0 / this.spec.integrate());
        gL.glUniform3f(this.colLoc, this.spec.x, this.spec.y, this.spec.z);
        gL.glUniform1f(this.rpLoc, areaLight.getPower() * Math2.M_1_2PI);
    }
}

