/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import de.grogra.graph.GraphState;
import de.grogra.graph.Path;
import de.grogra.imp3d.LineSegmentizable;
import de.grogra.imp3d.LineSegmentizationCache;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.glsl.GLDisplay;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.material.GLSLMaterial;
import de.grogra.imp3d.glsl.renderable.GLSLRenderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Label;
import de.grogra.imp3d.objects.LightNode;
import de.grogra.imp3d.objects.Line;
import de.grogra.imp3d.objects.Point;
import de.grogra.imp3d.objects.SensorNode;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.objects.TextLabelBase;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SunSkyLight;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GLSLUpdateCache
extends GLDisplay.GLVisitor {
    private int minPathLength;
    private LineSegmentizationCache lineCache;
    Matrix4d worldToViewInv = new Matrix4d();
    GLSLDisplay disp;
    OpenGLState glState;
    Matrix4d mat = new Matrix4d();
    private int rend = 0;
    private int all = 0;

    public GLSLUpdateCache(GLSLDisplay gLSLDisplay) {
        this.disp = gLSLDisplay;
        this.glState = gLSLDisplay.getCurrentGLState();
    }

    private Matrix4d generateLightMatrix(Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.normalize(vector3d);
        vector3d2.negate();
        Matrix3d matrix3d = new Matrix3d();
        Math2.getOrthogonalBasis((Tuple3d)vector3d2, (Matrix3d)matrix3d, (boolean)false);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(matrix3d);
        matrix4d.m33 = 1.0;
        return matrix4d;
    }

    public void init(GraphState graphState, Matrix4d matrix4d, int n) {
        this.init(graphState, matrix4d, this.disp.getView3D(), false);
        this.worldToViewInv.invert(matrix4d);
        this.minPathLength = n;
        if (this.lineCache == null) {
            this.lineCache = new LineSegmentizationCache(graphState, 1.0f);
        }
        this.rend = 0;
        this.all = 0;
    }

    public void setCurrentTransformation(Matrix4d matrix4d) {
        this.transformation = matrix4d;
    }

    public int getRend() {
        return this.rend;
    }

    public int getAll() {
        return this.all;
    }

    protected void visitImpl(Object object, boolean bl, Shader shader, Path path) {
        int n;
        Object object2;
        Object object3;
        Object object4;
        if (this.minPathLength > 0 && path.getNodeAndEdgeCount() - (bl ? 0 : 1) < this.minPathLength) {
            return;
        }
        ++this.all;
        int n2 = this.state.getIntDefault(object, bl, de.grogra.imp.objects.Attributes.LAYER, 0);
        Object object5 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null);
        if (object5 != null) {
            if (object5 instanceof Renderable) {
                ++this.rend;
                object4 = (Renderable)object5;
                if (GLSLDisplay.DEBUG) {
                    System.out.println("Adding Drawable!:");
                    System.out.println("OBJECT: " + object);
                    System.out.println("SHAPE: " + object4);
                    System.out.println("PATH: " + path);
                }
                object3 = this.glState.getShapeManager().getInstance(object4, object, bl, this.disp.getRenderGraphState());
                if (GLSLDisplay.DEBUG) {
                    System.out.println("-------------------------------------------");
                }
                this.mat.mul(this.worldToViewInv, this.getCurrentTransformation());
                if (object5 instanceof Point || object5 instanceof Line || object5 instanceof Label || object5 instanceof LightNode || object5 instanceof Sky || object5 instanceof TextLabelBase || object5 instanceof SensorNode) {
                    if (object5 instanceof TextLabelBase) {
                        this.glState.deferredLabelRenderable.add((GLSLRenderable)object3, null, null, bl, n2, this.mat, this.getCurrentTransformation());
                    } else if (object5 instanceof Sky) {
                        object2 = null;
                        this.glState.setShaderConfSwitch(6);
                        object2 = this.disp.isOptionAltDrawing() && ((GLSLRenderable)object3).isShaderDependant(false) ? (GLSLMaterial)((GLSLRenderable)object3).findShader(this.glState, this.disp, shader) : (GLSLMaterial)this.disp.findShader(shader);
                        this.glState.deferredToolRenderable.add((GLSLRenderable)object3, shader, (GLSLMaterial)object2, bl, n2, this.mat, this.getCurrentTransformation());
                        this.glState.setShaderConfSwitch(0);
                    } else {
                        this.glState.deferredToolRenderable.add((GLSLRenderable)object3, null, null, bl, n2, this.mat, this.getCurrentTransformation());
                    }
                } else {
                    object2 = null;
                    object2 = this.disp.isOptionAltDrawing() && ((GLSLRenderable)object3).isShaderDependant(false) ? (GLSLMaterial)((GLSLRenderable)object3).findShader(this.glState, this.disp, shader) : (GLSLMaterial)this.disp.findShader(shader);
                    if (object2 == null) {
                        return;
                    }
                    if (((GLSLMaterial)object2).isOpaque(shader)) {
                        this.glState.deferredSolidRenderable.add((GLSLRenderable)object3, shader, (GLSLMaterial)object2, bl, n2, this.mat, this.getCurrentTransformation());
                    } else {
                        this.glState.deferredTranspRenderable.add((GLSLRenderable)object3, shader, (GLSLMaterial)object2, bl, n2, this.mat, this.getCurrentTransformation());
                    }
                }
            } else if (object5 instanceof LineSegmentizable) {
                ++this.rend;
                this.mat.mul(this.worldToViewInv, this.getCurrentTransformation());
                object4 = this.glState.getShapeManager().getInstance(object5, object, bl, this.disp.getRenderGraphState());
                this.glState.deferredToolRenderable.add((GLSLRenderable)object4, null, null, bl, n2, this.mat, this.getCurrentTransformation());
            }
        }
        object4 = this.state.getObjectDefault(object, bl, Attributes.LIGHT, null);
        if (object5 instanceof Sky) {
            this.disp.setupBGShader((Sky)object5);
            if (object4 instanceof Light && ((Light)object4).getLightType() == 0) {
                this.glState.defLight.add(new LightPos((Light)object5, null));
            }
        }
        if (object4 instanceof Light && (n = (object3 = (Light)object4).getLightType()) != 0) {
            GLSLDisplay.printDebugInfoN("Found light: " + object3);
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.mul(this.worldToViewInv, this.getCurrentTransformation());
            if (n == 3) {
                matrix4d.setTranslation(new Vector3d(0.0, 0.0, 0.0));
            }
            if (object3 instanceof Sky) {
                SunSkyLight sunSkyLight = (SunSkyLight)((Sky)object3).getShader();
                object3 = sunSkyLight;
                if (sunSkyLight.isDisableLight()) {
                    return;
                }
                this.glState.defLight.add(new LightPos((Light)object5, null));
                matrix4d = this.generateLightMatrix(sunSkyLight.getSun());
            }
            object2 = new LightPos((Light)object3, matrix4d);
            this.glState.defLight.add((LightPos)object2);
        }
    }
}

