/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.gl20.GL20ResourceMeshSingleUser;
import de.grogra.imp3d.gl20.GL20ResourceShape;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import javax.vecmath.Matrix4d;

public class GL20ResourceShapeFrustum
extends GL20ResourceShape {
    private static final int HEIGHT = 1;
    private static final int BASE_RADIUS = 2;
    private static final int TOP_RADIUS = 4;
    private static final int SCALE_V = 8;
    private static final int BASE_CLOSED = 16;
    private static final int TOP_CLOSED = 32;
    private int changeMask = -1;
    private float height = 1.0f;
    private float baseRadius = 1.0f;
    private float topRadius = 1.0f;
    private float scaleV = 1.0f;
    private boolean baseClosed = true;
    private boolean topClosed = true;
    private int meshSubDivisions = 0;
    private GL20ResourceMeshSingleUser mesh = null;

    private final PolygonArray createFrustumPolygonArray(int n, float f, float f2) {
        float f3;
        float f4;
        double d;
        int n2;
        if (n < 3) {
            return null;
        }
        PolygonArray polygonArray = new PolygonArray();
        polygonArray.init(3);
        polygonArray.planar = true;
        polygonArray.edgeCount = 3;
        FloatList floatList = polygonArray.vertices;
        FloatList floatList2 = polygonArray.uv;
        IntList intList = polygonArray.polygons;
        int n3 = 0;
        int n4 = n;
        double d2 = Math.PI / (double)n4;
        float f5 = 1.0f / (float)n4;
        polygonArray.setNormal(n3++, 0.0f, 0.0f, 1.0f);
        floatList2.add(0.5f);
        floatList2.add(0.5f);
        floatList.add(0.0f);
        floatList.add(0.0f);
        floatList.add(1.0f);
        for (n2 = 0; n2 <= n4; ++n2) {
            d = 2.0 * d2 * (double)n2;
            f4 = (float)Math.cos(d);
            f3 = (float)Math.sin(d);
            polygonArray.setNormal(n3++, 0.0f, 0.0f, 1.0f);
            floatList2.add(f4 / 2.0f + 0.5f);
            floatList2.add(f3 / 2.0f + 0.5f);
            floatList.add(f4 * f);
            floatList.add(f3 * f);
            floatList.add(1.0f);
            if (n2 <= 0) continue;
            intList.add(0);
            intList.add(n3 - 2);
            intList.add(n3 - 1);
        }
        for (n2 = 0; n2 <= n4; ++n2) {
            d = 2.0 * d2 * (double)n2;
            float f6 = f5 * (float)n2;
            f4 = (float)Math.cos(d);
            f3 = (float)Math.sin(d);
            polygonArray.setNormal(n3++, f4, f3, 0.0f);
            floatList2.add(f6);
            floatList2.add(0.0f);
            floatList.add(f4 * f);
            floatList.add(f3 * f);
            floatList.add(1.0f);
            polygonArray.setNormal(n3++, f4, f3, 0.0f);
            floatList2.add(f6);
            floatList2.add(1.0f);
            floatList.add(f4 * f2);
            floatList.add(f3 * f2);
            floatList.add(0.0f);
            if (n2 <= 0) continue;
            intList.add(n3 - 4);
            intList.add(n3 - 3);
            intList.add(n3 - 1);
            intList.add(n3 - 4);
            intList.add(n3 - 1);
            intList.add(n3 - 2);
        }
        n2 = n3 + n4 + 1;
        for (int i = 0; i <= n4; ++i) {
            double d3 = 2.0 * d2 * (double)i;
            f4 = (float)Math.cos(d3);
            f3 = (float)Math.sin(d3);
            polygonArray.setNormal(n3++, 0.0f, 0.0f, -1.0f);
            floatList2.add(f4 / 2.0f + 0.5f);
            floatList2.add(f3 / 2.0f + 0.5f);
            floatList.add(f4 * f2);
            floatList.add(f3 * f2);
            floatList.add(0.0f);
            if (i <= 0) continue;
            intList.add(n3 - 2);
            intList.add(n2);
            intList.add(n3 - 1);
        }
        polygonArray.setNormal(n3, 0.0f, 0.0f, -1.0f);
        floatList2.add(0.5f);
        floatList2.add(0.5f);
        floatList.add(0.0f);
        floatList.add(0.0f);
        floatList.add(0.0f);
        return polygonArray;
    }

    public GL20ResourceShapeFrustum() {
        super(65538);
    }

    public final void setHeight(float f) {
        if (this.height != f) {
            this.height = f;
            this.changeMask |= 1;
        }
    }

    public final float getHeight() {
        return this.height;
    }

    public final void setBaseRadius(float f) {
        if (this.baseRadius != f) {
            this.baseRadius = f;
            this.changeMask |= 2;
        }
    }

    public final float getBaseRadius() {
        return this.baseRadius;
    }

    public final void setTopRadius(float f) {
        if (this.topRadius != f) {
            this.topRadius = f;
            this.changeMask |= 4;
        }
    }

    public final float getTopRadius() {
        return this.topRadius;
    }

    public final void setBaseClosed(boolean bl) {
        if (this.baseClosed != bl) {
            this.baseClosed = bl;
            this.changeMask |= 0x10;
        }
    }

    public final boolean isBaseClosed() {
        return this.baseClosed;
    }

    public final void setTopClosed(boolean bl) {
        if (this.topClosed != bl) {
            this.topClosed = bl;
            this.changeMask |= 0x20;
        }
    }

    public final boolean isTopClosed() {
        return this.topClosed;
    }

    public void applyGeometry() {
        super.applyGeometry();
        this.mesh.draw();
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0 || this.mesh == null || !this.mesh.isUpToDate()) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        if (this.changeMask != 0 || this.mesh == null) {
            if ((this.changeMask & 1) != 0) {
                this.setShapeTransformationMatrix(new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, this.height > 0.0f ? 1.0 : -1.0, 0.0, 0.0, 0.0, 0.0, (double)this.height, 0.0, 0.0, 0.0, 0.0, 1.0));
            }
            if ((this.changeMask & 4) != 0 || (this.changeMask & 2) != 0 || this.mesh == null) {
                if (this.mesh != null) {
                    this.mesh.destroy();
                }
                this.mesh = new GL20ResourceMeshSingleUser();
                this.meshSubDivisions = 20;
                this.mesh.setPolygonArray(this.createFrustumPolygonArray(this.meshSubDivisions, this.topRadius, this.baseRadius));
            }
            if (((this.changeMask & 0x20) != 0 || (this.changeMask & 0x10) != 0) && this.mesh != null) {
                this.mesh.setUsedPolygonArea(this.topClosed ? 0 : this.meshSubDivisions, this.baseClosed ? 0 : -this.meshSubDivisions);
            }
            this.changeMask = 0;
        }
        super.update();
        this.mesh.update();
    }

    public void destroy() {
        if (this.mesh != null) {
            this.mesh.destroy();
        }
        super.destroy();
    }
}

