/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20GLSLCode;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragment;
import de.grogra.math.ChannelMap;
import de.grogra.math.Graytone;

public class GL20ResourceShaderFragmentGraytone
extends GL20ResourceShaderFragment {
    private static final int VALUE = 1;
    private int changeMask = -1;
    private float value;

    public GL20ResourceShaderFragmentGraytone() {
        super(327681);
        this.value = 0.5f;
    }

    public GL20ResourceShaderFragmentGraytone(float f) {
        super(327681);
        this.value = f;
    }

    public boolean setChannelMap(ChannelMap channelMap) {
        boolean bl = false;
        if (channelMap instanceof Graytone) {
            Graytone graytone = (Graytone)channelMap;
            this.setValue(graytone.getValue());
            bl = super.setChannelMap(channelMap);
        }
        return bl;
    }

    public boolean fragmentAffectOnAlpha() {
        return false;
    }

    public int getScalarIndex(GL20GLSLCode gL20GLSLCode, int n) {
        int n2 = -1;
        if (n < 8 || n > 14) {
            int n3 = 0;
            switch (n & 3) {
                case 0: 
                case 1: 
                case 2: {
                    n3 = gL20GLSLCode.createConstScalar(this.value);
                    break;
                }
                case 3: {
                    n3 = gL20GLSLCode.createConstScalar(1.0f);
                }
            }
            n2 = n3 | 0x8000;
        }
        return n2;
    }

    public int getVector3Index(GL20GLSLCode gL20GLSLCode, int n) {
        int n2;
        int n3 = -1;
        if ((n + 2 < 8 || n > 14) && (n2 = gL20GLSLCode.allocateTemporaryVector3()) != -1) {
            String string = new String(gL20GLSLCode.getTemporaryVector3Name(n2) + " = vec3(");
            for (int i = 0; i < 3; ++i) {
                switch (n + i & 3) {
                    case 0: 
                    case 1: 
                    case 2: {
                        string = string + Float.valueOf(this.value).toString();
                        break;
                    }
                    case 3: {
                        string = string + "1.0";
                    }
                }
                string = i < 2 ? string + "," : string + ");\n";
            }
            gL20GLSLCode.appendCode(string);
            n3 = n2;
        }
        return n3;
    }

    public int getVector4Index(GL20GLSLCode gL20GLSLCode, int n) {
        int n2;
        int n3 = -1;
        if ((n + 3 < 8 || n > 14) && (n2 = gL20GLSLCode.allocateTemporaryVector4()) != -1) {
            String string = new String(gL20GLSLCode.getTemporaryVector4Name(n2) + " = vec4(");
            for (int i = 0; i < 4; ++i) {
                switch (n + i & 3) {
                    case 0: 
                    case 1: 
                    case 2: {
                        string = string + Float.valueOf(this.value).toString();
                        break;
                    }
                    case 3: {
                        string = string + "1.0";
                    }
                }
                string = i < 3 ? string + "," : string + ");\n";
            }
            gL20GLSLCode.appendCode(string);
            n3 = n2;
        }
        return n3;
    }

    public final float getValue() {
        return this.value;
    }

    public final void setValue(float f) {
        if (this.value != f) {
            this.value = f;
            this.changeMask |= 1;
        }
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        this.setChannelMap(this.getChannelMap());
        if (this.changeMask != 0) {
            this.changeMask = 0;
        }
        super.update();
    }
}

