/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.Cone;
import de.grogra.vecmath.geom.Cube;
import de.grogra.vecmath.geom.Cylinder;
import de.grogra.vecmath.geom.Frustum;
import de.grogra.vecmath.geom.FrustumBase;
import de.grogra.vecmath.geom.HalfSpace;
import de.grogra.vecmath.geom.Mesh;
import de.grogra.vecmath.geom.MeshVolume;
import de.grogra.vecmath.geom.Sphere;
import de.grogra.vecmath.geom.Square;
import de.grogra.vecmath.geom.Supershape;
import de.grogra.vecmath.geom.TransformableVolume;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public abstract class VolumeBuilderBase {
    public final float epsilon;
    private final Matrix4d xform = new Matrix4d();
    private final Matrix4d squareXform = new Matrix4d();
    private final Matrix3d rot = new Matrix3d();
    private final Vector3d trans = new Vector3d();
    protected PolygonizationCache polyCache;
    private final Matrix4d frustumXform = new Matrix4d();

    protected abstract Matrix4d getCurrentTransformation();

    public VolumeBuilderBase(PolygonizationCache polygonizationCache, float f) {
        this.polyCache = polygonizationCache;
        this.epsilon = f;
        this.xform.setIdentity();
    }

    protected Matrix4d getTransformation(Matrix4d matrix4d) {
        if (matrix4d == null) {
            return this.getCurrentTransformation();
        }
        Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.getCurrentTransformation(), (Matrix4d)matrix4d);
        return this.xform;
    }

    public void setInvTransformation(TransformableVolume transformableVolume, Matrix4d matrix4d, double d) {
        matrix4d.getRotationScale(this.rot);
        this.rot.invert();
        matrix4d.get(this.trans);
        this.trans.x += d * matrix4d.m02;
        this.trans.y += d * matrix4d.m12;
        this.trans.z += d * matrix4d.m22;
        transformableVolume.setTransformation(this.rot, (Tuple3d)this.trans);
    }

    public Square buildParallelogram(float f, Vector3f vector3f, float f2, float f3, Matrix4d matrix4d) {
        this.squareXform.m03 = -vector3f.x;
        this.squareXform.m13 = -vector3f.y;
        this.squareXform.m23 = -vector3f.z;
        this.squareXform.m33 = 1.0;
        this.squareXform.m00 = vector3f.x * 2.0f;
        this.squareXform.m10 = vector3f.y * 2.0f;
        this.squareXform.m20 = vector3f.z * 2.0f;
        this.squareXform.m01 = 0.0;
        this.squareXform.m11 = 0.0;
        this.squareXform.m21 = f;
        if (Math.abs(vector3f.x) < Math.abs(vector3f.y)) {
            this.squareXform.m02 = 1.0;
            this.squareXform.m12 = 0.0;
            this.squareXform.m22 = 0.0;
        } else {
            this.squareXform.m02 = 0.0;
            this.squareXform.m12 = 1.0;
            this.squareXform.m22 = 0.0;
        }
        Math2.mulAffine((Matrix4d)this.squareXform, (Matrix4d)matrix4d, (Matrix4d)this.squareXform);
        Square square = new Square();
        this.setInvTransformation((TransformableVolume)square, this.squareXform, 0.0);
        square.scaleU = f2;
        square.scaleV = f3;
        return square;
    }

    public HalfSpace buildPlane(Matrix4d matrix4d) {
        HalfSpace halfSpace = new HalfSpace();
        this.setInvTransformation((TransformableVolume)halfSpace, matrix4d, 0.0);
        return halfSpace;
    }

    public Sphere buildSphere(float f, Matrix4d matrix4d) {
        if (Math.abs(f) < this.epsilon) {
            return null;
        }
        Sphere sphere = new Sphere();
        this.setInvTransformation((TransformableVolume)sphere, matrix4d, 0.0);
        f = 1.0f / f;
        sphere.scale((double)f, (double)f, (double)f);
        return sphere;
    }

    public Supershape buildSupershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Matrix4d matrix4d) {
        Supershape supershape = new Supershape(f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
        this.setInvTransformation((TransformableVolume)supershape, matrix4d, 0.0);
        return supershape;
    }

    public Cube buildBox(float f, float f2, float f3, Matrix4d matrix4d) {
        if (Math.abs(f) < this.epsilon || Math.abs(f2) < this.epsilon || Math.abs(f3) < this.epsilon) {
            return null;
        }
        Cube cube = new Cube();
        this.setInvTransformation((TransformableVolume)cube, matrix4d, f3 / 2.0f);
        cube.scale((double)(1.0f / f), (double)(1.0f / f2), (double)(2.0f / f3));
        return cube;
    }

    public Frustum buildFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Matrix4d matrix4d) {
        boolean bl3;
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        if (Math.abs(f) < this.epsilon || f2 + f3 < this.epsilon) {
            return null;
        }
        boolean bl4 = bl3 = f2 < 0.999f * f3;
        if (bl3) {
            this.frustumXform.setIdentity();
            this.frustumXform.m22 = -1.0;
            this.frustumXform.m11 = -1.0;
            this.frustumXform.m23 = f;
            this.frustumXform.mul(matrix4d, this.frustumXform);
            matrix4d = this.frustumXform;
            float f5 = f2;
            f2 = f3;
            f3 = f5;
            boolean bl5 = bl;
            bl = bl2;
            bl2 = bl5;
        }
        Frustum frustum = new Frustum();
        frustum.base = f2 / f3;
        this.setInvTransformation((TransformableVolume)frustum, matrix4d, (double)f * frustum.base / (frustum.base - 1.0));
        frustum.scale((double)(1.0f / f3), (double)(-1.0f / f3), (1.0 - frustum.base) / (double)f);
        frustum.baseOpen = !bl;
        frustum.topOpen = !bl2;
        frustum.rotateUV = bl3;
        frustum.scaleV = f4;
        return frustum;
    }

    public FrustumBase buildBaseFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Matrix4d matrix4d) {
        boolean bl3;
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        if (Math.abs(f) < this.epsilon || f2 + f3 < this.epsilon) {
            return null;
        }
        boolean bl4 = bl3 = f2 < 0.999f * f3;
        if (bl3) {
            this.frustumXform.setIdentity();
            this.frustumXform.m22 = -1.0;
            this.frustumXform.m11 = -1.0;
            this.frustumXform.m23 = f;
            this.frustumXform.mul(matrix4d, this.frustumXform);
            matrix4d = this.frustumXform;
            float f5 = f2;
            f2 = f3;
            f3 = f5;
            boolean bl5 = bl;
            bl = bl2;
            bl2 = bl5;
        }
        if (f3 < 0.001f * f2) {
            Cone cone = new Cone();
            this.setInvTransformation((TransformableVolume)cone, matrix4d, f);
            cone.base = 1.0;
            cone.scale((double)(1.0f / f2), (double)(-1.0f / f2), (double)(-1.0f / f));
            cone.baseOpen = !bl;
            cone.rotateUV = bl3;
            cone.scaleV = f4;
            return cone;
        }
        if (f3 < 0.999f * f2) {
            Frustum frustum = new Frustum();
            frustum.base = f2 / f3;
            this.setInvTransformation((TransformableVolume)frustum, matrix4d, (double)f * frustum.base / (frustum.base - 1.0));
            frustum.scale((double)(1.0f / f3), (double)(-1.0f / f3), (1.0 - frustum.base) / (double)f);
            frustum.baseOpen = !bl;
            frustum.topOpen = !bl2;
            frustum.rotateUV = bl3;
            frustum.scaleV = f4;
            return frustum;
        }
        Cylinder cylinder = new Cylinder();
        this.setInvTransformation((TransformableVolume)cylinder, matrix4d, f / 2.0f);
        cylinder.scale((double)(1.0f / f2), (double)(1.0f / f2), (double)(2.0f / f));
        cylinder.baseOpen = !bl;
        cylinder.topOpen = !bl2;
        cylinder.scaleV = f4;
        return cylinder;
    }

    public MeshVolume buildPolygons(Polygonizable polygonizable, Object object, boolean bl, Matrix4d matrix4d) {
        MeshVolume meshVolume = null;
        PolygonArray polygonArray = this.polyCache.get(object, bl, polygonizable);
        if (polygonArray.wasCleared()) {
            if (polygonArray.vertices.isEmpty()) {
                polygonArray.userObject = this;
            } else {
                meshVolume = new MeshVolume();
                meshVolume.setMesh((Mesh)polygonArray);
                meshVolume.setTransformation(matrix4d);
                polygonArray.userObject = meshVolume;
            }
        } else if (polygonArray.userObject != this) {
            meshVolume = ((MeshVolume)polygonArray.userObject).dup();
            meshVolume.setTransformation(matrix4d);
        }
        return meshVolume;
    }
}

