/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.graph.EdgePattern;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Transformation;
import de.grogra.vecmath.Math2;
import de.grogra.xl.util.ObjectList;
import javax.vecmath.Matrix4d;

public abstract class Visitor3D
implements Visitor {
    protected GraphState state;
    protected Matrix4d transformation = new Matrix4d();
    protected int layer;
    private final ObjectList matrixPool = new ObjectList();
    private final ObjectList transformations = new ObjectList();
    private EdgePattern pattern;
    private final Matrix4d pre = new Matrix4d();
    private boolean hasXf;

    protected void init(GraphState graphState, EdgePattern edgePattern, Matrix4d matrix4d) {
        this.transformations.clear();
        if (this.transformation == this.pre) {
            this.transformation = new Matrix4d();
        }
        this.transformation.set(matrix4d);
        this.pre.setIdentity();
        this.state = graphState;
        this.pattern = edgePattern;
    }

    public GraphState getGraphState() {
        return this.state;
    }

    public Matrix4d getCurrentTransformation() {
        return this.transformation;
    }

    public Object visitEnter(Path path, boolean bl) {
        if (bl) {
            return this.visitEnter(path.getObject(-1), true, path);
        }
        if (!GraphUtils.matchesTerminalEdge((EdgePattern)this.pattern, (Path)path)) {
            return STOP;
        }
        return this.visitEnter(path.getObject(-2), false, path);
    }

    protected Object visitEnter(Object object, boolean bl, Path path) {
        Transformation transformation = object == null ? null : (Transformation)this.state.getObjectDefault(object, bl, Attributes.TRANSFORMATION, null);
        int n = this.layer;
        if (object != null) {
            this.layer = this.state.getIntDefault(object, bl, Attributes.LAYER, n);
        }
        Matrix4d matrix4d = this.transformation;
        this.hasXf = transformation != null;
        if (this.hasXf) {
            this.transformations.push((Object)matrix4d);
            transformation.preTransform(object, bl, matrix4d, this.pre, this.state);
            this.transformation = this.pre;
        } else {
            this.transformations.push(null);
        }
        this.visitEnterImpl(object, bl, path);
        this.layer = n;
        if (transformation != null) {
            Matrix4d matrix4d2;
            if (this.matrixPool.isEmpty()) {
                matrix4d2 = new Matrix4d();
                matrix4d2.m33 = 1.0;
            } else {
                matrix4d2 = (Matrix4d)this.matrixPool.pop();
            }
            transformation.postTransform(object, bl, this.pre, matrix4d2, matrix4d, this.state);
            this.transformation = matrix4d2;
        }
        return null;
    }

    private void popTransformation() {
        Matrix4d matrix4d = (Matrix4d)this.transformations.pop();
        if (matrix4d != null) {
            this.matrixPool.push((Object)this.transformation);
            this.transformation = matrix4d;
        }
    }

    protected abstract void visitEnterImpl(Object var1, boolean var2, Path var3);

    protected abstract void visitLeaveImpl(Object var1, boolean var2, Path var3);

    public boolean visitLeave(Object object, Path path, boolean bl) {
        if (bl) {
            this.visitLeaveImpl(path.getObject(-1), true, path);
            this.popTransformation();
        } else if (object != STOP) {
            this.visitLeaveImpl(path.getObject(-2), false, path);
            this.popTransformation();
        }
        return true;
    }

    public Object visitInstanceEnter() {
        if (this.hasXf) {
            Matrix4d matrix4d;
            this.transformations.push((Object)this.transformation);
            if (this.matrixPool.isEmpty()) {
                matrix4d = new Matrix4d();
                matrix4d.m33 = 1.0;
            } else {
                matrix4d = (Matrix4d)this.matrixPool.pop();
            }
            Math2.setAffine((Matrix4d)matrix4d, (Matrix4d)this.pre);
            this.transformation = matrix4d;
        } else {
            this.transformations.push(null);
        }
        return null;
    }

    public boolean visitInstanceLeave(Object object) {
        this.popTransformation();
        return true;
    }
}

