/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.CameraBase;
import de.grogra.persistence.Transaction;
import java.awt.Point;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class CanvasCamera
extends CameraBase {
    public static final int OUTSIDE_Z_CLIPPING = -1;
    public static final int OUTSIDE_XY_CLIPPING = 0;
    public static final int INSIDE_CLIPPING = 1;
    int width;
    int height;
    float fx;
    float fy;
    float dx;
    float dy;
    Camera camera;
    private final Point2f linePoint = new Point2f();

    public void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.dx = 0.5f * (float)n;
        this.dy = 0.5f * (float)n2;
        this.fx = this.dx;
        this.fy = -this.fx;
    }

    public int projectWorld(Tuple3d tuple3d, Tuple2f tuple2f) {
        boolean bl = this.camera.projectWorld(tuple3d.x, tuple3d.y, tuple3d.z, tuple2f);
        if (bl) {
            tuple2f.x = tuple2f.x * this.fx + this.dx;
            tuple2f.y = tuple2f.y * this.fy + this.dy;
            if (tuple2f.x >= 0.0f && tuple2f.x < (float)this.width && tuple2f.y >= 0.0f && tuple2f.y < (float)this.height) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int projectView(float f, float f2, float f3, Tuple2f tuple2f, boolean bl) {
        boolean bl2 = this.camera.projectView(f, f2, f3, tuple2f, bl);
        if (bl2) {
            tuple2f.x = tuple2f.x * this.fx + this.dx;
            tuple2f.y = tuple2f.y * this.fy + this.dy;
            if (tuple2f.x >= 0.0f && tuple2f.x < (float)this.width && tuple2f.y >= 0.0f && tuple2f.y < (float)this.height) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    boolean projectLine(float f, float f2, float f3, float f4, float f5, float f6, Point point, Point point2) {
        float f7;
        float f8 = -this.camera.getZFar();
        if (f3 > f7) {
            float f9;
            float f10 = -this.camera.getZNear();
            if (f6 < f9) {
                int n;
                float f11;
                if (f3 > f10) {
                    f11 = (f3 - f10) / (f3 - f6);
                    f3 = f10;
                    f += f11 * (f4 - f);
                    f2 += f11 * (f5 - f2);
                }
                if (f6 < f8) {
                    f11 = (f6 - f8) / (f3 - f6);
                    f6 = f8;
                    f4 += f11 * (f4 - f);
                    f5 += f11 * (f5 - f2);
                }
                Point2f point2f = this.linePoint;
                this.camera.projectView(f, f2, f3, (Tuple2f)point2f, false);
                int n2 = (int)(point2f.x * this.fx + this.dx);
                int n3 = (int)(point2f.y * this.fy + this.dy);
                this.camera.projectView(f4, f5, f6, (Tuple2f)point2f, false);
                int n4 = (int)(point2f.x * this.fx + this.dx);
                int n5 = (int)(point2f.y * this.fy + this.dy);
                if (n2 > n4) {
                    n = n4;
                    n4 = n2;
                    n2 = n;
                    n = n5;
                    n5 = n3;
                    n3 = n;
                }
                if (n2 < this.width && n4 >= 0) {
                    if (n2 < 0) {
                        n3 += (int)((long)n2 * (long)(n5 - n3) / (long)(n2 - n4));
                        n2 = 0;
                    }
                    if (n4 >= this.width) {
                        n5 += (int)((long)(n4 - this.width + 1) * (long)(n5 - n3) / (long)(n2 - n4));
                        n4 = this.width - 1;
                    }
                    if (n3 > n5) {
                        n = n4;
                        n4 = n2;
                        n2 = n;
                        n = n5;
                        n5 = n3;
                        n3 = n;
                    }
                    if (n3 < this.height && n5 >= 0) {
                        if (n3 < 0) {
                            n2 += (int)((long)n3 * (long)(n4 - n2) / (long)(n3 - n5));
                            n3 = 0;
                        }
                        if (n5 >= this.height) {
                            n4 += (int)((long)(n5 - this.height + 1) * (long)(n4 - n2) / (long)(n3 - n5));
                            n5 = this.height - 1;
                        }
                        point.x = n2;
                        point.y = n3;
                        point2.x = n4;
                        point2.y = n5;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public float getZNear() {
        return this.camera.getZNear();
    }

    public float getZFar() {
        return this.camera.getZFar();
    }

    public float getScaleAt(double d, double d2, double d3) {
        return this.camera.getScaleAt(d, d2, d3) * (float)Math.sqrt(Math.abs(this.fx * this.fy));
    }

    public float getScaleAt(float f) {
        return this.camera.getScaleAt(f) * (float)Math.sqrt(Math.abs(this.fx * this.fy));
    }

    public void getRay(float f, float f2, Point3d point3d, Vector3d vector3d) {
        this.camera.getRay((f - this.dx) / this.fx, (f2 - this.dy) / this.fy, point3d, vector3d);
    }

    public Matrix4d getWorldToViewTransformation() {
        return this.camera.getWorldToViewTransformation();
    }

    public void setWorldToViewTransformation(Matrix4d matrix4d, Transaction transaction) {
        throw new UnsupportedOperationException();
    }
}

