/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import java.util.Arrays;
import java.util.Iterator;
import raskob.geometry.AbstractDensityFunc;
import raskob.geometry.InsecSweepLine;
import raskob.geometry.LineSegment;
import raskob.geometry.MassCenter;
import raskob.geometry.MathP;
import raskob.geometry.Point;
import raskob.geometry.PointArrayList;
import raskob.geometry.PointComparatorEx;
import raskob.geometry.PolygonSet;

public final class Polygon {
    private final PointArrayList pol = new PointArrayList();
    private final PolygonSet holePols = new PolygonSet();
    private int leftupper = 0;
    private Polygon parent = null;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public Polygon(Polygon parent, double[] coords) {
        this(parent);
        int i = 0;
        while (i < coords.length) {
            this.add(new Point(coords[i], coords[i + 1]));
            i += 2;
        }
    }

    public Polygon(Polygon parent) {
        this.parent = parent;
    }

    public final boolean add(Point p) {
        p.round();
        if (this.containsAsVertex(p)) {
            return false;
        }
        if (this.size() > 0) {
            if (!p.equals(this.getLast())) {
                this.pol.add(p);
                this.newMinMax(p, false);
            }
        } else {
            this.pol.add(p);
            this.newMinMax(p, true);
        }
        if (this.size() >= 2 && !this.get(this.leftupper).isLeftupper(p)) {
            this.leftupper = this.size() - 1;
        }
        return true;
    }

    public final Point get(int i) {
        return this.pol.get(i % this.size());
    }

    public final Point getNext(int i) {
        return this.get((i + 1) % this.size());
    }

    public final Point getPrevious(int i) {
        if (i == 0) {
            return this.getLast();
        }
        return this.get(i - 1);
    }

    public final Point getLast() {
        return this.get(this.size() - 1);
    }

    public final int getSucc(int i) {
        return (i + 1) % this.size();
    }

    public final int getPred(int i) {
        return i != 0 ? i - 1 : this.size() - 1;
    }

    public final int getSuccNotPred(int i, boolean SuccNotPred) {
        if (SuccNotPred) {
            return this.getSucc(i);
        }
        return this.getPred(i);
    }

    public final double getMinX() {
        return 0.0;
    }

    public final LineSegment getEdge(int i) {
        return new LineSegment(this.get(i), this.getNext(i));
    }

    public final int getFirstEdge(int i) {
        int j = this.getPred(i);
        LineSegment ls1 = this.getEdge(i);
        LineSegment ls2 = this.getEdge(j);
        Point p = this.get(i);
        if (ls1.isVertical() && ls2.isVertical()) {
            if (ls1.getQ1().lessEqual(ls2.getQ1())) {
                return i;
            }
            return j;
        }
        if (ls1.isVertical()) {
            if (ls1.getQ1().equals(p)) {
                return j;
            }
            return i;
        }
        if (ls2.isVertical()) {
            if (ls2.getQ1().equals(p)) {
                return i;
            }
            return j;
        }
        if (ls1.getGradient() < ls2.getGradient()) {
            return i;
        }
        return j;
    }

    public final int getSecondEdge(int i) {
        int j = this.getFirstEdge(i);
        if (i == j) {
            return this.getPred(i);
        }
        return i;
    }

    public final boolean isLeftVertexEx(int p) {
        LineSegment ls1 = this.getEdge(p);
        LineSegment ls2 = this.getEdge(this.getPred(p));
        return Point.compareEx(ls1.getQ1(), ls2.getQ1()) == 0;
    }

    public final boolean isRightVertexEx(int p) {
        LineSegment ls1 = this.getEdge(p);
        LineSegment ls2 = this.getEdge(this.getPred(p));
        return Point.compareEx(ls1.getQ2(), ls2.getQ2()) == 0;
    }

    public final boolean isMidVertexEx(int p) {
        LineSegment ls1 = this.getEdge(p);
        LineSegment ls2 = this.getEdge(this.getPred(p));
        return Point.compareEx(ls1.getQ1(), ls2.getQ2()) == 0 || Point.compareEx(ls1.getQ2(), ls2.getQ1()) == 0;
    }

    public final boolean isPositiveOriented() {
        if (this.size() >= 3) {
            LineSegment ls1 = new LineSegment(this.get(this.leftupper), this.getNext(this.leftupper));
            LineSegment ls2 = new LineSegment(this.get(this.leftupper), this.getPrevious(this.leftupper));
            double gradient1 = ls1.getGradient();
            double gradient2 = ls2.getGradient();
            if (ls1.isVertical()) {
                return true;
            }
            if (ls2.isVertical()) {
                return false;
            }
            return MathP.less(gradient1, gradient2);
        }
        return true;
    }

    public final int size() {
        return this.pol.size();
    }

    public final boolean containsAsVertex(Point p) {
        Iterator iter = this.holePols.iterator();
        while (iter.hasNext()) {
            if (!((Polygon)iter.next()).containsAsVertex(p)) continue;
            return true;
        }
        return this.pol.contains(p);
    }

    public final void round() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).round();
            ++i;
        }
    }

    public final Polygon getIntersection(Polygon testPol, boolean flat) {
        this.round();
        testPol.round();
        if (this.parent == null) {
            Polygon res = new Polygon(null);
            Iterator iter = this.holePols.iterator();
            while (iter.hasNext()) {
                Polygon hole = (Polygon)iter.next();
                Polygon insec = hole.getIntersection(testPol, flat);
                Iterator inseciter = insec.holePols.iterator();
                while (inseciter.hasNext()) {
                    res.addHolePolygon((Polygon)inseciter.next());
                }
            }
            return res;
        }
        int[] ind = this.toXSortedIndexEx();
        int[] indTest = testPol.toXSortedIndexEx();
        InsecSweepLine sweepLine = new InsecSweepLine(this, testPol);
        int i = 0;
        int j = 0;
        boolean faulty = false;
        while (i < ind.length || j < indTest.length || sweepLine.hasEvents()) {
            Point iPoint = null;
            Point jPoint = null;
            Point evPoint = null;
            boolean iEvent = false;
            boolean jEvent = false;
            boolean evEvent = false;
            if (i < ind.length) {
                iPoint = this.get(ind[i]);
                iEvent = true;
            }
            if (j < indTest.length) {
                jPoint = testPol.get(indTest[j]);
                jEvent = true;
            }
            if (sweepLine.hasEvents()) {
                evPoint = sweepLine.getNextEvent();
                evEvent = true;
            }
            if (iPoint != null && jPoint != null) {
                iEvent = Point.compareEx(iPoint, jPoint) <= 0;
                boolean bl = jEvent = !iEvent;
            }
            if (iEvent && evPoint != null) {
                iEvent = Point.compareEx(evPoint, iPoint) > 0;
                boolean bl = evEvent = !iEvent;
            }
            if (jEvent && evPoint != null) {
                jEvent = Point.compareEx(evPoint, jPoint) > 0;
                evEvent = !jEvent;
            }
            int n = 0;
            int polN = 0;
            boolean leftVertex = false;
            boolean rightVertex = false;
            boolean midVertex = false;
            if (iEvent) {
                polN = 0;
                n = ind[i];
                ++i;
                leftVertex = this.isLeftVertexEx(n);
                rightVertex = this.isRightVertexEx(n);
                midVertex = this.isMidVertexEx(n);
            }
            if (jEvent) {
                polN = 1;
                n = indTest[j];
                ++j;
                leftVertex = testPol.isLeftVertexEx(n);
                rightVertex = testPol.isRightVertexEx(n);
                midVertex = testPol.isMidVertexEx(n);
            }
            if (evEvent) {
                sweepLine.handleEvent();
                continue;
            }
            try {
                if (leftVertex) {
                    sweepLine.addEdges(n, polN);
                    continue;
                }
                if (rightVertex) {
                    sweepLine.removeEdges(n, polN);
                    continue;
                }
                if (!midVertex) continue;
                sweepLine.continueEdge(n, polN);
            }
            catch (Exception e) {
                faulty = true;
                break;
            }
        }
        Polygon res = !faulty ? sweepLine.toPolygon() : testPol;
        if (!flat) {
            Iterator resiter = res.holePols.iterator();
            while (resiter.hasNext()) {
                Polygon reshole = (Polygon)resiter.next();
                Iterator iter = this.holePols.iterator();
                while (iter.hasNext()) {
                    Polygon hole = (Polygon)iter.next();
                    if (hole.size() <= 0) continue;
                    Polygon insec = hole.getIntersection(testPol, false);
                    Iterator inseciter = insec.holePols.iterator();
                    while (inseciter.hasNext()) {
                        Polygon insechole = (Polygon)inseciter.next();
                        reshole.addHolePolygon(insechole);
                    }
                }
            }
        }
        return res;
    }

    public static int compareEdgesAt(Polygon pol0, int edge0, boolean vl0, Polygon pol1, int edge1, boolean vl1, double x) {
        LineSegment ls0 = pol0.getEdge(edge0);
        LineSegment ls1 = pol1.getEdge(edge1);
        return LineSegment.compareAt(ls0, vl0, ls1, vl1, x);
    }

    public final void addHolePolygon(Polygon pol) {
        this.holePols.add(pol);
        pol.setParent(this);
        int i = 0;
        while (i < pol.size()) {
            this.newMinMax(pol.get(i), false);
            ++i;
        }
    }

    public final void setParent(Polygon parent) {
        this.parent = parent;
    }

    public final double getArea(AbstractDensityFunc dens) {
        double area = 0.0;
        int j = 0;
        while (j < this.size()) {
            block9: {
                int sgn;
                int succ;
                int i;
                block8: {
                    int compare;
                    block7: {
                        i = (j + this.leftupper) % this.size();
                        succ = this.getSuccNotPred(i, this.isPositiveOriented());
                        this.isPositiveOriented();
                        compare = MathP.compare(this.get(i).getX(), this.get(succ).getX());
                        if (compare >= 0) break block7;
                        sgn = 1;
                        break block8;
                    }
                    if (compare <= 0) break block9;
                    sgn = -1;
                }
                LineSegment ls = new LineSegment(this.get(i), this.get(succ));
                double left = MathP.min(this.get(i).getX(), this.get(succ).getX());
                double right = MathP.max(this.get(i).getX(), this.get(succ).getX());
                if (!(MathP.equals(ls.getGradient(), 0.0) && MathP.equals(ls.getOrdinate(), 0.0) || !(Math.abs(ls.getGradient()) <= 1.0 / MathP.getPrecision() * 100.0) || MathP.equals(left / 100.0, right / 100.0))) {
                    area += (double)sgn * dens.getArea(left, right, 0.0, 0.0, ls.getGradient(), ls.getOrdinate());
                }
            }
            ++j;
        }
        if (!this.holePols.isEmpty()) {
            Iterator iter = this.holePols.iterator();
            while (iter.hasNext()) {
                area += -((Polygon)iter.next()).getArea(dens);
            }
        }
        return area;
    }

    public final MassCenter getMassCenter(AbstractDensityFunc dens) {
        MassCenter mc = null;
        int j = 0;
        while (j < this.size()) {
            int i = (j + this.leftupper) % this.size();
            int succ = this.getSuccNotPred(i, this.isPositiveOriented());
            int compare = MathP.compare(this.get(i).getX(), this.get(succ).getX());
            if (compare != 0) {
                LineSegment ls = new LineSegment(this.get(i), this.get(succ));
                double left = MathP.min(this.get(i).getX(), this.get(succ).getX());
                double right = MathP.max(this.get(i).getX(), this.get(succ).getX());
                if (!MathP.equals(ls.getGradient(), 0.0) || !MathP.equals(ls.getOrdinate(), 0.0)) {
                    MassCenter newMc = dens.getMassCenter(left, right, 0.0, 0.0, ls.getGradient(), ls.getOrdinate());
                    if (compare > 0) {
                        newMc.invert();
                    }
                    if (mc != null) {
                        mc.mergeWith(newMc);
                    } else {
                        mc = newMc;
                    }
                }
            }
            ++j;
        }
        if (!this.holePols.isEmpty()) {
            Iterator iter = this.holePols.iterator();
            while (iter.hasNext()) {
                MassCenter innerMc = ((Polygon)iter.next()).getMassCenter(dens);
                if (mc != null) {
                    if (this.size() != 0 && innerMc != null) {
                        innerMc.invert();
                    }
                    mc.mergeWith(innerMc);
                    continue;
                }
                mc = innerMc;
            }
        }
        return mc;
    }

    public final int[] toXSortedIndexEx() {
        Point[] arr = this.pol.toSortedArrayEx();
        int[] ind = new int[this.size()];
        this.pol.gotoFirst();
        int i = 0;
        while (this.pol.hasNext()) {
            int pos = Arrays.binarySearch(arr, this.pol.getNext(), new PointComparatorEx());
            ind[pos] = i++;
        }
        return ind;
    }

    public final String toString() {
        String res = new String();
        res = new StringBuilder(String.valueOf(res)).append(this.size()).append(": ").toString();
        int i = 0;
        while (i < this.size()) {
            res = new StringBuilder(String.valueOf(res)).append("[").append(this.get(i)).append("]").toString();
            ++i;
        }
        return res;
    }

    private void newMinMax(Point p, boolean reset) {
        if (reset) {
            this.maxX = this.minX = p.getX();
            this.maxY = this.minY = p.getY();
        } else {
            if (MathP.less(p.getX(), this.minX)) {
                this.minX = p.getX();
            }
            if (MathP.greater(p.getX(), this.maxX)) {
                this.maxX = p.getX();
            }
            if (MathP.less(p.getY(), this.minY)) {
                this.minY = p.getY();
            }
            if (MathP.greater(p.getY(), this.maxY)) {
                this.maxY = p.getY();
            }
        }
        if (this.parent != null) {
            this.parent.newMinMax(p, false);
        }
    }
}

