/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import raskob.geometry.MathP;
import raskob.geometry.Matrix2x2;
import raskob.geometry.Point;

public class Line {
    private Point p1;
    private Point p2;
    private double gradient = 0.0;
    private double ordinate = 0.0;
    private boolean vertical;

    public Line(Point p1, Point p2) {
        if (p1.equals(p2)) {
            throw new RuntimeException("Points identical in Line()");
        }
        this.p1 = Point.first(p1, p2);
        this.p2 = Point.second(p1, p2);
        if (MathP.equals(p1.getX(), p2.getX())) {
            this.vertical = true;
        } else {
            this.gradient = (p1.getY() - p2.getY()) / (p1.getX() - p2.getX());
            this.ordinate = p1.getY() - this.getGradient() * p1.getX();
            this.vertical = false;
        }
    }

    public final double getGradient() {
        return this.gradient;
    }

    public final double getOrdinate() {
        return this.ordinate;
    }

    public final Point getP1() {
        return this.p1;
    }

    public final Point getP2() {
        return this.p2;
    }

    public boolean intersects(Line l) {
        Matrix2x2 m = new Matrix2x2(l, this);
        return m.isSolvable() && !m.isUniValid();
    }

    public final Point getIntersection(Line l) {
        Matrix2x2 m = new Matrix2x2(l, this);
        if (m.isSolvable() && !m.isUniValid()) {
            return m.getSolution();
        }
        throw new RuntimeException("No intersection or universal validity in Line.intersects()");
    }

    public final boolean isVertical() {
        return MathP.equals(this.p1.getX(), this.p2.getX());
    }

    public boolean contains(Point p) {
        if (this.vertical) {
            return MathP.equals(p.getX(), this.p1.getX());
        }
        return MathP.equals(p.getY(), this.getY(p.getX()));
    }

    public double getY(double x) {
        if (this.vertical) {
            throw new RuntimeException("Division by zero in Line.getY()");
        }
        return this.gradient * x + this.ordinate;
    }
}

