/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.pdb.view;

import de.grogra.ext.pdb.model.IProtein;
import de.grogra.ext.pdb.view.StickTupel;
import de.grogra.ext.pdb.view.Visualizer;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import java.util.HashMap;
import java.util.Vector;

public class BallStickVisualizer
implements Visualizer,
Command {
    private final int C_BOND = 2;
    private final int N_BOND = 0;
    private IProtein protein;
    private static HashMap atomColorMapping = new HashMap();
    private static HashMap aminoBondsIndices = new HashMap();
    protected final float BALL_RADIUS = 0.4f;
    protected final float STICK_RADIUS = 0.1f;
    Node seqNode = new Node();
    Node acidNode = new Node();

    public BallStickVisualizer(IProtein iProtein) {
        this.protein = iProtein;
        atomColorMapping.put("O", RGBAShader.RED);
        atomColorMapping.put("N", RGBAShader.BLUE);
        atomColorMapping.put("C", RGBAShader.DARK_GRAY);
        atomColorMapping.put("S", RGBAShader.YELLOW);
        Vector<StickTupel> vector = new Vector<StickTupel>();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("ALA", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(6, 7));
        vector.add(new StickTupel(7, 8));
        vector.add(new StickTupel(8, 9));
        vector.add(new StickTupel(8, 10));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("ARG", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(5, 7));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("ASN", vector);
        aminoBondsIndices.put("ASP", vector);
        aminoBondsIndices.put("LEU", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("CYS", vector);
        aminoBondsIndices.put("SER", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(6, 7));
        vector.add(new StickTupel(6, 8));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("GLU", vector);
        aminoBondsIndices.put("GLN", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("GLY", vector);
        aminoBondsIndices.put("UNK", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(5, 7));
        vector.add(new StickTupel(6, 8));
        vector.add(new StickTupel(7, 9));
        vector.add(new StickTupel(8, 9));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("HIS", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(4, 6));
        vector.add(new StickTupel(5, 7));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("ILE", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(6, 7));
        vector.add(new StickTupel(7, 8));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("LYS", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(6, 7));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("MET", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(5, 7));
        vector.add(new StickTupel(6, 8));
        vector.add(new StickTupel(7, 9));
        vector.add(new StickTupel(8, 10));
        vector.add(new StickTupel(9, 10));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("PHE", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(0, 6));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("PRO", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(4, 6));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("THR", vector);
        aminoBondsIndices.put("VAL", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(5, 7));
        vector.add(new StickTupel(6, 8));
        vector.add(new StickTupel(7, 9));
        vector.add(new StickTupel(7, 10));
        vector.add(new StickTupel(8, 9));
        vector.add(new StickTupel(9, 11));
        vector.add(new StickTupel(10, 12));
        vector.add(new StickTupel(11, 13));
        vector.add(new StickTupel(12, 13));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("TRP", vector);
        vector = new Vector();
        vector.add(new StickTupel(0, 1));
        vector.add(new StickTupel(1, 4));
        vector.add(new StickTupel(4, 5));
        vector.add(new StickTupel(5, 6));
        vector.add(new StickTupel(5, 7));
        vector.add(new StickTupel(6, 8));
        vector.add(new StickTupel(7, 9));
        vector.add(new StickTupel(8, 10));
        vector.add(new StickTupel(9, 10));
        vector.add(new StickTupel(10, 11));
        vector.add(new StickTupel(1, 2));
        vector.add(new StickTupel(2, 3));
        aminoBondsIndices.put("TYR", vector);
    }

    private Object getAtomColorMapping(Object object) {
        Object object2 = atomColorMapping.get(object);
        if (object2 == null) {
            object2 = RGBAShader.PINK;
        }
        return object2;
    }

    private Object getAminoBondsIndices(Object object) {
        Object object2 = aminoBondsIndices.get(object);
        if (object2 == null) {
            object2 = new Vector();
        }
        return object2;
    }

    public Node createGraph() {
        Node node = new Node();
        for (int i = 0; i < this.protein.getNumberOfSequences(); ++i) {
            this.seqNode = new Node();
            for (int j = 0; j < this.protein.getNumberOfAcids(i); ++j) {
                StickTupel stickTupel;
                this.acidNode = new Node();
                Node node2 = null;
                if (j > 0) {
                    this.createAcidConnection(i, j);
                }
                for (int k = 0; k < this.protein.getNumberOfAtoms(i, j); ++k) {
                    Sphere sphere = new Sphere(0.4f);
                    sphere.setTransform((double)this.protein.getXCoord(i, j, k), (double)this.protein.getYCoord(i, j, k), (double)this.protein.getZCoord(i, j, k));
                    stickTupel = (Shader)this.getAtomColorMapping(this.protein.getElement(i, j, k));
                    if (stickTupel == null) {
                        stickTupel = RGBAShader.BLACK;
                    }
                    sphere.setShader((Shader)stickTupel);
                    if (node2 == null) {
                        node2 = this.acidNode;
                    }
                    node2.addEdgeBitsTo((Node)sphere, 32768, null);
                    node.addEdgeBitsTo((Node)sphere, 512, null);
                    node2 = sphere;
                    if (!this.protein.getAtomName(i, j, k).equals("OXT")) continue;
                    this.createConnection(i, j, 2, k);
                }
                Vector vector = (Vector)this.getAminoBondsIndices(this.protein.getAcidName(i, j));
                stickTupel = null;
                for (int k = 0; k < vector.size(); ++k) {
                    stickTupel = (StickTupel)vector.get(k);
                    this.createConnection(i, j, stickTupel.getStartAtomIndex(), stickTupel.getEndAtomIndex());
                }
                this.seqNode.addEdgeBitsTo(this.acidNode, 32768, null);
                node.addEdgeBitsTo(this.acidNode, 512, null);
            }
        }
        return node;
    }

    private void createConnection(int n, int n2, int n3, int n4) {
        try {
            Cylinder cylinder = new Cylinder();
            cylinder.setRadius(0.1f);
            cylinder.setEndPoints((double)this.protein.getXCoord(n, n2, n3), (double)this.protein.getYCoord(n, n2, n3), (double)this.protein.getZCoord(n, n2, n3), (double)this.protein.getXCoord(n, n2, n4), (double)this.protein.getYCoord(n, n2, n4), (double)this.protein.getZCoord(n, n2, n4));
            cylinder.setShader((Shader)RGBAShader.WHITE);
            Edge edge = this.acidNode.getFirstEdge();
            Node node = null;
            Node node2 = null;
            for (int i = 0; i <= n4; ++i) {
                node2 = edge.getTarget();
                if (i == n3) {
                    node = node2;
                }
                edge = edge.getNext(node2);
            }
            cylinder.addEdgeBitsTo(node2, 32768, null);
            node.addEdgeBitsTo((Node)cylinder, 32768, null);
            node.getAxisParent().addEdgeBitsTo((Node)cylinder, 512, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void createAcidConnection(int n, int n2) {
        Cylinder cylinder = new Cylinder();
        cylinder.setTransform((double)this.protein.getXCoord(n, n2, 0), (double)this.protein.getYCoord(n, n2, 0), (double)this.protein.getZCoord(n, n2, 0));
        cylinder.setRadius(0.1f);
        cylinder.setEndPoints((double)this.protein.getXCoord(n, n2, 0), (double)this.protein.getYCoord(n, n2, 0), (double)this.protein.getZCoord(n, n2, 0), (double)this.protein.getXCoord(n, n2 - 1, 2), (double)this.protein.getYCoord(n, n2 - 1, 2), (double)this.protein.getZCoord(n, n2 - 1, 2));
        cylinder.setShader((Shader)RGBAShader.WHITE);
        Edge edge = this.seqNode.getFirstEdge();
        Node node = null;
        Node node2 = null;
        for (int i = 0; i <= n2; ++i) {
            node2 = edge.getTarget();
            if (i == n2 - 1) {
                node = node2;
            }
            edge = edge.getNext(node2);
        }
        cylinder.addEdgeBitsTo(node2, 32768, null);
        node.addEdgeBitsTo((Node)cylinder, 32768, null);
        node.getAxisParent().addEdgeBitsTo((Node)cylinder, 512, null);
    }

    public String getCommandName() {
        return null;
    }

    public void run(Object object, Context context) {
        System.out.println("running command Backbone Modell...");
    }
}

