/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.query;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.util.ClassLoaderObjectInputStream;
import de.grogra.xl.util.XHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;

public final class Utils {
    private Utils() {
    }

    public static void writeArray(BytecodeSerialization bytecodeSerialization, Object object) throws IOException {
        if (object == null) {
            bytecodeSerialization.visitObject(null);
        } else {
            int n = Array.getLength(object);
            if (n < 64 && object instanceof boolean[]) {
                bytecodeSerialization.beginMethod(Reflection.getDeclaredMethod((Type)ClassAdapter.wrap(Utils.class), (String)"toBooleanArray"));
                bytecodeSerialization.visitLong(Utils.toLong((boolean[])object));
                bytecodeSerialization.endMethod();
                return;
            }
            bytecodeSerialization.beginArray(n, (Type)ClassAdapter.wrap(object.getClass().getComponentType()));
            for (int i = 0; i < n; ++i) {
                if (object instanceof Object[]) {
                    Object object2 = ((Object[])object)[i];
                    if (object2 == null) continue;
                    bytecodeSerialization.beginArrayComponent(i);
                    if (object2.getClass().getComponentType() != null) {
                        Utils.writeArray(bytecodeSerialization, object2);
                    } else {
                        bytecodeSerialization.visitObject(object2);
                    }
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (object instanceof boolean[]) {
                    if (!((boolean[])object)[i]) continue;
                    bytecodeSerialization.beginArrayComponent(i);
                    bytecodeSerialization.visitBoolean(((boolean[])object)[i]);
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (object instanceof byte[]) {
                    if (((byte[])object)[i] == 0) continue;
                    bytecodeSerialization.beginArrayComponent(i);
                    bytecodeSerialization.visitByte(((byte[])object)[i]);
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (object instanceof short[]) {
                    if (((short[])object)[i] == 0) continue;
                    bytecodeSerialization.beginArrayComponent(i);
                    bytecodeSerialization.visitShort(((short[])object)[i]);
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (object instanceof char[]) {
                    if (((char[])object)[i] == '\u0000') continue;
                    bytecodeSerialization.beginArrayComponent(i);
                    bytecodeSerialization.visitChar(((char[])object)[i]);
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (object instanceof int[]) {
                    if (((int[])object)[i] == 0) continue;
                    bytecodeSerialization.beginArrayComponent(i);
                    bytecodeSerialization.visitInt(((int[])object)[i]);
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (object instanceof long[]) {
                    if (((long[])object)[i] == 0L) continue;
                    bytecodeSerialization.beginArrayComponent(i);
                    bytecodeSerialization.visitLong(((long[])object)[i]);
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (object instanceof float[]) {
                    bytecodeSerialization.beginArrayComponent(i);
                    bytecodeSerialization.visitFloat(((float[])object)[i]);
                    bytecodeSerialization.endArrayComponent();
                    continue;
                }
                if (!(object instanceof double[])) continue;
                bytecodeSerialization.beginArrayComponent(i);
                bytecodeSerialization.visitDouble(((double[])object)[i]);
                bytecodeSerialization.endArrayComponent();
            }
            bytecodeSerialization.endArray();
        }
    }

    public static Method getConstructor(Object object) {
        XHashMap.Entry entry = ClassAdapter.wrap(object.getClass()).getLookup().getMethods("<init>");
        Method method = (Method)entry.getValue();
        if (entry.next() != null) {
            throw new AssertionError((Object)("More than one constructor in " + object.getClass()));
        }
        return method;
    }

    public static Method getConstructor(Object object, String string) {
        block0: for (XHashMap.Entry entry = ClassAdapter.wrap(object.getClass()).getLookup().getMethods("<init>"); entry != null; entry = entry.next()) {
            Method method = (Method)entry.getValue();
            if (method.getParameterCount() != string.length()) continue;
            for (int i = string.length() - 1; i >= 0; --i) {
                if (string.charAt(i) != method.getParameterType(i).getSimpleName().charAt(0)) continue block0;
            }
            return method;
        }
        throw new NoSuchMethodError("No constructor " + string + " in " + object.getClass());
    }

    public static Method getConstructor(Object object, int n) {
        Method method = null;
        for (XHashMap.Entry entry = ClassAdapter.wrap(object.getClass()).getLookup().getMethods("<init>"); entry != null; entry = entry.next()) {
            Method method2 = (Method)entry.getValue();
            if (method2.getParameterCount() != n) continue;
            if (method != null) {
                throw new AssertionError((Object)("More than one constructor in " + object.getClass()));
            }
            method = method2;
        }
        if (method == null) {
            throw new NoSuchMethodError("No constructor with " + n + " arguments in " + object.getClass());
        }
        return method;
    }

    public static String toString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static byte[] toBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static long toLong(boolean[] blArray) {
        if (blArray.length > 63) {
            throw new IllegalArgumentException();
        }
        long l = 1L << blArray.length;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            l |= 1L << i;
        }
        return l;
    }

    public static boolean[] toBooleanArray(long l) {
        int n = 63 - Long.numberOfLeadingZeros(l);
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = ((int)(l >> i) & 1) != 0;
        }
        return blArray;
    }

    public static ObjectInputStream getObjectInput(String string, ClassLoader classLoader) throws IOException {
        return new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(Utils.toBytes(string)), classLoader);
    }

    public static ClassAdapter toClassAdapter(Object[] objectArray) {
        return ClassAdapter.wrap(objectArray.getClass().getComponentType(), (boolean)false);
    }
}

