/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.LiquidRootPaneUI;
import com.birosoft.liquid.LiquidWindowButtonUI;
import com.birosoft.liquid.SpecialUIButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;

class LiquidTitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private static LiquidWindowButtonUI iconButtonUI;
    private static LiquidWindowButtonUI maxButtonUI;
    private static LiquidWindowButtonUI closeButtonUI;
    private static LiquidWindowButtonUI menuButtonUI;
    private boolean prevState = false;
    private boolean isMenuShowed = false;
    Color normalTitleColor = Color.white;
    Color shadowColor = new Color(10, 24, 131);
    Color disabledTitleColor = new Color(216, 228, 244);
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private Action menuAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private JButton menuButton;
    private WindowListener windowListener;
    private ComponentListener windowMoveListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private LiquidRootPaneUI rootPaneUI;

    public LiquidTitlePane(JRootPane jRootPane, LiquidRootPaneUI liquidRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = liquidRootPaneUI;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
            this.windowMoveListener = new WindowMoveListener();
            this.window.addComponentListener(this.windowMoveListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.window.removeComponentListener(this.windowMoveListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        if (this.getWindowDecorationStyle() == 1) {
            this.createActions();
            if (!LiquidLookAndFeel.winDecoPanther) {
                this.menuBar = this.createMenuBar();
                this.add(this.menuBar);
            }
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            if (LiquidLookAndFeel.winDecoPanther) {
                this.add(this.menuButton);
                this.menuButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            }
            this.iconifyButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.toggleButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        } else if (this.getWindowDecorationStyle() != 0) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.FALSE);
            if (LiquidLookAndFeel.winDecoPanther) {
                this.add(this.menuButton);
                this.menuButton.putClientProperty("externalFrameButton", Boolean.FALSE);
            }
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar(this.createMenu());
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        return this.menuBar;
    }

    private void close() {
        this.isMenuShowed = false;
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        this.isMenuShowed = false;
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(frame.getExtendedState() | 1);
        }
    }

    private void maximize() {
        this.isMenuShowed = false;
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(frame.getExtendedState() | 6);
        }
    }

    private void setMaximizeBounds(Frame frame) {
        if (frame.getMaximizedBounds() != null) {
            return;
        }
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(frame.getGraphicsConfiguration());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = insets.top;
        int n2 = insets.left;
        int n3 = dimension.width - n - insets.right;
        int n4 = dimension.height - n2 - insets.bottom;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        frame.setMaximizedBounds(rectangle);
    }

    private void restore() {
        this.isMenuShowed = false;
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((frame.getExtendedState() & 1) == 1) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void showMenu(JPopupMenu jPopupMenu) {
        if (!this.isMenuShowed) {
            jPopupMenu.show(this, 0, 21);
            this.isMenuShowed = true;
        } else {
            this.isMenuShowed = false;
            jPopupMenu.setVisible(this.isMenuShowed);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
        this.menuAction = new MenuAction();
    }

    private JPopupMenu createMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.getWindowDecorationStyle() == 1 || this.getWindowDecorationStyle() == 2) {
            this.addMenuItems(jPopupMenu);
            jPopupMenu.putClientProperty("isSystemMenu", Boolean.TRUE);
        }
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        Locale locale = this.getRootPane().getLocale();
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('r');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('e');
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenuItem = jPopupMenu.add(this.maximizeAction);
            jMenuItem.setMnemonic('x');
        }
        jPopupMenu.addSeparator();
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('c');
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = LiquidWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = LiquidWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = LiquidWindowButtonUI.createButtonUIForType(0);
            if (LiquidLookAndFeel.winDecoPanther) {
                menuButtonUI = LiquidWindowButtonUI.createButtonUIForType(4);
            }
        }
        this.iconifyButton = new SpecialUIButton((ButtonUI)iconButtonUI, (Window)this.getRootPane().getParent());
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setRolloverEnabled(true);
        this.toggleButton = new SpecialUIButton((ButtonUI)maxButtonUI, (Window)this.getRootPane().getParent());
        this.toggleButton.setAction(this.maximizeAction);
        this.toggleButton.setRolloverEnabled(true);
        this.closeButton = new SpecialUIButton((ButtonUI)closeButtonUI, (Window)this.getRootPane().getParent());
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        if (LiquidLookAndFeel.winDecoPanther) {
            this.menuButton = new SpecialUIButton((ButtonUI)menuButtonUI, (Window)this.getRootPane().getParent());
            this.menuButton.setAction(this.menuAction);
            this.menuButton.setRolloverEnabled(true);
            this.menuButton.getAccessibleContext().setAccessibleName("Menu");
        }
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean bl) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", bl2);
            this.closeButton.putClientProperty("paintActive", bl2);
            this.toggleButton.putClientProperty("paintActive", bl2);
            this.iconifyButton.setEnabled(bl);
            this.closeButton.setEnabled(bl);
            this.toggleButton.setEnabled(bl);
            if (LiquidLookAndFeel.winDecoPanther) {
                this.menuButton.putClientProperty("paintActive", bl2);
                this.menuButton.setEnabled(bl);
            }
        }
        this.getRootPane().repaint();
    }

    private void setState(int n) {
        this.setState(n, false);
    }

    private void setState(int n, boolean bl) {
        Window window = this.getWindow();
        if (window != null && (this.getWindowDecorationStyle() == 1 || this.getWindowDecorationStyle() == 2)) {
            if (this.state == n && !bl) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane jRootPane = this.getRootPane();
                if ((n & 6) == 6 && (jRootPane.getBorder() == null || jRootPane.getBorder() instanceof UIResource) && frame.isShowing() || (n & 6) != 6) {
                    // empty if block
                }
                if (frame.isResizable()) {
                    if ((n & 4) == 4 || (n & 2) == 2) {
                        this.updateToggleButton(this.restoreAction);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n;
        }
    }

    private void updateToggleButton(Action action) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    public boolean isSelected() {
        Window window = this.getWindow();
        return window == null ? true : window.isActive();
    }

    public boolean isFrameMaximized() {
        Frame frame = this.getFrame();
        if (frame != null) {
            return (frame.getExtendedState() & 6) == 6;
        }
        return false;
    }

    public void paintComponent(Graphics graphics) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        Window window = this.getWindow();
        boolean bl = window.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.isSelected();
        if (bl2) {
            this.prevState = true;
        }
        if (!this.prevState && !bl2) {
            bl2 = true;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = LiquidLookAndFeel.getWindowTitleInactiveForeground();
        if (LiquidLookAndFeel.winDecoPanther) {
            this.drawPantherCaption(graphics, bl2, n, n2);
        } else {
            this.drawLiquidCaption(graphics, bl2, n, n2);
        }
        int n3 = 0;
        int n4 = bl ? 2 : n - 2;
        String string = this.getTitle();
        if (string != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n3 = fontMetrics.stringWidth(string);
            int n5 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + 1;
            if (!bl) {
                n4 -= n3;
            }
            n4 = n / 2 - n3 / 2;
            if (bl2) {
                Object object;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (!LiquidLookAndFeel.winDecoPanther) {
                    object = new GradientPaint(n4 + n3 / 2, n5 - 15, new Color(60, 144, 233), n4 + n3 / 2, fontMetrics.getHeight() + 6, new Color(102, 186, 255));
                    graphics2D.setPaint((Paint)object);
                    graphics2D.fillRoundRect(n4 - 8, n5 - 15, n3 + 15, n2 - 6, 18, 18);
                    graphics.setColor(new Color(0, 78, 167));
                    graphics2D.drawRoundRect(n4 - 8, n5 - 15, n3 + 15, n2 - 6, 18, 18);
                }
                graphics.setColor(Color.black);
                if (!LiquidLookAndFeel.winDecoPanther) {
                    graphics.drawString(string, n4 + 1, n5);
                    graphics.setColor(this.normalTitleColor);
                } else {
                    object = null;
                    Dialog dialog = null;
                    Image image = null;
                    Window window2 = this.getWindow();
                    if (window2 instanceof Frame) {
                        object = (Frame)window2;
                        image = ((Frame)object).getIconImage();
                    } else {
                        dialog = (Dialog)window2;
                        if (dialog.getParent() != null && dialog.getParent() instanceof Frame) {
                            image = ((Frame)dialog.getParent()).getIconImage();
                        }
                    }
                    if (image != null) {
                        graphics.drawImage(image, (n4 += 10) - 20, 3, 16, 16, null);
                    } else {
                        Icon icon = UIManager.getIcon("InternalFrame.pantherIcon");
                        if (icon != null) {
                            icon.paintIcon(this, graphics, (n4 += 10) - 20, 3);
                        }
                    }
                }
                graphics.drawString(string, n4, n5 - 1);
                n4 += bl ? n3 + 2 : -2;
            } else {
                Object object;
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (!LiquidLookAndFeel.winDecoPanther) {
                    object = new GradientPaint(n4 + n3 / 2, n5 - 15, new Color(191, 211, 233), n4 + n3 / 2, fontMetrics.getHeight() + 6, new Color(233, 253, 255));
                    graphics2D.setPaint((Paint)object);
                    graphics2D.fillRoundRect(n4 - 8, n5 - 15, n3 + 15, n2 - 6, 18, 18);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics.setColor(new Color(125, 145, 167));
                    graphics2D.drawRoundRect(n4 - 8, n5 - 15, n3 + 15, n2 - 6, 18, 18);
                }
                if (LiquidLookAndFeel.winDecoPanther) {
                    object = null;
                    Dialog dialog = null;
                    Image image = null;
                    Window window3 = this.getWindow();
                    if (window3 instanceof Frame) {
                        object = (Frame)window3;
                        image = ((Frame)object).getIconImage();
                    } else {
                        dialog = (Dialog)window3;
                        if (dialog.getParent() != null && dialog.getParent() instanceof Frame) {
                            image = ((Frame)dialog.getParent()).getIconImage();
                        }
                    }
                    if (image != null) {
                        graphics.drawImage(image, (n4 += 10) - 20, 3, 16, 16, null);
                    } else {
                        Icon icon = UIManager.getIcon("InternalFrame.pantherIconInactive");
                        if (icon != null) {
                            icon.paintIcon(this, graphics, (n4 += 10) - 20, 3);
                        }
                    }
                }
                graphics.setColor(LiquidLookAndFeel.winDecoPanther ? new Color(115, 115, 115) : Color.black);
                graphics.drawString(string, n4, n5 - 1);
                n4 += bl ? n3 + 2 : -2;
            }
        }
    }

    private void drawLiquidCaption(Graphics graphics, boolean bl, int n, int n2) {
        Color color = bl ? new Color(62, 145, 235) : new Color(175, 214, 255);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2 - 1);
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n, 0);
        color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
        graphics.setColor(color);
        graphics.drawLine(0, 1, n, 1);
        for (int i = 4; i < n2 - 1; i += 4) {
            color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
            graphics.setColor(color);
            graphics.drawLine(0, i, n, i);
            color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
            graphics.setColor(color);
            graphics.drawLine(0, i + 1, n, i + 1);
        }
        color = bl ? new Color(47, 111, 180) : new Color(135, 164, 196);
        graphics.setColor(color);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    private void drawPantherCaption(Graphics graphics, boolean bl, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = bl ? new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, n2 - 1, new Color(192, 192, 192)) : new GradientPaint(0.0f, 0.0f, new Color(230, 230, 230), 0.0f, n2 - 1, new Color(202, 202, 202));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2 - 1);
        graphics2D.setColor(new Color(198, 198, 198));
        graphics2D.drawLine(0, 0, n - 1, 0);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawLine(0, 1, n - 1, 1);
        graphics2D.setColor(new Color(147, 147, 147));
        graphics2D.drawLine(0, n2 - 1, n, n2 - 1);
    }

    private String clippedText(String string, FontMetrics fontMetrics, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n2 > n) {
            int n3;
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n3 = 0; n3 < string.length() && (n4 += fontMetrics.charWidth(string.charAt(n3))) <= n; ++n3) {
            }
            string = string.substring(0, n3) + string2;
        }
        return string;
    }

    private int getInt(Object object, int n) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    class WindowMoveListener
    extends ComponentAdapter {
        WindowMoveListener() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (LiquidTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = LiquidTitlePane.this.getWindow();
            window.repaint(0, 0, window.getWidth(), 5);
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (LiquidTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = LiquidTitlePane.this.getWindow();
            window.repaint(0, 0, window.getWidth(), 5);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            LiquidTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            LiquidTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = LiquidTitlePane.this.getFrame();
                if (frame != null) {
                    LiquidTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(string)) {
                    LiquidTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                LiquidTitlePane.this.repaint();
            } else if ("componentOrientation".equals(string)) {
                LiquidTitlePane.this.revalidate();
                LiquidTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private int computeHeight() {
            if (LiquidTitlePane.this.getFrame() instanceof JFrame) {
                LiquidTitlePane.this.setMaximizeBounds(LiquidTitlePane.this.getFrame());
                if (LiquidLookAndFeel.winDecoPanther) {
                    return 22;
                }
                return 25;
            }
            if (LiquidLookAndFeel.winDecoPanther) {
                return 22;
            }
            return 25;
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            if (LiquidTitlePane.this.getWindowDecorationStyle() == 0) {
                LiquidTitlePane.this.buttonsWidth = 0;
                return;
            }
            boolean bl = LiquidTitlePane.this.window == null ? LiquidTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : LiquidTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int n4 = LiquidTitlePane.this.getWidth();
            if (LiquidTitlePane.this.closeButton != null) {
                n3 = ((LiquidTitlePane)LiquidTitlePane.this).closeButton.getPreferredSize().height;
                n2 = ((LiquidTitlePane)LiquidTitlePane.this).closeButton.getPreferredSize().width;
            } else {
                n3 = 16;
                n2 = 16;
            }
            int n5 = (LiquidTitlePane.this.getHeight() - n3) / 2 + 1;
            int n6 = bl ? n4 : 0;
            int n7 = LiquidLookAndFeel.winDecoPanther ? 2 : 0;
            int n8 = n6 = bl ? n7 : n4 - n2 - n7;
            if (LiquidTitlePane.this.menuBar != null) {
                LiquidTitlePane.this.menuBar.setBounds(n6, n5, n2, n3);
            }
            int n9 = n6 = bl ? n4 : 0;
            n6 += LiquidLookAndFeel.winDecoPanther ? (bl ? -n7 - 3 - n2 : n7) : (bl ? -n7 - n2 : n7);
            int n10 = n = LiquidLookAndFeel.winDecoPanther ? 1 : 0;
            if (LiquidTitlePane.this.closeButton != null) {
                LiquidTitlePane.this.closeButton.setBounds(n6, n5 - n, n2, n3);
            }
            if (LiquidTitlePane.this.menuButton != null) {
                LiquidTitlePane.this.menuButton.setBounds(3, n5 - n + 1, 21, 12);
            }
            if (!bl) {
                n6 += n2;
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && LiquidTitlePane.this.toggleButton.getParent() != null) {
                LiquidTitlePane.this.toggleButton.setBounds(n6 += bl ? -n7 - n2 : n7, n5 - n, n2, n3);
                if (!bl) {
                    n6 += n2;
                }
            }
            if (LiquidTitlePane.this.iconifyButton != null && LiquidTitlePane.this.iconifyButton.getParent() != null) {
                LiquidTitlePane.this.iconifyButton.setBounds(n6 += bl ? -n7 - n2 : n7, n5 - n, n2, n3);
                if (!bl) {
                    n6 += n2;
                }
            }
            LiquidTitlePane.this.buttonsWidth = bl ? n4 - n6 : n6;
        }
    }

    private class SystemMenuBar
    extends JMenuBar
    implements MouseListener {
        private JPopupMenu systemMenu;
        private boolean isShowed = false;

        public SystemMenuBar(JPopupMenu jPopupMenu) {
            this.systemMenu = jPopupMenu;
            this.addMouseListener(this);
        }

        protected void setSystemMenuVisible(boolean bl) {
            this.isShowed = bl;
        }

        public void paint(Graphics graphics) {
            Image image;
            if (LiquidLookAndFeel.winDecoPanther) {
                return;
            }
            Frame frame = LiquidTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                graphics.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Icon icon = UIManager.getIcon("InternalFrame.icon");
            if (icon != null) {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(16, dimension.width), Math.max(dimension.height, 16));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isShowed) {
                this.systemMenu.show(this, 0, 18);
                this.isShowed = true;
            } else {
                this.isShowed = false;
                this.systemMenu.setVisible(this.isShowed);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.systemMenu.isVisible()) {
                this.isShowed = false;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class MenuAction
    extends AbstractAction {
        public MenuAction() {
            super("Menu");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LiquidTitlePane.this.showMenu(LiquidTitlePane.this.createMenu());
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super("Maximize");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LiquidTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super("Restore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LiquidTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super("Minimize");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LiquidTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LiquidTitlePane.this.close();
        }
    }
}

