/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidSpinnerButtonUI;
import com.birosoft.liquid.SpecialUIButton;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.InternationalFormatter;

public class LiquidSpinnerUI
extends BasicSpinnerUI {
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private static final Dimension zeroSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidSpinnerUI();
    }

    protected Component createPreviousButton() {
        SpecialUIButton specialUIButton = new SpecialUIButton(new LiquidSpinnerButtonUI(5));
        specialUIButton.setFocusable(false);
        specialUIButton.addActionListener(previousButtonHandler);
        specialUIButton.addMouseListener(previousButtonHandler);
        return specialUIButton;
    }

    protected Component createNextButton() {
        SpecialUIButton specialUIButton = new SpecialUIButton(new LiquidSpinnerButtonUI(1));
        specialUIButton.setFocusable(false);
        specialUIButton.addActionListener(nextButtonHandler);
        specialUIButton.addMouseListener(nextButtonHandler);
        return specialUIButton;
    }

    protected JComponent createEditor() {
        JComponent jComponent = super.createEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            defaultEditor.getTextField().setBorder(new EmptyBorder(0, 0, 0, 0));
            Dimension dimension = defaultEditor.getPreferredSize();
            int n = dimension.height;
            int n2 = LiquidSpinnerButtonUI.getSkin(1).getVsize() + LiquidSpinnerButtonUI.getSkin(5).getVsize();
            int n3 = n2 - n;
            if (n3 > 0) {
                int n4 = n3 / 2;
                defaultEditor.getTextField().setBorder(new EmptyBorder(n4, 0, n3 - n4, 0));
            }
        }
        return jComponent;
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String string, boolean bl) {
            super(string);
            this.isNext = bl;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSpinner jSpinner = this.spinner;
            if (!(actionEvent.getSource() instanceof Timer)) {
                jSpinner = this.eventToSpinner(actionEvent);
            }
            if (jSpinner != null) {
                try {
                    Object object;
                    int n = this.getCalendarField(jSpinner);
                    jSpinner.commitEdit();
                    if (n != -1) {
                        ((SpinnerDateModel)jSpinner.getModel()).setCalendarField(n);
                    }
                    Object object2 = object = this.isNext ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
                    if (object != null) {
                        jSpinner.setValue(object);
                        this.select(jSpinner);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
            }
        }

        private void select(JSpinner jSpinner) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                SpinnerDateModel spinnerDateModel;
                DateFormat.Field field;
                Object object;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                SimpleDateFormat simpleDateFormat = dateEditor.getFormat();
                if (simpleDateFormat != null && (object = jSpinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((spinnerDateModel = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator attributedCharacterIterator = ((Format)simpleDateFormat).formatToCharacterIterator(object);
                        if (!this.select(jFormattedTextField, attributedCharacterIterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(jFormattedTextField, attributedCharacterIterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean select(JFormattedTextField jFormattedTextField, AttributedCharacterIterator attributedCharacterIterator, DateFormat.Field field) {
            int n = jFormattedTextField.getDocument().getLength();
            attributedCharacterIterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> map;
                if ((map = attributedCharacterIterator.getAttributes()) == null || !map.containsKey(field)) continue;
                int n2 = attributedCharacterIterator.getRunStart(field);
                int n3 = attributedCharacterIterator.getRunLimit(field);
                if (n2 != -1 && n3 != -1 && n2 <= n && n3 <= n) {
                    jFormattedTextField.select(n2, n3);
                }
                return true;
            } while (attributedCharacterIterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner jSpinner) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                int n = jFormattedTextField.getSelectionStart();
                JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
                if (abstractFormatter instanceof InternationalFormatter) {
                    Format.Field[] fieldArray = ((InternationalFormatter)abstractFormatter).getFields(n);
                    for (int i = 0; i < fieldArray.length; ++i) {
                        int n2;
                        if (!(fieldArray[i] instanceof DateFormat.Field) || (n2 = fieldArray[i] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fieldArray[i]).getCalendarField()) == -1) continue;
                        return n2;
                    }
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(mouseEvent);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void focusSpinnerIfNecessary() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (component == null || !SwingUtilities.isDescendingFrom(component, this.spinner))) {
                FocusTraversalPolicy focusTraversalPolicy;
                Component component2;
                Container container = this.spinner;
                if (!container.isFocusCycleRoot()) {
                    container = container.getFocusCycleRootAncestor();
                }
                if (container != null && (component2 = (focusTraversalPolicy = container.getFocusTraversalPolicy()).getComponentAfter(container, this.spinner)) != null && SwingUtilities.isDescendingFrom(component2, this.spinner)) {
                    component2.requestFocus();
                }
            }
        }
    }
}

