/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class LiquidProgressBarUI
extends BasicProgressBarUI {
    static Skin skinHorizontal;
    static Skin skinVertical;
    int offset = 3;

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidProgressBarUI();
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n3 = this.getCellLength();
        int n4 = this.getCellSpacing();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.progressBar.getOrientation() == 0) {
            int n5 = this.getAmountFull(insets, n - this.offset * 2, n2);
            LiquidProgressBarUI.getSkinHorizontal().draw(graphics, 0, n, n2);
            graphics.translate(this.offset - 1, 0);
            BufferedImage bufferedImage = SkinImageCache.getInstance().getBufferedImage("hprogressbar.png");
            TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(1, 3, n5, n2 - 6);
            graphics2D.setPaint(paint);
            if (n5 > 0) {
                graphics2D.setColor(new Color(179, 192, 207));
                graphics2D.drawLine(0, 2, 0, n2 - 4);
                graphics2D.drawLine(0, 2, n5, 2);
                graphics2D.setColor(new Color(195, 209, 226));
                graphics2D.drawLine(n5 + 1, 2, n5 + 1, n2 - 3);
                graphics2D.drawLine(0, n2 - 3, n5 + 1, n2 - 3);
            }
            graphics.translate(-this.offset + 1, 0);
            if (this.progressBar.isStringPainted()) {
                graphics.setColor(Color.black);
                this.paintString(graphics, insets.left, insets.top, n, n2, n5, insets);
            }
        } else {
            int n6 = this.getAmountFull(insets, n, n2 - 2 * this.offset);
            LiquidProgressBarUI.getSkinVertical().draw(graphics, 0, n, n2);
            BufferedImage bufferedImage = SkinImageCache.getInstance().getBufferedImage("XPProgressIndicatorVert.res");
            n6 = n6 / bufferedImage.getHeight() * bufferedImage.getHeight();
            graphics.translate(0, n2 - this.offset);
            BufferedImage bufferedImage2 = SkinImageCache.getInstance().getBufferedImage("XPLeftProgressBar.res");
            BufferedImage bufferedImage3 = SkinImageCache.getInstance().getBufferedImage("XPCenterProgressBar.res");
            BufferedImage bufferedImage4 = SkinImageCache.getInstance().getBufferedImage("XPRightProgressBar.res");
            TexturePaint texturePaint = new TexturePaint(bufferedImage2, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
            TexturePaint texturePaint2 = new TexturePaint(bufferedImage3, new Rectangle2D.Float(bufferedImage2.getWidth(), 0.0f, bufferedImage3.getWidth(), bufferedImage3.getHeight()));
            TexturePaint texturePaint3 = new TexturePaint(bufferedImage4, new Rectangle2D.Float(n - bufferedImage4.getWidth(), 0.0f, bufferedImage4.getWidth(), bufferedImage4.getHeight()));
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(0, -n6, bufferedImage2.getWidth(), n6);
            graphics2D.setPaint(texturePaint2);
            graphics2D.fillRect(bufferedImage2.getWidth(), -n6, n - bufferedImage4.getWidth() - bufferedImage2.getWidth(), n6);
            graphics2D.setPaint(texturePaint3);
            graphics2D.fillRect(n - bufferedImage4.getWidth(), -n6, bufferedImage4.getWidth(), n6);
            graphics2D.setPaint(paint);
            graphics.translate(0, -(n2 - this.offset));
            if (this.progressBar.isStringPainted()) {
                graphics.setColor(Color.black);
                this.paintString(graphics, insets.left, insets.top, n, n2, n6, insets);
            }
        }
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Rectangle rectangle = this.getBox(null);
        if (this.progressBar.getOrientation() == 0) {
            LiquidProgressBarUI.getSkinHorizontal().draw(graphics, 0, n, n2);
            graphics.translate(rectangle.x + this.offset, rectangle.y);
            BufferedImage bufferedImage = SkinImageCache.getInstance().getBufferedImage("hprogressbar.png");
            TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(1, 3, 20, n2 - 6);
            graphics2D.setPaint(paint);
            graphics2D.setColor(new Color(195, 209, 226));
            graphics2D.drawLine(20, 2, 20, n2 - 4);
            graphics2D.drawLine(0, n2 - 3, 20, n2 - 3);
            graphics2D.setColor(new Color(179, 192, 207));
            graphics2D.drawLine(0, 2, 0, n2 - 4);
            graphics2D.drawLine(0, 2, 20, 2);
            graphics.translate(-rectangle.x - this.offset, -rectangle.y);
        } else {
            LiquidProgressBarUI.getSkinVertical().draw(graphics, 0, n, n2);
            graphics.translate(rectangle.x, rectangle.y + this.offset);
            BufferedImage bufferedImage = SkinImageCache.getInstance().getBufferedImage("XPLeftProgressBar.res");
            BufferedImage bufferedImage2 = SkinImageCache.getInstance().getBufferedImage("XPCenterProgressBar.res");
            BufferedImage bufferedImage3 = SkinImageCache.getInstance().getBufferedImage("XPRightProgressBar.res");
            TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
            TexturePaint texturePaint2 = new TexturePaint(bufferedImage2, new Rectangle2D.Float(bufferedImage.getWidth(), 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
            TexturePaint texturePaint3 = new TexturePaint(bufferedImage3, new Rectangle2D.Float(n - bufferedImage3.getWidth(), 0.0f, bufferedImage3.getWidth(), bufferedImage3.getHeight()));
            int n3 = (rectangle.height - 2 * this.offset) / bufferedImage2.getHeight() * bufferedImage2.getHeight();
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), n3);
            graphics2D.setPaint(texturePaint2);
            graphics2D.fillRect(bufferedImage.getWidth(), 0, n - bufferedImage3.getWidth() - bufferedImage.getWidth(), n3);
            graphics2D.setPaint(texturePaint3);
            graphics2D.fillRect(n - bufferedImage3.getWidth(), 0, bufferedImage3.getWidth(), n3);
            graphics2D.setPaint(paint);
            graphics.translate(-rectangle.x, -rectangle.y - this.offset);
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    protected void installDefaults() {
    }

    public static Skin getSkinHorizontal() {
        if (skinHorizontal == null) {
            skinHorizontal = new Skin("progressborderhoriz.png", 1, 1, 1, 1, 1);
        }
        return skinHorizontal;
    }

    public static Skin getSkinVertical() {
        if (skinVertical == null) {
            skinVertical = new Skin("progressbordervert.png", 1, 1, 1, 1, 1);
        }
        return skinVertical;
    }
}

