/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class FluxDebugger {
    private static final String FLUX_DEBUG_FILE = "fluxDebug.txt";
    private static FluxDebugger debugger;
    private BufferedWriter writer;

    private FluxDebugger() {
        try {
            this.writer = new BufferedWriter(new FileWriter(FLUX_DEBUG_FILE, false));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public BufferedWriter writer() {
        return this.writer;
    }

    public static FluxDebugger getDebugger() {
        if (debugger == null) {
            debugger = new FluxDebugger();
        }
        return debugger;
    }

    public static void write(String string) {
        try {
            FluxDebugger.getDebugger().writer().write(string);
            FluxDebugger.getDebugger().writer().flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void finalize() throws Throwable {
        this.writer.close();
        super.finalize();
    }

    public static void writeln(String string) {
        FluxDebugger.write(string + "\n");
    }

    public static void runGC() {
        for (int i = 0; i < 4; ++i) {
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

