/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.volume;

import de.grogra.gpuflux.scene.volume.FluxBox;
import de.grogra.gpuflux.scene.volume.FluxCylinder;
import de.grogra.gpuflux.scene.volume.FluxFrustum;
import de.grogra.gpuflux.scene.volume.FluxPlane;
import de.grogra.gpuflux.scene.volume.FluxPolygon;
import de.grogra.gpuflux.scene.volume.FluxPrimitive;
import de.grogra.gpuflux.scene.volume.FluxSphere;
import de.grogra.gpuflux.scene.volume.FluxVertex;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.VolumeBuilderBase;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.Pool;
import de.grogra.pf.boot.Main;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray2.radiosity.Vector3d;
import de.grogra.vecmath.geom.Cone;
import de.grogra.vecmath.geom.Cube;
import de.grogra.vecmath.geom.Cylinder;
import de.grogra.vecmath.geom.FrustumBase;
import de.grogra.vecmath.geom.HalfSpace;
import de.grogra.vecmath.geom.Sphere;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FluxVolumeBuilder
extends VolumeBuilderBase
implements RenderState {
    private static final float EPSILON = 1.0E-4f;
    private Vector<FluxVertex> vertices = new Vector();
    GraphState state;
    private float flatness;
    private Vector<MeshVolume> meshVolumes = new Vector();

    public FluxVolumeBuilder(GraphState graphState, float f) {
        super(null, 1.0E-4f);
        this.state = graphState;
        this.flatness = f;
        this.polyCache = new PolygonizationCache(graphState, 3, f, true);
    }

    public GraphState getRenderGraphState() {
        return null;
    }

    public Pool getPool() {
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public int getCurrentHighlight() {
        return 0;
    }

    public float estimateScaleAt(Tuple3f tuple3f) {
        return 0.0f;
    }

    public Shader getCurrentShader() {
        return null;
    }

    public void drawPoint(Tuple3f tuple3f, int n, Tuple3f tuple3f2, int n2, Matrix4d matrix4d) {
    }

    public void drawPointCloud(float[] fArray, float f, Tuple3f tuple3f, int n, Matrix4d matrix4d) {
        Main.getLogger().warning("GPUFlux does not support pointclouds, object ignored");
        Workbench.current().logGUIInfo("GPUFlux does not support pointclouds, object ignored");
    }

    public void drawLine(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, int n, Matrix4d matrix4d) {
    }

    public void drawParallelogram(float f, Vector3f vector3f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        Matrix4f matrix4f = new Matrix4f();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.invert(matrix4d);
        matrix4f.set(matrix4d2);
        matrix4d2.transpose(matrix4d2);
        Vector3d vector3d = new Vector3d((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        Vector3d vector3d2 = new Vector3d(0.0, 0.0, (double)f);
        vector3d2.cross((javax.vecmath.Vector3d)vector3d, (javax.vecmath.Vector3d)vector3d2);
        vector3d2.normalize();
        int n2 = this.getVertices().size();
        FluxVertex fluxVertex = new FluxVertex(new Point3d(-vector3d.x, -vector3d.y, -vector3d.z), (Vector3d)vector3d2.clone(), new Point2d(0.0, 0.0));
        FluxVertex fluxVertex2 = new FluxVertex(new Point3d(vector3d.x, vector3d.y, vector3d.z), (Vector3d)vector3d2.clone(), new Point2d(1.0, 0.0));
        FluxVertex fluxVertex3 = new FluxVertex(new Point3d(-vector3d.x, -vector3d.y, (double)f - vector3d.z), (Vector3d)vector3d2.clone(), new Point2d(0.0, 1.0));
        fluxVertex.transform(matrix4d, matrix4d2);
        fluxVertex2.transform(matrix4d, matrix4d2);
        fluxVertex3.transform(matrix4d, matrix4d2);
        this.getVertices().add(fluxVertex);
        this.getVertices().add(fluxVertex2);
        this.getVertices().add(fluxVertex3);
        this.addPrimitive(new FluxPolygon(n2, n2 + 1, n2 + 2, this.getVertices(), true, matrix4f));
    }

    public void drawPlane(Shader shader, int n, Matrix4d matrix4d) {
        HalfSpace halfSpace = this.buildPlane(matrix4d = this.getTransformation(matrix4d));
        if (halfSpace != null) {
            this.addInfinitePrimitive(new FluxPlane(halfSpace));
        }
    }

    public void drawSphere(float f, Shader shader, int n, Matrix4d matrix4d) {
        Sphere sphere = this.buildSphere(f, matrix4d = this.getTransformation(matrix4d));
        if (sphere != null) {
            this.addPrimitive(new FluxSphere(sphere));
        }
    }

    public void drawSupershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Shader shader, int n, Matrix4d matrix4d) {
        Main.getLogger().warning("GPUFlux does not support supershape, object ignored");
        Workbench.current().logGUIInfo("GPUFlux does not support supershape, object ignored");
    }

    public void drawBox(float f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        Cube cube = this.buildBox(f, f2, f3, matrix4d = this.getTransformation(matrix4d));
        if (cube != null) {
            this.addPrimitive(new FluxBox(cube));
        }
    }

    public void drawFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Shader shader, int n, Matrix4d matrix4d) {
        FrustumBase frustumBase = this.buildBaseFrustum(f, f2, f3, bl, bl2, f4, matrix4d = this.getTransformation(matrix4d));
        if (frustumBase != null) {
            if (frustumBase instanceof Cone) {
                this.addPrimitive(new FluxFrustum((Cone)frustumBase));
            } else if (frustumBase instanceof Cylinder) {
                this.addPrimitive(new FluxCylinder((Cylinder)frustumBase));
            }
        }
    }

    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        PolygonArray polygonArray = this.polyCache.get(object, bl, polygonizable);
        matrix4d = this.getTransformation(matrix4d);
        Matrix4f matrix4f = new Matrix4f();
        Matrix4d matrix4d2 = new Matrix4d();
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d2.invert(matrix4d);
        matrix4f.set(matrix4d2);
        matrix4d3.transpose(matrix4d2);
        if (!polygonArray.wasCleared()) {
            MeshVolume meshVolume = (MeshVolume)polygonArray.userObject;
            if (meshVolume == null) {
                return;
            }
            int n2 = this.getVertices().size();
            for (int i = meshVolume.vertexStart; i < meshVolume.vertexStart + meshVolume.vertexCount; ++i) {
                this.getVertices().add((FluxVertex)this.getVertices().get(i).clone());
            }
            Vector<FluxPrimitive> vector = new Vector<FluxPrimitive>();
            for (FluxPrimitive fluxPrimitive : meshVolume.primitives) {
                FluxPolygon fluxPolygon = (FluxPolygon)((FluxPolygon)fluxPrimitive).clone();
                fluxPolygon.setWorld2Obj(matrix4f);
                vector.add(fluxPolygon);
            }
            this.addPrimitives(vector);
            MeshVolume meshVolume2 = new MeshVolume(n2, meshVolume.vertexCount, vector, (Matrix4d)matrix4d.clone());
            this.meshVolumes.add(meshVolume2);
        } else {
            Object object2;
            int n3;
            polygonArray.userObject = null;
            Vector3d vector3d = new Vector3d();
            Point3d point3d = new Point3d();
            Point2d point2d = new Point2d();
            int n4 = this.getVertices().size();
            if (polygonArray.getVertexCount() == 0 || polygonArray.getMaxEdgeCount() == 0) {
                return;
            }
            for (n3 = 0; n3 < polygonArray.getVertexCount(); ++n3) {
                polygonArray.getVertex(n3, (Tuple3d)point3d);
                polygonArray.getNormal(n3, (Tuple3d)vector3d);
                polygonArray.getUV(n3, (Tuple2d)point2d);
                vector3d.normalize();
                object2 = new FluxVertex(point3d, vector3d, point2d);
                this.getVertices().add((FluxVertex)object2);
            }
            n3 = polygonArray.getPolygonCount();
            if (n3 == 0) {
                return;
            }
            object2 = new int[polygonArray.getMaxEdgeCount()];
            int[] nArray = new int[polygonArray.getMaxEdgeCount()];
            Vector<FluxPrimitive> vector = new Vector<FluxPrimitive>();
            if (polygonArray.edgeCount > 0) {
                for (int i = 0; i < n3; ++i) {
                    polygonArray.getPolygon(i, object2, nArray);
                    for (int j = 0; j < ((int[])object2).length - 2; ++j) {
                        int n5 = object2[0];
                        int n6 = object2[j + 1];
                        int n7 = object2[j + 2];
                        vector.add(new FluxPolygon(n5, n6, n7, this.getVertices(), false, matrix4f));
                    }
                }
            }
            MeshVolume meshVolume = new MeshVolume(n4, polygonArray.getVertexCount(), vector, (Matrix4d)matrix4d.clone());
            polygonArray.userObject = meshVolume;
            this.addPrimitives(vector);
            this.meshVolumes.add(meshVolume);
        }
    }

    public void finish() {
        this.polyCache.clear();
        for (MeshVolume meshVolume : this.meshVolumes) {
            Matrix4d matrix4d = new Matrix4d();
            Matrix4d matrix4d2 = new Matrix4d();
            matrix4d.invert(meshVolume.transform);
            matrix4d2.transpose(matrix4d);
            for (int i = meshVolume.vertexStart; i < meshVolume.vertexStart + meshVolume.vertexCount; ++i) {
                this.getVertices().get(i).transform(meshVolume.transform, matrix4d2);
            }
            for (FluxPrimitive fluxPrimitive : meshVolume.primitives) {
                ((FluxPolygon)fluxPrimitive).shiftIndex(meshVolume.vertexStart);
                ((FluxPolygon)fluxPrimitive).finish();
            }
        }
    }

    protected abstract void addPrimitives(Vector<FluxPrimitive> var1);

    public boolean getWindowPos(Tuple3f tuple3f, Tuple2f tuple2f) {
        return false;
    }

    public void drawRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
    }

    public void fillRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
    }

    public void drawString(int n, int n2, String string, Font font, Tuple3f tuple3f) {
    }

    protected abstract void addPrimitive(FluxPrimitive var1);

    protected abstract void addInfinitePrimitive(FluxPrimitive var1);

    public void setVertices(Vector<FluxVertex> vector) {
        this.vertices = vector;
    }

    public Vector<FluxVertex> getVertices() {
        return this.vertices;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MeshVolume {
        public int vertexStart;
        public int vertexCount;
        public Vector<FluxPrimitive> primitives;
        public Matrix4d transform;

        public MeshVolume(int n, int n2, Vector<FluxPrimitive> vector, Matrix4d matrix4d) {
            this.vertexStart = n;
            this.vertexCount = n2;
            this.primitives = vector;
            this.transform = matrix4d;
        }
    }
}

