/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.shading.channel;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.shading.channel.FluxBlend;
import de.grogra.gpuflux.scene.shading.channel.FluxBlendItem;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMap;
import de.grogra.gpuflux.scene.shading.channel.FluxHDRImageMap;
import de.grogra.gpuflux.scene.shading.channel.FluxImageMap;
import de.grogra.gpuflux.scene.shading.channel.FluxRGB;
import de.grogra.gpuflux.scene.shading.channel.FluxSpectralChannel;
import de.grogra.imp3d.objects.LightDistribution;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.BlendItem;
import de.grogra.imp3d.shading.BumpMap;
import de.grogra.imp3d.shading.Carpenter;
import de.grogra.imp3d.shading.ChannelBlend;
import de.grogra.imp3d.shading.ChannelMapNode;
import de.grogra.imp3d.shading.ChannelMapNodeVisitor;
import de.grogra.imp3d.shading.ChannelSPD;
import de.grogra.imp3d.shading.Checker;
import de.grogra.imp3d.shading.Filter;
import de.grogra.imp3d.shading.Gradient;
import de.grogra.imp3d.shading.Granite;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Julia;
import de.grogra.imp3d.shading.Laplace3D;
import de.grogra.imp3d.shading.Leopard;
import de.grogra.imp3d.shading.Mandel;
import de.grogra.imp3d.shading.Smooth3D;
import de.grogra.imp3d.shading.SunSkyLight;
import de.grogra.imp3d.shading.Turbulence;
import de.grogra.imp3d.shading.VolumeChecker;
import de.grogra.imp3d.shading.VolumeFunction;
import de.grogra.imp3d.shading.VolumeTurbulence;
import de.grogra.imp3d.shading.Wood;
import de.grogra.imp3d.shading.XYZTransformation;
import de.grogra.math.ChannelData;
import de.grogra.math.ChannelMap;
import de.grogra.math.ChannelMapInput;
import de.grogra.math.ChannelMapVisitor;
import de.grogra.math.ColorMap;
import de.grogra.math.Graytone;
import de.grogra.math.RGBColor;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Environment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FluxChannelMapBuilder
implements ChannelMapNodeVisitor {
    private boolean blendChannel = false;
    private FluxChannelMap currentChannelNode;
    private Hashtable<Object, FluxChannelMap> channelCache = new Hashtable();
    private Vector<FluxChannelMap> channels = new Vector();
    private Matrix3f uvTransformation = new Matrix3f();

    public FluxChannelMapBuilder() {
        this.uvTransformation.setIdentity();
    }

    public void visit(AffineUVTransformation affineUVTransformation) {
        Matrix3f matrix3f = this.uvTransformation;
        Matrix3f matrix3f2 = (Matrix3f)this.uvTransformation.clone();
        matrix3f2.mul(affineUVTransformation.getTransform());
        this.uvTransformation = matrix3f2;
        ChannelMap channelMap = affineUVTransformation.getInput();
        this.buildChannelMap(channelMap);
        this.uvTransformation = matrix3f;
    }

    public void visit(BumpMap bumpMap) {
        this.visit((ChannelMapNode)bumpMap);
    }

    public void visit(Carpenter carpenter) {
        this.visit((ChannelMapNode)carpenter);
    }

    public void visit(ChannelBlend channelBlend) {
        if (this.blendChannel) {
            Workbench.current().logGUIInfo("GPUFlux does not support nested blend channels, inner channel is discretized");
            this.visit((ChannelMapNode)channelBlend);
        } else {
            this.blendChannel = true;
            Vector<FluxBlendItem> vector = new Vector<FluxBlendItem>();
            for (BlendItem blendItem = channelBlend.getBlend(); blendItem != null; blendItem = blendItem.getNext()) {
                ChannelMap channelMap = blendItem.getInput();
                FluxChannelMap fluxChannelMap = this.buildChannelMap(channelMap, null);
                vector.add(new FluxBlendItem(fluxChannelMap, blendItem));
            }
            this.addChannelMap(new FluxBlend(vector), (ChannelMap)channelBlend);
            this.blendChannel = false;
        }
    }

    public void visit(Checker checker) {
        this.visit((ChannelMapNode)checker);
    }

    private Matrix3f getUVTransformation(ChannelMap channelMap) {
        Matrix3f matrix3f = (Matrix3f)this.uvTransformation.clone();
        if (channelMap instanceof ChannelMapNode && (channelMap = ((ChannelMapNode)channelMap).getInput()) instanceof AffineUVTransformation) {
            matrix3f.mul(((AffineUVTransformation)channelMap).getTransform());
        }
        return matrix3f;
    }

    public void visit(ImageMap imageMap) {
        BufferedImage bufferedImage = imageMap.getImageAdapter().getNativeImage();
        this.addCachedChannelMap(new FluxImageMap(bufferedImage), (ChannelMap)imageMap, bufferedImage);
    }

    public void visit(SunSkyLight sunSkyLight) {
        this.visit((ChannelMapNode)sunSkyLight);
    }

    public void visit(XYZTransformation xYZTransformation) {
        this.visit((ChannelMapNode)xYZTransformation);
    }

    protected FluxChannelMap getCachedChannelMap(Object object) {
        return this.channelCache.get(object);
    }

    protected void addCachedChannelMap(FluxChannelMap fluxChannelMap, ChannelMap channelMap, Object object) {
        FluxChannelMap fluxChannelMap2 = this.channelCache.get(object);
        if (fluxChannelMap2 != null) {
            this.currentChannelNode = fluxChannelMap2;
        } else {
            this.addChannelMap(fluxChannelMap, channelMap);
            this.channelCache.put(object, fluxChannelMap);
        }
    }

    protected void addChannelMap(FluxChannelMap fluxChannelMap, ChannelMap channelMap) {
        assert (fluxChannelMap != null);
        this.currentChannelNode = fluxChannelMap;
        this.channels.add(fluxChannelMap);
        fluxChannelMap.setUVTransformation(this.getUVTransformation(channelMap));
    }

    public FluxChannelMap buildChannelMap(ChannelMap channelMap) {
        return this.buildChannelMap(channelMap, null);
    }

    public FluxChannelMap buildChannelMap(ChannelMap channelMap, ColorMap colorMap) {
        this.currentChannelNode = null;
        if (channelMap == null) {
            channelMap = colorMap;
        }
        if (channelMap != null && channelMap instanceof ChannelMap) {
            channelMap.accept((ChannelMapVisitor)this);
        }
        return this.currentChannelNode;
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        for (FluxChannelMap fluxChannelMap : this.channels) {
            fluxChannelMap.setOffset(computeByteBuffer.size());
            fluxChannelMap.serialize(computeByteBuffer);
        }
    }

    public void visit(Graytone graytone) {
        this.addChannelMap(new FluxRGB(new RGBColor(graytone.getValue(), graytone.getValue(), graytone.getValue())), (ChannelMap)graytone);
    }

    public void visit(RGBColor rGBColor) {
        this.addChannelMap(new FluxRGB(rGBColor), (ChannelMap)rGBColor);
    }

    private void discretizeChannel(ChannelMap channelMap) {
        int n = FluxSettings.getChannelResolution();
        FluxChannelMap fluxChannelMap = this.getCachedChannelMap(channelMap);
        if (fluxChannelMap == null) {
            Environment environment = new Environment();
            if (!(environment.userObject instanceof ChannelMapInput)) {
                environment.userObjectOwner = channelMap;
                environment.userObject = new ChannelMapInput();
            }
            ChannelData channelData = ((ChannelMapInput)environment.userObject).getUserData(channelMap, null);
            ChannelData channelData2 = channelData.createSink(channelMap);
            environment.normal.set(0.0f, 0.0f, 1.0f);
            environment.dpdu.set(1.0f, 0.0f, 0.0f);
            environment.dpdv.set(0.0f, 1.0f, 0.0f);
            environment.solid = true;
            Point3f[][] point3fArray = new Point3f[n][n];
            ChannelData channelData3 = channelData2.getData(channelMap);
            channelData.setFloat(28, environment.iorRatio);
            channelData.setTuple3f(8, (Tuple3f)environment.dpdu);
            channelData.setTuple3f(12, (Tuple3f)environment.dpdv);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    float f = (float)i / (float)n;
                    float f2 = (float)j / (float)n;
                    LightDistribution.map2cartesian((Tuple3f)environment.point, f, f2);
                    environment.localPoint.set((Tuple3f)environment.point);
                    environment.normal.set((Tuple3f)environment.point);
                    environment.uv.set(f, f2);
                    channelData.setTuple3f(0, (Tuple3f)environment.point);
                    channelData.setTuple3f(20, (Tuple3f)environment.localPoint);
                    channelData.setTuple3f(4, (Tuple3f)environment.normal);
                    channelData.setTuple2f(16, (Tuple2f)environment.uv);
                    point3fArray[j][i] = new Point3f();
                    channelData3.getTuple3f((Tuple3f)point3fArray[j][i], channelData2, 24);
                }
            }
            this.addCachedChannelMap(new FluxHDRImageMap((Tuple3f[][])point3fArray), channelMap, channelMap);
        } else {
            this.currentChannelNode = fluxChannelMap;
        }
    }

    public void visit(ChannelMap channelMap) {
        if (channelMap instanceof ChannelSPD) {
            this.addChannelMap(new FluxSpectralChannel((ChannelSPD)channelMap), channelMap);
        } else {
            this.warning("GPUFlux does not support channel " + channelMap.getClass().getName() + ", discretized channel used instead.");
            this.discretizeChannel(channelMap);
        }
    }

    public void visit(ChannelMapNode channelMapNode) {
        if (channelMapNode instanceof ChannelMap) {
            this.visit((ChannelMap)channelMapNode);
        } else {
            this.warning("GPUFlux does not support channel node " + channelMapNode.getClass().getName() + ", discretized channel used instead.");
            this.discretizeChannel((ChannelMap)channelMapNode);
        }
    }

    public void visit(Filter filter) {
        this.visit((ChannelMapNode)filter);
    }

    public void visit(VolumeFunction volumeFunction) {
        this.visit((ChannelMapNode)volumeFunction);
    }

    public void visit(Gradient gradient) {
        this.visit((ChannelMapNode)gradient);
    }

    public void visit(Granite granite) {
        this.visit((ChannelMapNode)granite);
    }

    public void visit(Julia julia) {
        this.visit((ChannelMapNode)julia);
    }

    public void visit(Laplace3D laplace3D) {
        this.visit((ChannelMapNode)laplace3D);
    }

    public void visit(Leopard leopard) {
        this.visit((ChannelMapNode)leopard);
    }

    public void visit(Mandel mandel) {
        this.visit((ChannelMapNode)mandel);
    }

    public void visit(Smooth3D smooth3D) {
        this.visit((ChannelMapNode)smooth3D);
    }

    public void visit(Turbulence turbulence) {
        this.visit((ChannelMapNode)turbulence);
    }

    public void visit(VolumeChecker volumeChecker) {
        this.visit((ChannelMapNode)volumeChecker);
    }

    public void visit(VolumeTurbulence volumeTurbulence) {
        this.visit((ChannelMapNode)volumeTurbulence);
    }

    public void visit(Wood wood) {
        this.visit((ChannelMapNode)wood);
    }

    protected abstract void warning(String var1);

    public int getChannelCount() {
        return this.channels.size();
    }

    public Vector<FluxChannelMap> getChannels() {
        return this.channels;
    }
}

