/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.light;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.imp3d.objects.Parallelogram;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.Tuple3fType;
import java.io.IOException;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class FluxParallelLight
extends FluxLight {
    private static final int SAMPLE_COUNT = 50;
    private Parallelogram parallelogram;

    public FluxParallelLight(Parallelogram parallelogram) {
        super((Light)parallelogram);
        this.parallelogram = parallelogram;
    }

    public int getSampleCount() {
        return 50;
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        float f = this.parallelogram.getLight().getPower();
        Shader shader = this.parallelogram.getShader();
        Color3f color3f = new Color3f();
        Tuple3fType.setColor((Tuple3f)color3f, (int)(shader != null ? shader.getAverageColor() : -1));
        color3f.scale(3.0f * f / (color3f.x + color3f.y + color3f.z));
        this.serializeLightBase(computeByteBuffer, 3, (Tuple3f)color3f, null);
        computeByteBuffer.writeFloat(this.parallelogram.getLight().getExponent());
        Matrix4d matrix4d = this.getTransformation();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.invert(matrix4d);
        matrix4d2.transpose();
        Vector3f vector3f = new Vector3f();
        vector3f.set((Tuple3f)this.parallelogram.getAxis());
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, this.parallelogram.getLength());
        vector3f2.cross(vector3f, vector3f3);
        vector3f2.normalize();
        matrix4d.transform(vector3f);
        matrix4d.transform(vector3f3);
        matrix4d2.transform(vector3f2);
        computeByteBuffer.write((Tuple3f)vector3f);
        computeByteBuffer.write((Tuple3f)vector3f3);
        computeByteBuffer.write((Tuple3f)vector3f2);
    }
}

