/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.light;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.light.FluxDirectionalLight;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.gpuflux.scene.light.FluxParallelLight;
import de.grogra.gpuflux.scene.light.FluxPhysicalLight;
import de.grogra.gpuflux.scene.light.FluxPointLight;
import de.grogra.gpuflux.scene.light.FluxSkyLight;
import de.grogra.gpuflux.scene.light.FluxSpectralLight;
import de.grogra.gpuflux.scene.light.FluxSpotLight;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.gpuflux.scene.shading.FluxShaderBuilder;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMap;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.Instantiator;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.Visitor3D;
import de.grogra.imp3d.objects.AmbientLight;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.LightNode;
import de.grogra.imp3d.objects.Parallelogram;
import de.grogra.imp3d.objects.PhysicalLight;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.objects.SpectralLight;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SunSkyLight;
import de.grogra.ray.physics.Environment;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Stack;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxLightBuilder
implements LightVisitor {
    private Vector<FluxLight> lights = new Vector();
    private Matrix4d currentTransformation;
    private int lightSampleCount = 0;
    private FluxShaderBuilder shaderBuilder;
    private FluxLight sky = null;
    private FluxLight currentLight;
    private Graph graph;
    private String log = "";

    public FluxLightBuilder(Graph graph, AbstractList<LightNode> abstractList) {
        this.buildLights(graph, abstractList);
    }

    public FluxLightBuilder() {
        this.shaderBuilder = new FluxShaderBuilder(){

            protected void warning(String string) {
                FluxLightBuilder.this.warning(string);
            }
        };
    }

    private void log(String string) {
        this.log = this.log + "Log, " + string + "\n";
    }

    private void warning(String string) {
    }

    public void visit(PointLight pointLight) {
        if (pointLight instanceof PhysicalLight) {
            this.addLight(new FluxPhysicalLight((PhysicalLight)pointLight), (Light)pointLight);
        } else {
            this.addLight(new FluxPointLight(pointLight), (Light)pointLight);
        }
    }

    public void visit(SunSkyLight sunSkyLight) {
    }

    public void visit(Sky sky) {
        Shader shader = sky.getShader();
        FluxShader fluxShader = this.shaderBuilder.buildShader(shader);
        FluxSkyLight fluxSkyLight = new FluxSkyLight(sky, fluxShader);
        this.addLight(fluxSkyLight, (Light)sky);
        this.sky = fluxSkyLight;
    }

    public void visit(Parallelogram parallelogram) {
        this.addLight(new FluxParallelLight(parallelogram), (Light)parallelogram);
    }

    public void visit(AmbientLight ambientLight) {
    }

    public void visit(DirectionalLight directionalLight) {
        this.addLight(new FluxDirectionalLight(directionalLight), (Light)directionalLight);
    }

    private void addLight(FluxLight fluxLight, Light light) {
        fluxLight.setTransformation(this.currentTransformation);
        this.currentLight = fluxLight;
    }

    public int getSampleCount() {
        return this.lightSampleCount;
    }

    public void buildLight(Light light, Matrix4d matrix4d) {
        Matrix3f matrix3f = new Matrix3f();
        matrix4d.getRotationScale(matrix3f);
        if (!matrix3f.isOrthogonal()) {
            throw new UnsupportedOperationException("Light source transformation must be orthonormal.");
        }
        this.currentTransformation = matrix4d;
        FluxLight fluxLight = this.constructLight(light);
        if (fluxLight != null) {
            this.lights.add(fluxLight);
            this.lightSampleCount += fluxLight.getSampleCount();
        }
    }

    public FluxLight constructLight(Light light) {
        this.currentLight = null;
        if (light != null) {
            light.accept((LightVisitor)this);
        }
        return this.currentLight;
    }

    public float[] getCummulativePowerBuffer(Environment environment) {
        float[] fArray = new float[this.lights.size()];
        float f = 0.0f;
        for (int i = 0; i < this.lights.size(); ++i) {
            fArray[i] = f += (float)this.lights.get(i).getLight().getTotalPower(environment);
        }
        return fArray;
    }

    public void serializeCummulativePowerBuffer(ComputeByteBuffer computeByteBuffer, Environment environment) throws IOException {
        float[] fArray = this.getCummulativePowerBuffer(environment);
        for (int i = 0; i < fArray.length; ++i) {
            computeByteBuffer.writeFloat(fArray[i]);
        }
    }

    public void serialize(ComputeByteBuffer computeByteBuffer, ComputeByteBuffer computeByteBuffer2) throws IOException {
        this.shaderBuilder.serialize(computeByteBuffer, computeByteBuffer);
        for (FluxLight fluxLight : this.lights) {
            fluxLight.serialize(computeByteBuffer);
            computeByteBuffer2.writeInt(fluxLight.getOffset());
        }
    }

    public FluxLight getSky() {
        return this.sky;
    }

    public int getLightCount() {
        return this.lights.size();
    }

    public void visit(SpotLight spotLight) {
        this.addLight(new FluxSpotLight(spotLight), (Light)spotLight);
    }

    public void visit(Light light) {
        if (light instanceof SpectralLight) {
            SpectralLight spectralLight = (SpectralLight)light;
            FluxLight fluxLight = this.constructLight(spectralLight.getLight());
            this.addLight(new FluxSpectralLight(spectralLight, fluxLight), spectralLight);
        }
    }

    public void buildLights(Graph graph, AbstractList<LightNode> abstractList) {
        this.graph = graph;
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        TransformVisitor3D transformVisitor3D = new TransformVisitor3D();
        transformVisitor3D.init(GraphState.current((Graph)graph));
        for (LightNode lightNode : abstractList) {
            Light light = lightNode.getLight();
            Matrix4d matrix4d2 = transformVisitor3D.getGlobalTransformation((Node)lightNode);
            this.buildLight(light, matrix4d2);
        }
        this.log("Light count: " + this.getLightCount());
        this.log("Light sample count: " + this.getSampleCount());
    }

    public Vector<FluxLight> getLights() {
        return this.lights;
    }

    public Vector<FluxShader> getLightShaders() {
        return this.shaderBuilder.getShaders();
    }

    public Vector<FluxChannelMap> getLightChannels() {
        return this.shaderBuilder.getChannelBuilder().getChannels();
    }

    public void finnish(boolean bl, ViewConfig3D viewConfig3D) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        if ((bl && this.getSampleCount() == 0 || !bl && this.getLightCount() == 0) && viewConfig3D != null) {
            this.buildLight(viewConfig3D.getDefaultLight(matrix4d), matrix4d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransformVisitor3D
    extends Visitor3D {
        TransformVisitor3D() {
        }

        protected void init(GraphState graphState) {
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            this.init(graphState, graphState.getGraph().getTreePattern(), matrix4d);
        }

        protected void visitEnterImpl(Object object, boolean bl, Path path) {
        }

        protected void visitLeaveImpl(Object object, boolean bl, Path path) {
        }

        public Matrix4d getGlobalTransformation(Node node) {
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            if (node == null) {
                return matrix4d;
            }
            Stack<Node> stack = new Stack<Node>();
            while (node != null) {
                stack.push(node);
                node = node.getSource();
            }
            Node node2 = (Node)stack.pop();
            ArrayPath arrayPath = new ArrayPath(FluxLightBuilder.this.graph);
            return this.getGlobalTransformation(node2, stack, arrayPath);
        }

        private Matrix4d getGlobalTransformation(Node node, Stack<Node> stack, ArrayPath arrayPath) {
            Matrix4d matrix4d;
            arrayPath.pushNode((Object)node, node.getId() >= 0L ? node.getId() : (long)node.hashCode());
            this.visitEnter((Path)arrayPath, true);
            Instantiator instantiator = node.getInstantiator();
            if (instantiator != null) {
                boolean bl = true;
                this.state.beginInstancing((Object)node, arrayPath.getObjectId(-1));
                bl = instantiator.instantiate(arrayPath, (Visitor)this);
            }
            if (!stack.empty()) {
                Node node2 = stack.pop();
                arrayPath.pushEdgeSet((Object)node.getEdgeTo(node2), -1L, false);
                matrix4d = this.getGlobalTransformation(node2, stack, arrayPath);
                arrayPath.popEdgeSet();
            } else {
                matrix4d = (Matrix4d)this.getCurrentTransformation().clone();
            }
            instantiator = node.getInstantiator();
            if (instantiator != null) {
                this.state.endInstancing();
            }
            this.visitLeave(node, (Path)arrayPath, true);
            arrayPath.popNode();
            return matrix4d;
        }
    }
}

