/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.light;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.FluxObject;
import de.grogra.gpuflux.scene.shading.FluxSpectrum;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.spectral.RGBSpectralCurve;
import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.vecmath.Math2;
import java.io.IOException;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public abstract class FluxLight
extends FluxObject {
    protected static final int LIGHT_POINT = 0;
    protected static final int LIGHT_DIRECTIONAL = 1;
    protected static final int LIGHT_SPOT = 2;
    protected static final int LIGHT_AREA = 3;
    protected static final int LIGHT_PHYSICAL = 4;
    protected static final int LIGHT_SKY = 5;
    protected static final int LIGHT_SPECTRAL = 6;
    private Matrix4d transformation;
    protected Light light;

    public FluxLight(Light light) {
        this.light = light;
    }

    protected Matrix4d getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Matrix4d matrix4d) {
        this.transformation = (Matrix4d)matrix4d.clone();
    }

    protected void serializeLightBase(ComputeByteBuffer computeByteBuffer, int n, Tuple3f tuple3f, SpectralCurve spectralCurve) throws IOException {
        this.setOffset(computeByteBuffer.size());
        computeByteBuffer.writeInt(n);
        computeByteBuffer.writeInt(this.getSampleCount());
        Matrix4d matrix4d = this.getTransformation();
        Matrix3f matrix3f = new Matrix3f();
        matrix4d.getRotationScale(matrix3f);
        Vector3d vector3d = new Vector3d();
        matrix4d.get(vector3d);
        computeByteBuffer.write(matrix3f);
        computeByteBuffer.write((Tuple3d)vector3d);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.m33 = 1.0;
        Math2.invertAffine((Matrix4d)matrix4d, (Matrix4d)matrix4d2);
        matrix4d2.getRotationScale(matrix3f);
        matrix4d2.get(vector3d);
        computeByteBuffer.write(matrix3f);
        computeByteBuffer.write((Tuple3d)vector3d);
        computeByteBuffer.writeFloat(tuple3f.x);
        computeByteBuffer.writeFloat(tuple3f.y);
        computeByteBuffer.writeFloat(tuple3f.z);
        if (spectralCurve == null) {
            spectralCurve = new RGBSpectralCurve(tuple3f.x, tuple3f.y, tuple3f.z);
        }
        FluxSpectrum.serializeCorrectedCumulativeSPD(computeByteBuffer, spectralCurve);
    }

    public int getSampleCount() {
        return 1;
    }

    public Light getLight() {
        return this.light;
    }
}

