/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.BVH;

import de.grogra.gpuflux.scene.BVH.BVHBuilder;
import de.grogra.gpuflux.scene.BVH.BVHNode;
import de.grogra.gpuflux.scene.BVH.BVHTree;
import de.grogra.gpuflux.scene.volume.FluxVolume;
import de.grogra.gpuflux.utils.TaskMonitor;
import de.grogra.vecmath.BoundingBox3d;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedBVHBuilderSAH
implements BVHBuilder {
    private static final int WORK_PER_THREAD = 10000;
    private static final int TREE_WORK_PER_THREAD = 3000;
    private String log = "";
    private BVHPrimitive[] prims;
    private Integer[][] primIdx = new Integer[3][];
    private Integer[] tmpIdx;
    private BoundingBox3d[] sweepBBox;
    private TaskMonitor jobs;

    @Override
    public BVHTree construct(Vector<? extends FluxVolume> vector) {
        assert (vector != null);
        final int n = vector.size();
        this.log = "";
        this.prims = new BVHPrimitive[n];
        this.sweepBBox = new BoundingBox3d[n];
        this.primIdx[0] = new Integer[n];
        this.primIdx[1] = new Integer[n];
        this.primIdx[2] = new Integer[n];
        this.tmpIdx = new Integer[n];
        BoundingBox3d boundingBox3d = new BoundingBox3d();
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            this.prims[i] = new BVHPrimitive();
            this.prims[i].bb = vector.get(i).getBoundingBox();
            this.prims[i].bb.getCenter((Tuple3d)this.prims[i].centroid);
            boundingBox3d.extent(this.prims[i].bb);
            Integer n2 = new Integer(i);
            this.primIdx[2][i] = n2;
            this.primIdx[1][i] = n2;
            this.primIdx[0][i] = n2;
        }
        l = System.currentTimeMillis() - l;
        Runnable[] runnableArray = new Runnable[]{new Runnable(){

            public void run() {
                Arrays.sort(ThreadedBVHBuilderSAH.this.primIdx[0], 0, n, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        return (int)(((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).prims[n.intValue()].centroid.x - ((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).prims[n2.intValue()].centroid.x);
                    }
                });
            }
        }, new Runnable(){

            public void run() {
                Arrays.sort(ThreadedBVHBuilderSAH.this.primIdx[1], 0, n, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        return (int)(((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).prims[n.intValue()].centroid.y - ((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).prims[n2.intValue()].centroid.y);
                    }
                });
            }
        }, new Runnable(){

            public void run() {
                Arrays.sort(ThreadedBVHBuilderSAH.this.primIdx[2], 0, n, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        return (int)(((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).prims[n.intValue()].centroid.z - ((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).prims[n2.intValue()].centroid.z);
                    }
                });
            }
        }};
        ExecutorService executorService = Executors.newCachedThreadPool();
        long l2 = System.currentTimeMillis();
        executorService.execute(runnableArray[0]);
        executorService.execute(runnableArray[1]);
        executorService.execute(runnableArray[2]);
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        l2 = System.currentTimeMillis() - l2;
        long l3 = System.currentTimeMillis();
        ExecutorService executorService2 = Executors.newCachedThreadPool();
        BVHNode bVHNode = new BVHNode(-1, 0, n, boundingBox3d, null, null);
        SAHSplitJob sAHSplitJob = new SAHSplitJob(0, n, boundingBox3d, 0, this.primIdx, this.prims, bVHNode, executorService2);
        this.jobs = new TaskMonitor();
        this.jobs.startTask();
        executorService2.execute(sAHSplitJob);
        this.jobs.awaitTasks();
        executorService2.shutdown();
        l3 = System.currentTimeMillis() - l3;
        this.log = this.log + "        Compute BB time:        " + l + " ms\n";
        this.log = this.log + "        Sort Primitives Time:   " + l2 + " ms\n";
        this.log = this.log + "        Subdivide tree time:    " + l3 + " ms\n";
        return new BVHTree(bVHNode, boundingBox3d, this.primIdx[0]);
    }

    @Override
    public String getLog() {
        return this.log;
    }

    class SAHSplitJob
    implements Runnable {
        private int work = 0;
        private int fromIdx;
        private int toIdx;
        private BoundingBox3d bbox;
        private int depth;
        private Integer[][] primIdx;
        private BVHPrimitive[] prims;
        private BVHNode leaf;
        Executor executor;

        public SAHSplitJob(int n, int n2, BoundingBox3d boundingBox3d, int n3, Integer[][] integerArray, BVHPrimitive[] bVHPrimitiveArray, BVHNode bVHNode, Executor executor) {
            this.fromIdx = n;
            this.toIdx = n2;
            this.bbox = boundingBox3d;
            this.depth = n3;
            this.primIdx = integerArray;
            this.prims = bVHPrimitiveArray;
            this.leaf = bVHNode;
            this.executor = executor;
        }

        public void run() {
            BVHNode bVHNode = this.subdivide(this.fromIdx, this.toIdx, this.bbox, this.depth);
            this.leaf.set(bVHNode);
            ThreadedBVHBuilderSAH.this.jobs.finishTask();
        }

        private BVHNode subdivide(int n, int n2, BoundingBox3d boundingBox3d, int n3) {
            int n4;
            int n5;
            int n6;
            if (this.work > 10000 && n2 - n > 3000) {
                BVHNode bVHNode = new BVHNode(-1, n, n2 - n, boundingBox3d, null, null);
                SAHSplitJob sAHSplitJob = new SAHSplitJob(n, n2, boundingBox3d, n3, this.primIdx, this.prims, bVHNode, this.executor);
                ThreadedBVHBuilderSAH.this.jobs.startTask();
                this.executor.execute(sAHSplitJob);
                return bVHNode;
            }
            int n7 = n2 - n;
            double d = boundingBox3d.area();
            double d2 = n3 == 0 ? Double.MAX_VALUE : 10.0 * (double)(n2 - n);
            int n8 = -1;
            int n9 = -1;
            BoundingBox3d boundingBox3d2 = new BoundingBox3d();
            BoundingBox3d boundingBox3d3 = new BoundingBox3d();
            BoundingBox3d boundingBox3d4 = null;
            BoundingBox3d boundingBox3d5 = null;
            if (n3 < 63) {
                this.work += n2 - n;
                for (n6 = 0; n6 < 3; ++n6) {
                    boundingBox3d2.empty();
                    boundingBox3d3.empty();
                    for (n5 = n; n5 < n2 - 1; ++n5) {
                        n4 = this.primIdx[n6][n5];
                        boundingBox3d2.extent(this.prims[n4].bb);
                        ((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).sweepBBox[n5] = boundingBox3d2.clone();
                    }
                    for (n5 = n2 - 1; n5 > n; --n5) {
                        n4 = this.primIdx[n6][n5];
                        boundingBox3d3.extent(this.prims[n4].bb);
                        double d3 = ThreadedBVHBuilderSAH.this.sweepBBox[n5 - 1].area();
                        double d4 = boundingBox3d3.area();
                        double d5 = BVHTree.getSAH(d, d3, d4, n5 - n, n2 - n5);
                        if (!(d5 < d2)) continue;
                        d2 = d5;
                        n9 = n5;
                        n8 = n6;
                        boundingBox3d4 = ThreadedBVHBuilderSAH.this.sweepBBox[n5 - 1].clone();
                        boundingBox3d5 = boundingBox3d3.clone();
                    }
                }
            }
            if (n8 == -1) {
                return new BVHNode(-1, n, n7, boundingBox3d, null, null);
            }
            for (n6 = n; n6 < n2; ++n6) {
                n5 = n6 < n9 ? 1 : 0;
                n4 = this.primIdx[n8][n6];
                this.prims[n4].left = n5;
            }
            this.split((n8 + 1) % 3, n, n2, n9);
            this.split((n8 + 2) % 3, n, n2, n9);
            BVHNode bVHNode = this.subdivide(n, n9, boundingBox3d4, n3 + 1);
            BVHNode bVHNode2 = this.subdivide(n9, n2, boundingBox3d5, n3 + 1);
            return new BVHNode(n8, n, n7, boundingBox3d, bVHNode, bVHNode2);
        }

        private void split(int n, int n2, int n3, int n4) {
            int n5;
            int n6 = n2;
            int n7 = n4;
            for (n5 = n2; n5 < n3; ++n5) {
                Integer n8 = this.primIdx[n][n5];
                if (this.prims[n8.intValue()].left) {
                    ((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).tmpIdx[n6++] = n8;
                    continue;
                }
                ((ThreadedBVHBuilderSAH)ThreadedBVHBuilderSAH.this).tmpIdx[n7++] = n8;
            }
            for (n5 = n2; n5 < n3; ++n5) {
                this.primIdx[n][n5] = ThreadedBVHBuilderSAH.this.tmpIdx[n5];
            }
        }
    }

    private class BVHPrimitive {
        public BoundingBox3d bb = new BoundingBox3d();
        public Point3d centroid = new Point3d();
        public boolean left;

        private BVHPrimitive() {
        }
    }
}

