/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.BVH;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.BVH.BVHNode;
import de.grogra.vecmath.BoundingBox3d;
import java.io.IOException;
import javax.vecmath.Tuple3d;

public class BVHTree {
    public static final double TPRIM = 10.0;
    public static final float TAABB = 1.0f;
    public static final int MAX_DEPTH = 63;
    private BoundingBox3d bbox;
    private BVHNode root;
    private Integer[] primOrder;
    private int serializedNodes = 0;

    public BVHTree(BVHNode bVHNode, BoundingBox3d boundingBox3d, Integer[] integerArray) {
        this.root = bVHNode;
        this.bbox = boundingBox3d;
        this.primOrder = integerArray;
    }

    public BVHNode getRoot() {
        return this.root;
    }

    public BoundingBox3d getBounds() {
        return this.bbox;
    }

    public Integer[] getVolumeOrdering() {
        return this.primOrder;
    }

    public int getRootIdx() {
        return this.root.nidx == 0 ? -1 : this.root.nidx;
    }

    public void serializeBVH(ComputeByteBuffer computeByteBuffer, int n) throws IOException {
        assert (this.root != null);
        this.serializedNodes = 0;
        this.serializeBVH(computeByteBuffer, this.root, n);
    }

    private int serializeBVH(ComputeByteBuffer computeByteBuffer, BVHNode bVHNode, int n) throws IOException {
        if (!bVHNode.isLeaf()) {
            BVHNode bVHNode2 = bVHNode.left;
            BVHNode bVHNode3 = bVHNode.right;
            int n2 = this.serializeBVH(computeByteBuffer, bVHNode2, n);
            int n3 = this.serializeBVH(computeByteBuffer, bVHNode3, n);
            computeByteBuffer.writeFloat((float)bVHNode2.bb.getMin().x);
            computeByteBuffer.writeFloat((float)bVHNode2.bb.getMax().x);
            computeByteBuffer.writeFloat((float)bVHNode2.bb.getMin().y);
            computeByteBuffer.writeFloat((float)bVHNode2.bb.getMax().y);
            computeByteBuffer.writeFloat((float)bVHNode2.bb.getMin().z);
            computeByteBuffer.writeFloat((float)bVHNode2.bb.getMax().z);
            computeByteBuffer.writeFloat((float)bVHNode3.bb.getMin().z);
            computeByteBuffer.writeFloat((float)bVHNode3.bb.getMax().z);
            computeByteBuffer.writeFloat((float)bVHNode3.bb.getMin().x);
            computeByteBuffer.writeFloat((float)bVHNode3.bb.getMax().x);
            computeByteBuffer.writeFloat((float)bVHNode3.bb.getMin().y);
            computeByteBuffer.writeFloat((float)bVHNode3.bb.getMax().y);
            n2 = bVHNode2.isLeaf() ? -n2 - 1 : n2;
            n3 = bVHNode3.isLeaf() ? -n3 - 1 : n3;
            computeByteBuffer.writeInt(n2);
            computeByteBuffer.writeInt(n3);
            computeByteBuffer.writeInt(0);
            computeByteBuffer.writeInt(0);
        } else {
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeFloat(-1.0f);
            computeByteBuffer.writeInt(bVHNode.idx + n);
            computeByteBuffer.writeInt(bVHNode.pcount);
            computeByteBuffer.writeInt(0);
            computeByteBuffer.writeInt(0);
        }
        bVHNode.nidx = this.serializedNodes;
        return this.serializedNodes++;
    }

    public void serializeBIH(ComputeByteBuffer computeByteBuffer, int n) throws IOException {
        assert (this.root != null);
        this.serializedNodes = 0;
        this.serializeBIH(computeByteBuffer, this.root, n);
    }

    private int serializeBIH(ComputeByteBuffer computeByteBuffer, BVHNode bVHNode, int n) throws IOException {
        if (!bVHNode.isLeaf()) {
            BVHNode bVHNode2 = bVHNode.left;
            BVHNode bVHNode3 = bVHNode.right;
            int n2 = bVHNode.axis;
            float f = (float)this.getAxis(bVHNode2.bb.getMax(), n2);
            float f2 = (float)this.getAxis(bVHNode3.bb.getMin(), n2);
            int n3 = this.serializeBIH(computeByteBuffer, bVHNode2, n);
            int n4 = this.serializeBIH(computeByteBuffer, bVHNode3, n);
            n3 = bVHNode2.isLeaf() ? -n3 - 1 : n3;
            n4 = bVHNode3.isLeaf() ? -n4 - 1 : n4;
            computeByteBuffer.writeInt(n3 << 2 | n2);
            computeByteBuffer.writeInt(n4);
            computeByteBuffer.writeFloat(f);
            computeByteBuffer.writeFloat(f2);
        } else {
            computeByteBuffer.writeInt(-1);
            computeByteBuffer.writeInt(0);
            computeByteBuffer.writeInt(bVHNode.idx + n);
            computeByteBuffer.writeInt(bVHNode.pcount);
        }
        bVHNode.nidx = this.serializedNodes;
        return this.serializedNodes++;
    }

    public static double getSAH(double d, double d2, double d3, int n, int n2) {
        return 2.0 + (d2 * (double)n * 10.0 + d3 * (double)n2 * 10.0) / d;
    }

    public double computeSAH() {
        if (this.root != null) {
            return this.root.computeSAH(this.bbox.area());
        }
        return 0.0;
    }

    private double getAxis(Tuple3d tuple3d, int n) {
        if (n == 0) {
            return tuple3d.x;
        }
        if (n == 1) {
            return tuple3d.y;
        }
        if (n == 2) {
            return tuple3d.z;
        }
        return 0.0;
    }

    public void prune() {
        BVHNode.pruneEmptyNodes(this.root);
    }
}

