/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.geometry;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.util.arrays.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon {
    private List<float[]> vertices;

    public List<float[]> getVertices() {
        return this.vertices;
    }

    public void add(float[] fArray) {
        this.vertices.add(fArray);
    }

    public void add(float f, float f2, float f3) {
        this.add(new float[]{f, f2, f3});
    }

    public boolean contains(float[] fArray) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            float[] fArray2 = this.vertices.get(i);
            if (!ArrayUtils.equals(fArray2, fArray)) continue;
            return true;
        }
        return false;
    }

    public List<Polygon> getAsTriangles() {
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        if (this.vertices.size() == 3) {
            arrayList.add(this);
            return arrayList;
        }
        if (this.vertices.size() > 3) {
            float[] fArray = this.vertices.get(0);
            for (int i = 1; i < this.vertices.size() - 1; ++i) {
                Polygon polygon = new Polygon();
                float[] fArray2 = this.vertices.get(i);
                float[] fArray3 = this.vertices.get(i + 1);
                polygon.add(fArray);
                polygon.add(fArray2);
                polygon.add(fArray3);
                arrayList.add(polygon);
            }
            return arrayList;
        }
        return null;
    }

    public void print() {
        System.out.println("Number of vertices in polygon is " + this.vertices.size());
        for (int i = 0; i < this.vertices.size(); ++i) {
            System.out.println("  P" + i + ": " + this.vertices.get(i));
        }
    }

    public Polygon(List<float[]> list) {
        this.vertices = list;
    }

    public Polygon() {
        this(new ArrayList<float[]>());
    }
}

