/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.dxf;

import de.grogra.imp3d.View3D;
import de.grogra.imp3d.io.SceneGraphExport;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.SceneTreeWithShader;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;
import javax.vecmath.Matrix4d;

public class DXFExport
extends SceneGraphExport
implements FileWriterSource {
    public static final FilterSource.MetaDataKey<Float> FLATNESS = new FilterSource.MetaDataKey("flatness");
    PrintWriter out;
    final Stack matrixStack = new Stack();

    public DXFExport(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(filterItem.getOutputFlavor());
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        this.matrixStack.push(matrix4d);
    }

    protected void beginGroup(SceneTree.InnerNode innerNode) throws IOException {
        Matrix4d matrix4d = (Matrix4d)this.matrixStack.peek();
        Matrix4d matrix4d2 = new Matrix4d();
        innerNode.transform(matrix4d, matrix4d2);
        this.matrixStack.push(matrix4d2);
    }

    protected SceneTree createSceneTree(View3D view3D) {
        SceneTreeWithShader sceneTreeWithShader = new SceneTreeWithShader(view3D){

            protected boolean acceptLeaf(Object object, boolean bl) {
                return DXFExport.this.getExportFor(object, bl) != null;
            }

            protected SceneTreeWithShader.Leaf createLeaf(Object object, boolean bl, long l) {
                SceneTreeWithShader.Leaf leaf = new SceneTreeWithShader.Leaf(object, bl, l);
                this.init((SceneTree.Leaf)leaf);
                return leaf;
            }
        };
        sceneTreeWithShader.createTree(true);
        return sceneTreeWithShader;
    }

    protected void endGroup(SceneTree.InnerNode innerNode) throws IOException {
        this.matrixStack.pop();
    }

    public void write(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        this.out = new PrintWriter(bufferedWriter);
        this.out.println("0");
        this.out.println("SECTION");
        this.out.println("2");
        this.out.println("ENTITIES");
        this.write();
        this.out.println("0");
        this.out.println("ENDSEC");
        this.out.println("0");
        this.out.println("EOF");
        this.out.close();
        bufferedWriter.close();
        fileWriter.close();
    }

    public SceneGraphExport.NodeExport getExportFor(Object object, boolean bl) {
        Object object2 = this.getGraphState().getObjectDefault(object, bl, Attributes.SHAPE, null);
        if (object2 == null) {
            return null;
        }
        SceneGraphExport.NodeExport nodeExport = super.getExportFor(object2, bl);
        if (nodeExport != null) {
            return nodeExport;
        }
        return null;
    }
}

