/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.icon.Icon;
import de.grogra.icon.IconSource;
import de.grogra.math.ChannelData;
import de.grogra.math.ChannelMapVisitor;
import de.grogra.math.ColorMap;
import de.grogra.math.Tuple3fType;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XMLPersistenceReader;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.xl.util.ObjectList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class RGBColor
extends Color3f
implements ColorMap,
IconSource,
Icon,
Manageable,
Shareable {
    public static final RGBColor BLACK;
    public static final RGBColor BLUE;
    public static final RGBColor CYAN;
    public static final RGBColor DARK_GRAY;
    public static final RGBColor GRAY;
    public static final RGBColor GREEN;
    public static final RGBColor LIGHT_GRAY;
    public static final RGBColor MAGENTA;
    public static final RGBColor ORANGE;
    public static final RGBColor PINK;
    public static final RGBColor RED;
    public static final RGBColor YELLOW;
    public static final RGBColor WHITE;
    static final RGBColor[] STANDARD;
    public static final ManageableType $TYPE;
    private SharedObjectProvider sop;
    private final int index;
    private transient ObjectList refs = null;
    private transient Color awtColor;
    private transient int stamp = 0;

    public RGBColor(float f, float f2, float f3) {
        super(f, f2, f3);
        this.index = -1;
    }

    private RGBColor(int n, int n2) {
        super((float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f);
        this.index = n2;
    }

    public RGBColor() {
        this(0.5f, 0.5f, 0.5f);
    }

    public RGBColor(Tuple3f tuple3f) {
        this(tuple3f.x, tuple3f.y, tuple3f.z);
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public Object clone() {
        return this.index >= 0 ? this : new RGBColor((Tuple3f)this);
    }

    public boolean isPredefined() {
        return this.index >= 0;
    }

    public int getAverageColor() {
        return Tuple3fType.colorToInt((Tuple3f)this);
    }

    public void initProvider(SharedObjectProvider sharedObjectProvider) {
        if (this.index >= 0) {
            return;
        }
        if (this.sop != null) {
            throw new IllegalStateException();
        }
        this.sop = sharedObjectProvider;
    }

    public SharedObjectProvider getProvider() {
        return this.sop;
    }

    public synchronized void addReference(SharedObjectReference sharedObjectReference) {
        if (this.refs == null) {
            this.refs = new ObjectList(4, false);
        }
        this.refs.add((Object)sharedObjectReference);
    }

    public synchronized void removeReference(SharedObjectReference sharedObjectReference) {
        if (this.refs != null) {
            this.refs.remove((Object)sharedObjectReference);
        }
    }

    public synchronized void appendReferencesTo(List list) {
        if (this.refs != null) {
            list.addAll(this.refs);
        }
    }

    public float getFloatValue(ChannelData channelData, int n) {
        if (n >= 8 && n <= 14) {
            return 0.0f;
        }
        switch (n & 3) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return 1.0f;
            }
        }
        throw new AssertionError();
    }

    public Object getObjectValue(ChannelData channelData, int n) {
        return channelData.forwardGetObjectValue(channelData.getData(null));
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        ++this.stamp;
        if (transaction != null && this.sop != null) {
            transaction.fireSharedObjectModified((Shareable)this);
        }
    }

    public int getStamp() {
        return this.stamp;
    }

    public Manageable manageableReadResolve() {
        return this;
    }

    public Object manageableWriteReplace() {
        return this;
    }

    public Icon getIcon(Dimension dimension, int n) {
        return this;
    }

    public Dimension getPreferredIconSize(boolean bl) {
        return null;
    }

    public void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        int n6 = this.getAverageColor();
        if (this.awtColor == null || n6 != this.awtColor.getRGB()) {
            this.awtColor = new Color(n6, true);
        }
        graphics2D.setColor(this.awtColor);
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics2D.setColor(color);
    }

    public IconSource getIconSource() {
        return this;
    }

    public boolean isMutable() {
        return this.index < 0;
    }

    public void prepareIcon() {
    }

    public Image getImage() {
        return null;
    }

    public Image getImage(int n, int n2) {
        return null;
    }

    public URL getImageSource() {
        return null;
    }

    public Rectangle getIconBounds() {
        return null;
    }

    public void accept(ChannelMapVisitor channelMapVisitor) {
        channelMapVisitor.visit(this);
    }

    static {
        int n;
        $TYPE = new ManageableType((Type)ClassAdapter.wrap(RGBColor.class), (ManageableType)Tuple3fType.$TYPE, true){

            protected Object readObject(PersistenceInput persistenceInput, Object object, boolean bl) throws IOException {
                String string;
                boolean bl2 = persistenceInput instanceof XMLPersistenceReader ? ("true".equals(string = ((XMLPersistenceReader)persistenceInput).peekName()) || "false".equals(string)) && persistenceInput.readBoolean() : persistenceInput.readBoolean();
                return bl2 ? STANDARD[persistenceInput.readByte() % STANDARD.length] : super.readObject(persistenceInput, !(object instanceof RGBColor) || ((RGBColor)object).index >= 0 ? new RGBColor() : object, bl);
            }

            protected void write(Object object, PersistenceOutput persistenceOutput, boolean bl) throws IOException {
                RGBColor rGBColor = (RGBColor)object;
                if (rGBColor.index >= 0) {
                    persistenceOutput.writeBoolean(true);
                    persistenceOutput.writeByte(rGBColor.index);
                } else {
                    persistenceOutput.writeBoolean(false);
                    super.write(object, persistenceOutput, bl);
                }
            }

            public Object getRepresentative() {
                return null;
            }

            public Object newInstance() {
                return new RGBColor();
            }
        }.validate();
        Color[] colorArray = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW, Color.WHITE};
        STANDARD = new RGBColor[colorArray.length];
        for (n = 0; n < colorArray.length; ++n) {
            RGBColor.STANDARD[n] = new RGBColor(colorArray[n].getRGB(), n);
        }
        n = -1;
        BLACK = STANDARD[++n];
        BLUE = STANDARD[++n];
        CYAN = STANDARD[++n];
        DARK_GRAY = STANDARD[++n];
        GRAY = STANDARD[++n];
        GREEN = STANDARD[++n];
        LIGHT_GRAY = STANDARD[++n];
        MAGENTA = STANDARD[++n];
        ORANGE = STANDARD[++n];
        PINK = STANDARD[++n];
        RED = STANDARD[++n];
        YELLOW = STANDARD[++n];
        WHITE = STANDARD[++n];
        assert (n + 1 == colorArray.length);
    }
}

