/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.Cache;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineSurface;
import de.grogra.math.Pool;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.ClassAdapter;

public class IsoCurve
extends ContextDependentBase
implements BSplineCurve {
    BSplineSurface surface;
    float parameter = 0.5f;
    boolean direction;
    public static final Type $TYPE = new Type(IsoCurve.class);
    public static final SCOType.Field surface$FIELD = Type._addManagedField($TYPE, "surface", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(BSplineSurface.class), null, 0);
    public static final SCOType.Field parameter$FIELD = Type._addManagedField($TYPE, "parameter", 0x200000, de.grogra.reflect.Type.FLOAT, null, 1);
    public static final SCOType.Field direction$FIELD = Type._addManagedField($TYPE, "direction", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 2);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isDirection() {
        return this.direction;
    }

    public void setDirection(boolean bl) {
        this.direction = bl;
    }

    public float getParameter() {
        return this.parameter;
    }

    public void setParameter(float f) {
        this.parameter = f;
    }

    public BSplineSurface getSurface() {
        return this.surface;
    }

    public void setSurface(BSplineSurface bSplineSurface) {
        surface$FIELD.setObject((Object)this, (Object)bSplineSurface);
    }

    public IsoCurve() {
    }

    public IsoCurve(BSplineSurface bSplineSurface) {
        this();
        this.surface = bSplineSurface;
    }

    public boolean dependsOnContext() {
        return this.surface.dependsOnContext();
    }

    public void writeStamp(Cache.Entry entry, GraphState graphState) {
        super.writeStamp(entry, graphState);
        this.surface.writeStamp(entry, graphState);
    }

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        int n2 = (this.direction ? this.surface.getVSize(graphState) : this.surface.getUSize(graphState)) - 1;
        int n3 = this.direction ? this.surface.getVDegree(graphState) : this.surface.getUDegree(graphState);
        float f = this.surface.getKnot(this.direction ? 1 : 0, 0, graphState);
        float f2 = this.surface.getKnot(this.direction ? 1 : 0, n2 + n3, graphState);
        float f3 = this.parameter * (f2 - f) + f;
        int n4 = BSpline.findSpan(n2, n3, f3, this.surface, this.direction ? 1 : 0, graphState);
        n2 = Math.min(fArray.length, this.surface.getDimension(graphState));
        for (int i = n2 - 1; i >= 0; --i) {
            fArray[i] = 0.0f;
        }
        Pool pool = Pool.push(graphState);
        float[] fArray2 = pool.getFloatArray(0, n3 + 1);
        float[] fArray3 = pool.getFloatArray(2, Math.max(n2, n3 + 1));
        float[] fArray4 = pool.getFloatArray(3, n3 + 1);
        BSpline.calculateBasisFunctions(fArray2, n3, this.surface, this.direction ? 1 : 0, n4, f3, graphState, fArray3, fArray4);
        n4 -= n3;
        while (n3 >= 0) {
            float f4 = fArray2[n3];
            this.surface.getVertex(fArray3, this.surface.getVertexIndex(this.direction ? n : n4 + n3, this.direction ? n4 + n3 : n, graphState), graphState);
            for (int i = n2 - 1; i >= 0; --i) {
                int n5 = i;
                fArray[n5] = fArray[n5] + f4 * fArray3[i];
            }
            --n3;
        }
        pool.pop(graphState);
        return n2;
    }

    public int getSize(GraphState graphState) {
        return this.direction ? this.surface.getUSize(graphState) : this.surface.getVSize(graphState);
    }

    public int getDegree(GraphState graphState) {
        return this.direction ? this.surface.getUDegree(graphState) : this.surface.getVDegree(graphState);
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        return this.surface.getKnot(this.direction ? 0 : 1, n2, graphState);
    }

    public boolean isRational(GraphState graphState) {
        return this.surface.isRational(graphState);
    }

    public int getDimension(GraphState graphState) {
        return this.surface.getDimension(graphState);
    }

    static {
        parameter$FIELD.setMinValue((Number)new Float(0.0f));
        parameter$FIELD.setMaxValue((Number)new Float(1.0f));
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 3;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(IsoCurve isoCurve, SCOType sCOType) {
            super((Object)isoCurve, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 2: {
                    ((IsoCurve)object).direction = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((IsoCurve)object).isDirection();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 1: {
                    ((IsoCurve)object).parameter = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((IsoCurve)object).getParameter();
                }
            }
            return super.getFloat(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((IsoCurve)object).surface = (BSplineSurface)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((IsoCurve)object).getSurface();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new IsoCurve();
        }
    }
}

