/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.math.Transform3D;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.reflect.ClassAdapter;
import de.grogra.vecmath.Math2;
import de.grogra.xl.lang.ConversionConstructor;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ComponentTransform
extends ShareableBase
implements Transform3D {
    Vector3d translation;
    Vector3d rotation;
    Vector3d scale;
    Vector3d shear;
    Matrix4d tmp1 = new Matrix4d();
    Matrix4d tmp2 = new Matrix4d();
    public static final Type $TYPE = new Type(ComponentTransform.class);
    public static final SCOType.Field translation$FIELD = Type._addManagedField($TYPE, "translation", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(Vector3d.class), null, 0);
    public static final SCOType.Field rotation$FIELD = Type._addManagedField($TYPE, "rotation", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(Vector3d.class), null, 1);
    public static final SCOType.Field scale$FIELD = Type._addManagedField($TYPE, "scale", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(Vector3d.class), null, 2);
    public static final SCOType.Field shear$FIELD = Type._addManagedField($TYPE, "shear", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(Vector3d.class), null, 3);

    public ComponentTransform() {
        this.translation = new Vector3d(0.0, 0.0, 0.0);
        this.rotation = new Vector3d(0.0, 0.0, 0.0);
        this.scale = new Vector3d(1.0, 1.0, 1.0);
        this.shear = new Vector3d(0.0, 0.0, 0.0);
    }

    @ConversionConstructor
    public ComponentTransform(Tuple3d tuple3d) {
        this();
        this.translation.set(tuple3d);
    }

    @ConversionConstructor
    public ComponentTransform(Matrix3d matrix3d) {
        this.setRotationScaleShear(matrix3d);
    }

    @ConversionConstructor
    public ComponentTransform(Matrix4d matrix4d) {
        this();
        Matrix3d matrix3d = new Matrix3d();
        Vector3d vector3d = new Vector3d();
        matrix4d.get(vector3d);
        matrix4d.getRotationScale(matrix3d);
        this.translation.set((Tuple3d)vector3d);
        this.setRotationScaleShear(matrix3d);
    }

    private void setRotationScaleShear(Matrix3d matrix3d) {
        Matrix3d matrix3d2 = new Matrix3d(matrix3d);
        Matrix3d matrix3d3 = new Matrix3d();
        Math2.decomposeQR((Matrix3d)matrix3d2, (Matrix3d)matrix3d3);
        this.rotation.y = -Math.asin(matrix3d3.m20);
        this.rotation.x = Math.atan2(matrix3d3.m21, matrix3d3.m22);
        this.rotation.z = Math.atan2(matrix3d3.m10, matrix3d3.m00);
        this.scale.set(matrix3d2.m00, matrix3d2.m11, matrix3d2.m22);
        this.shear.set(matrix3d2.m01 / matrix3d2.m00, matrix3d2.m02 / matrix3d2.m00, matrix3d2.m12 / matrix3d2.m11);
    }

    public void transform(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.tmp1.setIdentity();
        this.tmp1.setTranslation(this.translation);
        this.tmp2.setIdentity();
        this.tmp2.rotZ(this.rotation.z);
        this.tmp1.mul(this.tmp2);
        this.tmp2.rotY(this.rotation.y);
        this.tmp1.mul(this.tmp2);
        this.tmp2.rotX(this.rotation.x);
        this.tmp1.mul(this.tmp2);
        this.tmp2.setIdentity();
        this.tmp2.setElement(0, 0, this.scale.x);
        this.tmp2.setElement(1, 1, this.scale.y);
        this.tmp2.setElement(2, 2, this.scale.z);
        this.tmp1.mul(this.tmp2);
        this.tmp2.setIdentity();
        this.tmp2.m01 = this.shear.x;
        this.tmp2.m02 = this.shear.y;
        this.tmp2.m12 = this.shear.z;
        this.tmp1.mul(this.tmp2);
        Math2.mulAffine((Matrix4d)matrix4d2, (Matrix4d)matrix4d, (Matrix4d)this.tmp1);
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public Vector3d getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector3d vector3d) {
        translation$FIELD.setObject((Object)this, (Object)vector3d);
    }

    public Vector3d getRotation() {
        return this.rotation;
    }

    public void setRotation(Vector3d vector3d) {
        rotation$FIELD.setObject((Object)this, (Object)vector3d);
    }

    public Vector3d getScale() {
        return this.scale;
    }

    public void setScale(Vector3d vector3d) {
        scale$FIELD.setObject((Object)this, (Object)vector3d);
    }

    public Vector3d getShear() {
        return this.shear;
    }

    public void setShear(Vector3d vector3d) {
        shear$FIELD.setObject((Object)this, (Object)vector3d);
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(ComponentTransform componentTransform, SCOType sCOType) {
            super((Object)componentTransform, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((ComponentTransform)object).translation = (Vector3d)object2;
                    return;
                }
                case 1: {
                    ((ComponentTransform)object).rotation = (Vector3d)object2;
                    return;
                }
                case 2: {
                    ((ComponentTransform)object).scale = (Vector3d)object2;
                    return;
                }
                case 3: {
                    ((ComponentTransform)object).shear = (Vector3d)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((ComponentTransform)object).getTranslation();
                }
                case 1: {
                    return ((ComponentTransform)object).getRotation();
                }
                case 2: {
                    return ((ComponentTransform)object).getScale();
                }
                case 3: {
                    return ((ComponentTransform)object).getShear();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new ComponentTransform();
        }
    }
}

