/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.Pool;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.XClass;
import de.grogra.reflect.XData;
import de.grogra.reflect.XObject;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;

public abstract class Circular
extends ContextDependentBase
implements BSplineCurve,
XObject {
    int plane;
    boolean reverse;
    float intermediateArcs = 1.0f;
    boolean startingAtCenter = true;
    public static final Type $TYPE = new Type(Circular.class);
    public static final SCOType.Field plane$FIELD = Type._addManagedField($TYPE, "plane", 0x200000, (de.grogra.reflect.Type)BSpline.SPLINE_PLANE_TYPE, null, 0);
    public static final SCOType.Field reverse$FIELD = Type._addManagedField($TYPE, "reverse", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 1);
    public static final SCOType.Field intermediateArcs$FIELD = Type._addManagedField($TYPE, "intermediateArcs", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field startingAtCenter$FIELD = Type._addManagedField($TYPE, "startingAtCenter", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);
    private transient XClass cls;
    private transient XData data;

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public boolean isStartingAtCenter() {
        return this.startingAtCenter;
    }

    public void setStartingAtCenter(boolean bl) {
        this.startingAtCenter = bl;
    }

    public int getPlane() {
        return this.plane;
    }

    public void setPlane(int n) {
        this.plane = n;
    }

    public float getIntermediateArcs() {
        return this.intermediateArcs;
    }

    public void setIntermediateArcs(float f) {
        this.intermediateArcs = f;
    }

    public boolean dependsOnContext() {
        return false;
    }

    public boolean isRational(GraphState graphState) {
        return true;
    }

    public int getDegree(GraphState graphState) {
        return 2;
    }

    protected abstract int getArcCount();

    public int getSize(GraphState graphState) {
        return 2 * this.getArcCount() + 1;
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        if (n2 < 3) {
            return 0.0f;
        }
        int n3 = this.getArcCount();
        return n2 > 2 * n3 ? 1.0f : (float)(n2 - 1 >> 1) / (float)n3;
    }

    protected abstract float[] calculateCache(GraphState var1);

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        float[] fArray2 = (float[])graphState.getObjectContext().getValue((Object)this);
        if (fArray2 == null) {
            fArray2 = this.calculateCache(graphState);
            graphState.getObjectContext().setValue((Object)this, (Object)fArray2);
        }
        if (this.getDimension(graphState) == 4) {
            return BSpline.set(fArray, fArray2[n *= 4], fArray2[n + 1], fArray2[n + 2], fArray2[n + 3]);
        }
        return BSpline.set(fArray, fArray2[n *= 3], fArray2[n + 1], fArray2[n + 2]);
    }

    float[] calculateCache(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, GraphState graphState) {
        int n2 = this.getDimension(null);
        float[] fArray = new float[(2 * n + 1) * n2];
        float f8 = (f3 - f2) / (float)n;
        float f9 = (f5 - f4) / (float)n;
        float f10 = (f7 - f6) / (float)n;
        float f11 = f / (float)n;
        float f12 = (float)Math.cos(0.5 * (double)f8);
        Pool pool = Pool.push(graphState);
        Matrix3f matrix3f = pool.m3f0;
        Point2f point2f = pool.p2f0;
        int n3 = 0;
        float f13 = this.reverse ? -1.0f : 1.0f;
        switch (n2 < 4 ? 0 : this.plane) {
            case 0: {
                int n4 = 0;
                int n5 = 1;
                int n6 = 2;
                break;
            }
            case 1: {
                int n4 = 0;
                int n5 = 2;
                int n6 = 1;
                break;
            }
            default: {
                int n4 = 1;
                int n5 = 2;
                int n6 = 0;
            }
        }
        float f14 = 0.0f;
        float f15 = 0.0f;
        int n7 = 0;
        while (true) {
            float f16 = f2 + f8 * (float)n7;
            float f17 = f4 + f9 * (float)n7;
            float f18 = f6 + f10 * (float)n7;
            float f19 = f11 * (float)n7;
            float f20 = (float)Math.cos(f16);
            float f21 = f13 * (float)Math.sin(f16);
            float f22 = (float)Math.cos(f16 + f8);
            float f23 = f13 * (float)Math.sin(f16 + f8);
            float f24 = f17 * f20;
            float f25 = f18 * f21;
            float f26 = (f17 + f9) * f22;
            float f27 = (f18 + f10) * f23;
            if (n7 == 0 && !this.startingAtCenter) {
                f14 = -f24;
                f15 = -f25;
            }
            fArray[n3 + n4] = f24 + f14;
            fArray[n3 + n5] = f25 + f15;
            fArray[n3 + n6] = f19;
            fArray[(n3 += n2) - 1] = 1.0f;
            if (n7 == n) break;
            matrix3f.m00 = -f21 * f17 + f20 * f9 / f8;
            matrix3f.m10 = f20 * f18 + f21 * f10 / f8;
            matrix3f.m01 = -f23 * (f17 + f9) + f22 * f9 / f8;
            matrix3f.m11 = f22 * (f18 + f10) + f23 * f10 / f8;
            matrix3f.m02 = f24 - f26;
            matrix3f.m12 = f25 - f27;
            point2f.set(0.0f, 0.0f);
            Math2.invTransformPoint((Matrix3f)matrix3f, (Tuple2f)point2f);
            fArray[n3 + n4] = f12 * (f24 + f14 + matrix3f.m00 * point2f.x);
            fArray[n3 + n5] = f12 * (f25 + f15 + matrix3f.m10 * point2f.x);
            fArray[n3 + n6] = f12 * (f19 + 0.5f * f11);
            fArray[(n3 += n2) - 1] = f12;
            ++n7;
        }
        pool.pop(graphState);
        return fArray;
    }

    public final void initXClass(XClass xClass) {
        if (this.cls != null) {
            throw new IllegalStateException();
        }
        this.cls = xClass;
        this.data = new XData();
        this.data.init(xClass);
    }

    public final XClass getXClass() {
        return this.cls;
    }

    public final XData getXData() {
        return this.data;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(Circular circular, SCOType sCOType) {
            super((Object)circular, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 1: {
                    ((Circular)object).reverse = bl;
                    return;
                }
                case 3: {
                    ((Circular)object).startingAtCenter = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((Circular)object).isReverse();
                }
                case 3: {
                    return ((Circular)object).isStartingAtCenter();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 0: {
                    ((Circular)object).plane = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((Circular)object).getPlane();
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((Circular)object).intermediateArcs = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((Circular)object).getIntermediateArcs();
                }
            }
            return super.getFloat(object, n);
        }
    }
}

