/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.Cache;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.VertexList;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.ClassAdapter;

public class BSplineOfVertices
extends ContextDependentBase
implements BSplineCurve {
    VertexList vertices;
    int degree = 3;
    boolean periodic;
    boolean rational;
    boolean bezier;
    int size = -1;
    float[] knots = null;
    public static final Type $TYPE = new Type(BSplineOfVertices.class);
    public static final SCOType.Field vertices$FIELD = Type._addManagedField($TYPE, "vertices", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(VertexList.class), null, 0);
    public static final SCOType.Field degree$FIELD = Type._addManagedField($TYPE, "degree", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field periodic$FIELD = Type._addManagedField($TYPE, "periodic", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 2);
    public static final SCOType.Field rational$FIELD = Type._addManagedField($TYPE, "rational", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);
    public static final SCOType.Field bezier$FIELD = Type._addManagedField($TYPE, "bezier", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 4);
    public static final SCOType.Field size$FIELD = Type._addManagedField($TYPE, "size", 0x200000, de.grogra.reflect.Type.INT, null, 5);
    public static final SCOType.Field knots$FIELD = Type._addManagedField($TYPE, "knots", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(float[].class), null, 6);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setPeriodic(boolean bl) {
        this.periodic = bl;
    }

    public boolean isRational() {
        return this.rational;
    }

    public void setRational(boolean bl) {
        this.rational = bl;
    }

    public boolean isBezier() {
        return this.bezier;
    }

    public void setBezier(boolean bl) {
        this.bezier = bl;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public VertexList getVertices() {
        return this.vertices;
    }

    public void setVertices(VertexList vertexList) {
        vertices$FIELD.setObject((Object)this, (Object)vertexList);
    }

    public float[] getKnots() {
        return this.knots;
    }

    public void setKnots(float[] fArray) {
        knots$FIELD.setObject((Object)this, (Object)fArray);
    }

    public BSplineOfVertices() {
    }

    public BSplineOfVertices(VertexList vertexList, int n, boolean bl, boolean bl2) {
        this();
        this.vertices = vertexList;
        this.degree = n;
        this.periodic = bl;
        this.bezier = bl2;
    }

    public boolean dependsOnContext() {
        return this.vertices.dependsOnContext();
    }

    public void writeStamp(Cache.Entry entry, GraphState graphState) {
        super.writeStamp(entry, graphState);
        this.vertices.writeStamp(entry, graphState);
    }

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        int n2 = this.vertices.getSize(graphState);
        return this.vertices.getVertex(fArray, n < n2 ? n : n - n2, graphState);
    }

    public int getSize(GraphState graphState) {
        int n;
        int n2 = n = this.size > 0 ? this.size : this.vertices.getSize(graphState);
        return n < 2 ? 0 : (this.periodic ? n + this.degree : n);
    }

    public int getDegree(GraphState graphState) {
        return Math.min(this.degree, this.getSize(graphState) - 1);
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        return this.knots != null ? this.knots[n2] : BSpline.getDefaultKnot(this.getSize(graphState), this.getDegree(graphState), this.periodic, this.bezier, n2);
    }

    public boolean isRational(GraphState graphState) {
        return this.rational;
    }

    public int getDimension(GraphState graphState) {
        return this.vertices.getDimension(graphState);
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 7;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(BSplineOfVertices bSplineOfVertices, SCOType sCOType) {
            super((Object)bSplineOfVertices, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 2: {
                    ((BSplineOfVertices)object).periodic = bl;
                    return;
                }
                case 3: {
                    ((BSplineOfVertices)object).rational = bl;
                    return;
                }
                case 4: {
                    ((BSplineOfVertices)object).bezier = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((BSplineOfVertices)object).isPeriodic();
                }
                case 3: {
                    return ((BSplineOfVertices)object).isRational();
                }
                case 4: {
                    return ((BSplineOfVertices)object).isBezier();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((BSplineOfVertices)object).degree = n2;
                    return;
                }
                case 5: {
                    ((BSplineOfVertices)object).size = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((BSplineOfVertices)object).getDegree();
                }
                case 5: {
                    return ((BSplineOfVertices)object).getSize();
                }
            }
            return super.getInt(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((BSplineOfVertices)object).vertices = (VertexList)object2;
                    return;
                }
                case 6: {
                    ((BSplineOfVertices)object).knots = (float[])object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((BSplineOfVertices)object).getVertices();
                }
                case 6: {
                    return ((BSplineOfVertices)object).getKnots();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new BSplineOfVertices();
        }
    }
}

