/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.blocks.xFrogFileParser;

import de.grogra.blocks.Horn;
import de.grogra.blocks.Hydra;
import de.grogra.blocks.PhiBall;
import de.grogra.blocks.Tree;
import de.grogra.blocks.xFrogFileParser.Expr;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.vecmath.Tuple3f;

public class File
extends Expr {
    private Node root = null;
    private StringBuffer xl = null;

    public File(Expr expr) {
        this.a = expr;
        this.xl = new StringBuffer(this.toXL());
        this.root = null;
        this.toGraph();
    }

    private String parseChildrenTree(String string, String string2, int n) {
        String string3 = (String)children.get(string);
        if (string3 == null) {
            return this.setAktLayer((String)blocks.get(string), n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        int n2 = Integer.parseInt((String)stringTokenizer.nextElement());
        if (string.equals("\"Root\"")) {
            string = "";
        }
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = "";
            String string5 = (String)stringTokenizer.nextElement();
            ++n3;
            if (string.length() != 0) {
                String string6 = ((String)blocks.get(string)).substring(0, 2);
                if (string6.equals("Ho")) {
                    string4 = this.isRib(string, string5) ? "-MULTIPLY->" : "-CHILD->";
                }
                if (string6.equals("Tr")) {
                    string4 = this.isBranch(string, string5) ? "-MULTIPLY->" : "-CHILD->";
                }
                if (string6.equals("Ph") || string6.equals("Hy")) {
                    string4 = "-MULTIPLY->";
                }
            }
            if (n2 > 1) {
                if (n3 > 1) {
                    string2 = string2 + "\n\t\t[" + string4 + " " + this.parseChildrenTree(string5, string2, n) + "]\n\t\t";
                    continue;
                }
                string2 = (string.length() != 0 ? this.setAktLayer((String)blocks.get(string), n) : "") + "[" + string4 + "\n\t\t" + this.parseChildrenTree(string5, string2, n) + "]";
                continue;
            }
            string2 = (string.length() != 0 ? this.setAktLayer((String)blocks.get(string), n) : "") + " " + string4 + "\n\t\t " + this.parseChildrenTree(string5, string2, ++n);
        }
        return string2;
    }

    private String setAktLayer(String string, int n) {
        return string.substring(0, string.indexOf(".(")) + ".(setLayer(" + n + "), " + string.substring(string.indexOf(".(") + 2, string.length());
    }

    private String toXL() {
        String string = "";
        String string2 = "\t\t";
        imports.add("import static de.grogra.blocks.BlockConst.*;");
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            string = string + (String)iterator.next() + "\n";
        }
        string = string + "\n";
        iterator = textureImports.iterator();
        while (iterator.hasNext()) {
            string = string + (String)iterator.next() + "\n";
        }
        String string3 = "\t{\n";
        iterator = transformMatrizen.iterator();
        while (iterator.hasNext()) {
            string3 = string3 + "\t" + (String)iterator.next() + "\n";
        }
        iterator = trajectory.iterator();
        while (iterator.hasNext()) {
            string3 = string3 + (String)iterator.next() + "\n";
        }
        if (lightsXL.size() != 0) {
            Enumeration<Object> enumeration = lightsXL.elements();
            while (enumeration.hasMoreElements()) {
                string3 = string3 + (String)enumeration.nextElement() + "\n";
            }
            enumeration = lightsXL.keys();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + "[" + (String)enumeration.nextElement() + "] ";
            }
        }
        string3 = string3 + "\t}\n\n";
        return string + "\n" + "protected void init() {\n" + "\tfor (apply()) init2 ();\n" + "}\n\n" + "public void init2() [\n" + (string3.length() > 10 ? string3 : "") + "\tAxiom ==> " + sky + string2 + this.parseChildrenTree("\"Root\"", "", 0) + ";\n" + "]" + "\n\n";
    }

    private void parseChildrenTreeG(String string, Node node, int n) {
        String string2 = (String)children.get(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n2 = Integer.parseInt((String)stringTokenizer.nextElement());
        if (string.equals("\"Root\"")) {
            string = "";
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            Node node2;
            int n3 = 512;
            if (n2 == 1) {
                n3 = 256;
            }
            if ((node2 = (Node)blocksGraphNodes.get(string3 = (String)stringTokenizer.nextElement())) == null) {
                return;
            }
            node2.setLayer(n + 1);
            if (string.length() != 0) {
                Node node3 = (Node)blocksGraphNodes.get(string);
                if (node3 instanceof Horn) {
                    n3 = this.isRib(node, node2) ? 131072 : 262144;
                }
                if (node3 instanceof Tree) {
                    n3 = this.isBranch(node, node2) ? 131072 : 262144;
                }
                if (node3 instanceof Hydra) {
                    n3 = 131072;
                }
                if (node3 instanceof PhiBall) {
                    n3 = 131072;
                }
            }
            node.addEdgeBitsTo(node2, n3, null);
            this.parseChildrenTreeG(string3, node2, node.getLayer());
        }
    }

    private boolean isBranch(String string, String string2) {
        if (!branches.containsKey(string)) {
            return false;
        }
        String string3 = (String)branches.get(string);
        return string3.contains(string2);
    }

    private boolean isBranch(Node node, Node node2) {
        if (!branches.containsKey(node.getName())) {
            return false;
        }
        String string = (String)branches.get(node.getName());
        return string.contains(node2.getName());
    }

    private boolean isRib(String string, String string2) {
        if (!ribs.containsKey(string)) {
            return false;
        }
        String string3 = (String)ribs.get(string);
        return string3.contains(string2);
    }

    private boolean isRib(Node node, Node node2) {
        if (!ribs.containsKey(node.getName())) {
            return false;
        }
        String string = (String)ribs.get(node.getName());
        return string.contains(node2.getName());
    }

    private void toGraph() {
        this.root = new Node();
        this.parseChildrenTreeG("\"Root\"", this.root, this.root.getLayer());
        this.addLightsToRoot();
        int n = 0;
        Node node = null;
        for (Edge edge = this.root.getFirstEdge(); edge != null; edge = edge.getNext(this.root)) {
            ++n;
            node = edge.getTarget();
        }
        if (n == 1) {
            this.root.removeAll(null);
            this.root = node;
        }
    }

    private void addLightsToRoot() {
        Enumeration enumeration = lightsGraphNodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            this.root.addEdgeBitsTo(node, 256, null);
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public Vector getTextures() {
        return textures;
    }

    public Tuple3f getCameraParams() {
        return camera;
    }

    public StringBuffer getXl() {
        return this.xl;
    }

    public String toString() {
        return this.a.toString() + "\n";
    }
}

