/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.Annotation;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AnnotationFormatError;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.IncompleteAnnotationException;

public class AnnotationImpl
implements InvocationHandler,
Annotation {
    private final Class<? extends Annotation> annotationType_;
    private final Map<String, Object> attributes;
    private static final Method cloneMethod;

    public static Annotation createAnnotation(Class<? extends Annotation> clazz, Map<String, Object> map) {
        try {
            return (Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{Annotation.class, clazz}, (InvocationHandler)new AnnotationImpl(clazz, map));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnnotationFormatError("Unexpected exception while trying to create an annotation of type: " + clazz, illegalArgumentException);
        }
    }

    private AnnotationImpl(Class<? extends Annotation> clazz, Map<String, Object> map) {
        this.attributes = new HashMap<String, Object>(map);
        this.annotationType_ = clazz;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getDeclaringClass().equals(this.annotationType_)) {
            String string = method.getName();
            if (this.attributes.containsKey(string)) {
                Object object2 = this.attributes.get(string);
                if (object2 == null) {
                    return null;
                }
                if (object2.getClass().isArray()) {
                    object2 = cloneMethod.invoke(object2, new Object[0]);
                }
                return object2;
            }
            throw new IncompleteAnnotationException(this.annotationType_, string);
        }
        return method.invoke((Object)this, objectArray);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType_;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AnnotationImpl && ((AnnotationImpl)object).annotationType_ == this.annotationType_;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@').append(this.annotationType_.getName()).append('(');
        boolean bl = true;
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append('=');
            Object object = entry.getValue();
            if (object.getClass().isArray()) {
                stringBuilder.append(Arrays.deepToString((Object[])object));
                continue;
            }
            stringBuilder.append(object);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    static {
        try {
            cloneMethod = Object.class.getDeclaredMethod("clone", new Class[0]);
            cloneMethod.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException.getMessage());
        }
    }
}

