/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.ConversionConstructor;

public final class Variant {
    private static final int NULL = 1;
    private static final int STRING = 2;
    private static final int BOOLEAN = 4;
    private static final int INT = 8;
    private static final int LONG = 16;
    private static final int FLOAT = 32;
    private static final int DOUBLE = 64;
    private final String svalue;
    private final Number nvalue;
    private final boolean bvalue;
    private final int type;

    private Variant(String string, boolean bl) {
        this.svalue = string;
        if (string != null) {
            Number number;
            int n;
            string = string.trim();
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) > ' ') continue;
                string = string.substring(0, n);
                bl = true;
                break;
            }
            n = 2;
            try {
                Long l = Long.decode(string);
                if (l == (long)l.intValue()) {
                    number = l.intValue();
                    n = 8;
                } else {
                    number = l;
                    n = 16;
                }
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    number = Double.valueOf(string);
                    n = 64;
                }
                catch (NumberFormatException numberFormatException2) {
                    number = 0;
                }
            }
            this.nvalue = number;
            string = string.toLowerCase();
            if (string.equals("true") || string.equals("yes")) {
                this.bvalue = true;
                n = 4;
            } else if (string.equals("false") || string.equals("no")) {
                this.bvalue = false;
                n = 4;
            } else {
                this.bvalue = n != 2 && number.intValue() != 0;
            }
            this.type = bl ? 2 | n : n;
        } else {
            this.type = 1;
            this.nvalue = 0;
            this.bvalue = false;
        }
    }

    public boolean isNull() {
        return this.type == 1;
    }

    @ConversionConstructor
    public Variant(boolean bl) {
        this.svalue = String.valueOf(bl);
        this.nvalue = bl ? 1 : 0;
        this.bvalue = bl;
        this.type = 4;
    }

    @ConversionConstructor
    public Variant(int n) {
        this.svalue = String.valueOf(n);
        this.nvalue = n;
        this.bvalue = n != 0;
        this.type = 8;
    }

    @ConversionConstructor
    public Variant(long l) {
        this.svalue = String.valueOf(l);
        this.nvalue = l;
        this.bvalue = l != 0L;
        this.type = 16;
    }

    @ConversionConstructor
    public Variant(float f) {
        this.svalue = String.valueOf(f);
        this.nvalue = Float.valueOf(f);
        this.bvalue = f != 0.0f;
        this.type = 32;
    }

    @ConversionConstructor
    public Variant(double d) {
        this.svalue = String.valueOf(d);
        this.nvalue = d;
        this.bvalue = d != 0.0;
        this.type = 64;
    }

    @ConversionConstructor
    public Variant(Object object) {
        this(object != null ? object.toString() : null, false);
    }

    public boolean booleanValue() {
        return this.bvalue;
    }

    public int intValue() {
        return this.nvalue.intValue();
    }

    public long longValue() {
        return this.nvalue.longValue();
    }

    public float floatValue() {
        return this.nvalue.floatValue();
    }

    public double doubleValue() {
        return this.nvalue.doubleValue();
    }

    public String toString() {
        return this.svalue;
    }

    public static Variant operator$add(Variant variant, Variant variant2) {
        int n = variant.type | variant2.type;
        if ((n & 2) == 0) {
            if ((n & 0x40) != 0) {
                return new Variant(variant.doubleValue() + variant2.doubleValue());
            }
            if ((n & 0x20) != 0) {
                return new Variant(variant.floatValue() + variant2.floatValue());
            }
            if ((n & 0x10) != 0) {
                return new Variant(variant.longValue() + variant2.longValue());
            }
            if ((n & 8) != 0) {
                return new Variant(variant.intValue() + variant2.intValue());
            }
        }
        return new Variant(variant.svalue + variant2.svalue, true);
    }

    public static Variant operator$mul(Variant variant, Variant variant2) {
        int n = variant.type | variant2.type;
        if ((n & 0x40) != 0) {
            return new Variant(variant.doubleValue() * variant2.doubleValue());
        }
        if ((n & 0x20) != 0) {
            return new Variant(variant.floatValue() * variant2.floatValue());
        }
        if ((n & 0x10) != 0) {
            return new Variant(variant.longValue() * variant2.longValue());
        }
        if ((n & 8) != 0) {
            return new Variant(variant.intValue() * variant2.intValue());
        }
        return new Variant(variant.doubleValue() * variant2.doubleValue());
    }

    public static Variant operator$sub(Variant variant, Variant variant2) {
        int n = variant.type | variant2.type;
        if ((n & 0x40) != 0) {
            return new Variant(variant.doubleValue() - variant2.doubleValue());
        }
        if ((n & 0x20) != 0) {
            return new Variant(variant.floatValue() - variant2.floatValue());
        }
        if ((n & 0x10) != 0) {
            return new Variant(variant.longValue() - variant2.longValue());
        }
        if ((n & 8) != 0) {
            return new Variant(variant.intValue() - variant2.intValue());
        }
        return new Variant(variant.doubleValue() - variant2.doubleValue());
    }

    public static Variant operator$div(Variant variant, Variant variant2) {
        int n = variant.type | variant2.type;
        if ((n & 0x40) != 0) {
            return new Variant(variant.doubleValue() / variant2.doubleValue());
        }
        if ((n & 0x20) != 0) {
            return new Variant(variant.floatValue() / variant2.floatValue());
        }
        return new Variant(variant.doubleValue() / variant2.doubleValue());
    }

    public static boolean operator$ge(Variant variant, Variant variant2) {
        return (variant.type | variant2.type) == 2 ? variant.svalue.compareTo(variant2.svalue) >= 0 : variant.doubleValue() >= variant2.doubleValue();
    }

    public static boolean operator$gt(Variant variant, Variant variant2) {
        return (variant.type | variant2.type) == 2 ? variant.svalue.compareTo(variant2.svalue) > 0 : variant.doubleValue() > variant2.doubleValue();
    }

    public static boolean operator$le(Variant variant, Variant variant2) {
        return (variant.type | variant2.type) == 2 ? variant.svalue.compareTo(variant2.svalue) <= 0 : variant.doubleValue() <= variant2.doubleValue();
    }

    public static boolean operator$lt(Variant variant, Variant variant2) {
        return (variant.type | variant2.type) == 2 ? variant.svalue.compareTo(variant2.svalue) < 0 : variant.doubleValue() < variant2.doubleValue();
    }
}

