/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.Aggregate;
import de.grogra.xl.lang.Filter;
import de.grogra.xl.util.BooleanList;
import de.grogra.xl.util.ByteList;
import de.grogra.xl.util.CharList;
import de.grogra.xl.util.DoubleList;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongList;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.util.ShortList;
import java.lang.reflect.Array;
import java.util.Random;

public final class Operators {
    private static final ThreadLocal<Random> randomGenerators = new ThreadLocal();

    public static Random getRandomGenerator() {
        Random random = randomGenerators.get();
        if (random == null) {
            random = new Random();
            randomGenerators.set(random);
        }
        return random;
    }

    private Operators() {
    }

    public static void forall(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished() && !bl) {
            aggregate.ival = 0;
            aggregate.setFinished();
        }
    }

    public static void exist(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.ival = 1;
            aggregate.setFinished();
        }
    }

    public static long count(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            ++aggregate.lval;
        }
        return 0L;
    }

    public static boolean empty(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = 0;
            aggregate.setFinished();
        }
        return false;
    }

    public static String string(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new StringBuffer("[]");
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            aggregate.aval = aggregate.aval1.toString();
        } else {
            StringBuffer stringBuffer = (StringBuffer)aggregate.aval1;
            if (aggregate.ival == 0) {
                aggregate.ival = 1;
            } else {
                stringBuffer.insert(stringBuffer.length() - 1, ',');
            }
            stringBuffer.insert(stringBuffer.length() - 1, bl);
        }
        return null;
    }

    public static long count(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            ++aggregate.lval;
        }
        return 0L;
    }

    public static boolean empty(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = 0;
            aggregate.setFinished();
        }
        return false;
    }

    public static String string(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new StringBuffer("[]");
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            aggregate.aval = aggregate.aval1.toString();
        } else {
            StringBuffer stringBuffer = (StringBuffer)aggregate.aval1;
            if (aggregate.ival == 0) {
                aggregate.ival = 1;
            } else {
                stringBuffer.insert(stringBuffer.length() - 1, ',');
            }
            stringBuffer.insert(stringBuffer.length() - 1, n);
        }
        return null;
    }

    public static long count(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            ++aggregate.lval;
        }
        return 0L;
    }

    public static boolean empty(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = 0;
            aggregate.setFinished();
        }
        return false;
    }

    public static String string(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new StringBuffer("[]");
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            aggregate.aval = aggregate.aval1.toString();
        } else {
            StringBuffer stringBuffer = (StringBuffer)aggregate.aval1;
            if (aggregate.ival == 0) {
                aggregate.ival = 1;
            } else {
                stringBuffer.insert(stringBuffer.length() - 1, ',');
            }
            stringBuffer.insert(stringBuffer.length() - 1, l);
        }
        return null;
    }

    public static long count(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            ++aggregate.lval;
        }
        return 0L;
    }

    public static boolean empty(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = 0;
            aggregate.setFinished();
        }
        return false;
    }

    public static String string(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new StringBuffer("[]");
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            aggregate.aval = aggregate.aval1.toString();
        } else {
            StringBuffer stringBuffer = (StringBuffer)aggregate.aval1;
            if (aggregate.ival == 0) {
                aggregate.ival = 1;
            } else {
                stringBuffer.insert(stringBuffer.length() - 1, ',');
            }
            stringBuffer.insert(stringBuffer.length() - 1, f);
        }
        return null;
    }

    public static long count(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            ++aggregate.lval;
        }
        return 0L;
    }

    public static boolean empty(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = 0;
            aggregate.setFinished();
        }
        return false;
    }

    public static String string(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new StringBuffer("[]");
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            aggregate.aval = aggregate.aval1.toString();
        } else {
            StringBuffer stringBuffer = (StringBuffer)aggregate.aval1;
            if (aggregate.ival == 0) {
                aggregate.ival = 1;
            } else {
                stringBuffer.insert(stringBuffer.length() - 1, ',');
            }
            stringBuffer.insert(stringBuffer.length() - 1, d);
        }
        return null;
    }

    public static long count(Aggregate aggregate, Object object) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            ++aggregate.lval;
        }
        return 0L;
    }

    public static boolean empty(Aggregate aggregate, Object object) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = 0;
            aggregate.setFinished();
        }
        return false;
    }

    public static String string(Aggregate aggregate, Object object) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new StringBuffer("[]");
            aggregate.ival = 0;
        }
        if (aggregate.isFinished()) {
            aggregate.aval = aggregate.aval1.toString();
        } else {
            StringBuffer stringBuffer = (StringBuffer)aggregate.aval1;
            if (aggregate.ival == 0) {
                aggregate.ival = 1;
            } else {
                stringBuffer.insert(stringBuffer.length() - 1, ',');
            }
            stringBuffer.insert(stringBuffer.length() - 1, object);
        }
        return null;
    }

    public static Array array(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new BooleanList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((BooleanList)aggregate.aval1).toArray();
        } else {
            ((BooleanList)aggregate.aval1).add(bl);
        }
        return null;
    }

    public static void first(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = bl ? 1 : 0;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, boolean bl, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        int n = filter.ival = bl ? 1 : 0;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, boolean bl, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            int n = filter.ival = bl ? 1 : 0;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = bl ? 1 : 0;
        }
    }

    public static void selectWhere(Aggregate aggregate, boolean bl, boolean bl2) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished() && bl2) {
            aggregate.ival = bl ? 1 : 0;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.ival = bl ? 1 : 0;
        }
    }

    public static void selectRandomly(Aggregate aggregate, boolean bl, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.ival = bl ? 1 : 0;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, boolean bl, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.ival = bl ? 1 : 0;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, boolean bl, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.ival = bl ? 1 : 0;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, boolean bl, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.ival = bl ? 1 : 0;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, boolean bl, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.ival = bl ? 1 : 0;
            aggregate.dval1 = d;
        }
    }

    public static Array array(Aggregate aggregate, byte by) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new ByteList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((ByteList)aggregate.aval1).toArray();
        } else {
            ((ByteList)aggregate.aval1).add(by);
        }
        return null;
    }

    public static void first(Aggregate aggregate, byte by) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = by;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, byte by, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        filter.ival = by;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, byte by, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.ival = by;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, byte by) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = by;
        }
    }

    public static void selectWhere(Aggregate aggregate, byte by, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.ival = by;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, byte by) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.ival = by;
        }
    }

    public static void selectRandomly(Aggregate aggregate, byte by, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.ival = by;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, byte by, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.ival = by;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, byte by, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.ival = by;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, byte by, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.ival = by;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, byte by, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.ival = by;
            aggregate.dval1 = d;
        }
    }

    public static Array array(Aggregate aggregate, short s) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new ShortList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((ShortList)aggregate.aval1).toArray();
        } else {
            ((ShortList)aggregate.aval1).add(s);
        }
        return null;
    }

    public static void first(Aggregate aggregate, short s) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = s;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, short s, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        filter.ival = s;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, short s, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.ival = s;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, short s) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = s;
        }
    }

    public static void selectWhere(Aggregate aggregate, short s, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.ival = s;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, short s) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.ival = s;
        }
    }

    public static void selectRandomly(Aggregate aggregate, short s, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.ival = s;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, short s, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.ival = s;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, short s, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.ival = s;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, short s, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.ival = s;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, short s, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.ival = s;
            aggregate.dval1 = d;
        }
    }

    public static Array array(Aggregate aggregate, char c) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new CharList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((CharList)aggregate.aval1).toArray();
        } else {
            ((CharList)aggregate.aval1).add(c);
        }
        return null;
    }

    public static void first(Aggregate aggregate, char c) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = c;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, char c, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        filter.ival = c;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, char c, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.ival = c;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, char c) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = c;
        }
    }

    public static void selectWhere(Aggregate aggregate, char c, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.ival = c;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, char c) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.ival = c;
        }
    }

    public static void selectRandomly(Aggregate aggregate, char c, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.ival = c;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, char c, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.ival = c;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, char c, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.ival = c;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, char c, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.ival = c;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, char c, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.ival = c;
            aggregate.dval1 = d;
        }
    }

    public static Array array(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new IntList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((IntList)aggregate.aval1).toArray();
        } else {
            ((IntList)aggregate.aval1).add(n);
        }
        return null;
    }

    public static void first(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = n;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, int n, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        filter.ival = n;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, int n, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.ival = n;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival = n;
        }
    }

    public static void selectWhere(Aggregate aggregate, int n, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.ival = n;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.ival = n;
        }
    }

    public static void selectRandomly(Aggregate aggregate, int n, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.ival = n;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, int n, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.ival = n;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, int n, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.ival = n;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, int n, long l) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.ival = n;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, int n, double d) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.ival = n;
            aggregate.dval1 = d;
        }
    }

    public static Array array(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new LongList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((LongList)aggregate.aval1).toArray();
        } else {
            ((LongList)aggregate.aval1).add(l);
        }
        return null;
    }

    public static void first(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            aggregate.lval = l;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, long l, long l2) {
        if (filter.initialize()) {
            if (l2 <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l2;
        }
        filter.lval = l;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, long l, long l2, long l3) {
        if (filter.initialize()) {
            if (l2 < 0L) {
                l2 = 0L;
            }
            filter.accept = false;
            if (l2 >= l3) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l3 - l2;
            filter.lval2 = l2;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.lval = l;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            aggregate.lval = l;
        }
    }

    public static void selectWhere(Aggregate aggregate, long l, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.lval = l;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.lval = l;
        }
    }

    public static void selectRandomly(Aggregate aggregate, long l, double d) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.lval = l;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, long l, long l2) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l2 <= aggregate.lval1) {
            aggregate.lval = l;
            aggregate.lval1 = l2;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, long l, double d) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.lval = l;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, long l, long l2) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l2 >= aggregate.lval1) {
            aggregate.lval = l;
            aggregate.lval1 = l2;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, long l, double d) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.lval = l;
            aggregate.dval1 = d;
        }
    }

    public static Array array(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new FloatList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((FloatList)aggregate.aval1).toArray();
        } else {
            ((FloatList)aggregate.aval1).add(f);
        }
        return null;
    }

    public static void first(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
        }
        if (!aggregate.isFinished()) {
            aggregate.fval = f;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, float f, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        filter.fval = f;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, float f, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.fval = f;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
        }
        if (!aggregate.isFinished()) {
            aggregate.fval = f;
        }
    }

    public static void selectWhere(Aggregate aggregate, float f, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.fval = f;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.fval = f;
        }
    }

    public static void selectRandomly(Aggregate aggregate, float f, double d) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.fval = f;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, float f, long l) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.fval = f;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, float f, double d) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.fval = f;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, float f, long l) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.fval = f;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, float f, double d) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NaN;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.fval = f;
            aggregate.dval1 = d;
        }
    }

    public static Array array(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new DoubleList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((DoubleList)aggregate.aval1).toArray();
        } else {
            ((DoubleList)aggregate.aval1).add(d);
        }
        return null;
    }

    public static void first(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
        }
        if (!aggregate.isFinished()) {
            aggregate.dval = d;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, double d, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        filter.dval = d;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, double d, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.dval = d;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
        }
        if (!aggregate.isFinished()) {
            aggregate.dval = d;
        }
    }

    public static void selectWhere(Aggregate aggregate, double d, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.dval = d;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.dval = d;
        }
    }

    public static void selectRandomly(Aggregate aggregate, double d, double d2) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d2 <= 0.0) {
                d2 = 0.0;
            }
            aggregate.dval1 += d2;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d2) {
                aggregate.dval = d;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, double d, long l) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.dval = d;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, double d, double d2) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d2 <= aggregate.dval1) {
            aggregate.dval = d;
            aggregate.dval1 = d2;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, double d, long l) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.dval = d;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, double d, double d2) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NaN;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d2 >= aggregate.dval1) {
            aggregate.dval = d;
            aggregate.dval1 = d2;
        }
    }

    public static Array array(Aggregate aggregate, Object object) {
        if (aggregate.initialize()) {
            aggregate.aval1 = new ObjectList();
        }
        if (aggregate.isFinished()) {
            aggregate.aval = ((ObjectList)aggregate.aval1).toArray((Object[])Array.newInstance(aggregate.getType().getComponentType(), ((ObjectList)aggregate.aval1).size()));
        } else {
            ((ObjectList)aggregate.aval1).add(object);
        }
        return null;
    }

    public static void first(Aggregate aggregate, Object object) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
        }
        if (!aggregate.isFinished()) {
            aggregate.aval = object;
            aggregate.setFinished();
        }
    }

    public static void first(Filter filter, Object object, long l) {
        if (filter.initialize()) {
            if (l <= 0L) {
                filter.accept = false;
                filter.setFinished();
                return;
            }
            filter.accept = true;
            filter.lval1 = l;
        }
        filter.aval = object;
        if (--filter.lval1 == 0L) {
            filter.setFinished();
        }
    }

    public static void slice(Filter filter, Object object, long l, long l2) {
        if (filter.initialize()) {
            if (l < 0L) {
                l = 0L;
            }
            filter.accept = false;
            if (l >= l2) {
                filter.setFinished();
                return;
            }
            filter.lval1 = l2 - l;
            filter.lval2 = l;
        }
        if (!filter.accept && --filter.lval2 < 0L) {
            filter.accept = true;
        }
        if (filter.accept) {
            filter.aval = object;
            if (--filter.lval1 == 0L) {
                filter.setFinished();
            }
        }
    }

    public static void last(Aggregate aggregate, Object object) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
        }
        if (!aggregate.isFinished()) {
            aggregate.aval = object;
        }
    }

    public static void selectWhere(Aggregate aggregate, Object object, boolean bl) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
        }
        if (!aggregate.isFinished() && bl) {
            aggregate.aval = object;
            aggregate.setFinished();
        }
    }

    public static void selectRandomly(Aggregate aggregate, Object object) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished() && ((Random)aggregate.aval1).nextInt(++aggregate.ival1) == 0) {
            aggregate.aval = object;
        }
    }

    public static void selectRandomly(Aggregate aggregate, Object object, double d) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
            aggregate.aval1 = Operators.getRandomGenerator();
            aggregate.dval1 = 0.0;
        }
        if (!aggregate.isFinished()) {
            if (d <= 0.0) {
                d = 0.0;
            }
            aggregate.dval1 += d;
            if (((Random)aggregate.aval1).nextDouble() * aggregate.dval1 <= d) {
                aggregate.aval = object;
            }
        }
    }

    public static void selectWhereMin(Aggregate aggregate, Object object, long l) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
            aggregate.lval1 = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l <= aggregate.lval1) {
            aggregate.aval = object;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMin(Aggregate aggregate, Object object, double d) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
            aggregate.dval1 = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d <= aggregate.dval1) {
            aggregate.aval = object;
            aggregate.dval1 = d;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, Object object, long l) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
            aggregate.lval1 = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l >= aggregate.lval1) {
            aggregate.aval = object;
            aggregate.lval1 = l;
        }
    }

    public static void selectWhereMax(Aggregate aggregate, Object object, double d) {
        if (aggregate.initialize()) {
            aggregate.aval = null;
            aggregate.dval1 = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished() && d >= aggregate.dval1) {
            aggregate.aval = object;
            aggregate.dval1 = d;
        }
    }

    public static void min(Aggregate aggregate, byte by) {
        if (aggregate.initialize()) {
            aggregate.ival = 127;
        }
        if (!aggregate.isFinished() && by < aggregate.ival) {
            aggregate.ival = by;
        }
    }

    public static void max(Aggregate aggregate, byte by) {
        if (aggregate.initialize()) {
            aggregate.ival = -128;
        }
        if (!aggregate.isFinished() && by > aggregate.ival) {
            aggregate.ival = by;
        }
    }

    public static void min(Aggregate aggregate, short s) {
        if (aggregate.initialize()) {
            aggregate.ival = Short.MAX_VALUE;
        }
        if (!aggregate.isFinished() && s < aggregate.ival) {
            aggregate.ival = s;
        }
    }

    public static void max(Aggregate aggregate, short s) {
        if (aggregate.initialize()) {
            aggregate.ival = Short.MIN_VALUE;
        }
        if (!aggregate.isFinished() && s > aggregate.ival) {
            aggregate.ival = s;
        }
    }

    public static void min(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = Integer.MAX_VALUE;
        }
        if (!aggregate.isFinished() && n < aggregate.ival) {
            aggregate.ival = n;
        }
    }

    public static void max(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = Integer.MIN_VALUE;
        }
        if (!aggregate.isFinished() && n > aggregate.ival) {
            aggregate.ival = n;
        }
    }

    public static void min(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = Long.MAX_VALUE;
        }
        if (!aggregate.isFinished() && l < aggregate.lval) {
            aggregate.lval = l;
        }
    }

    public static void max(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = Long.MIN_VALUE;
        }
        if (!aggregate.isFinished() && l > aggregate.lval) {
            aggregate.lval = l;
        }
    }

    public static void min(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished()) {
            aggregate.fval = Math.min(aggregate.fval, f);
        }
    }

    public static void max(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = Float.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished()) {
            aggregate.fval = Math.max(aggregate.fval, f);
        }
    }

    public static void min(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.POSITIVE_INFINITY;
        }
        if (!aggregate.isFinished()) {
            aggregate.dval = Math.min(aggregate.dval, d);
        }
    }

    public static void max(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = Double.NEGATIVE_INFINITY;
        }
        if (!aggregate.isFinished()) {
            aggregate.dval = Math.max(aggregate.dval, d);
        }
    }

    public static void sum(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival += n;
        }
    }

    public static void mean(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = 0;
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival += n;
            ++aggregate.ival1;
        } else {
            aggregate.ival /= aggregate.ival1;
        }
    }

    public static void prod(Aggregate aggregate, int n) {
        if (aggregate.initialize()) {
            aggregate.ival = 1;
        }
        if (!aggregate.isFinished()) {
            aggregate.ival *= n;
        }
    }

    public static void sum(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
        }
        if (!aggregate.isFinished()) {
            aggregate.lval += l;
        }
    }

    public static void mean(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = 0L;
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.lval += l;
            ++aggregate.ival1;
        } else {
            aggregate.lval /= (long)aggregate.ival1;
        }
    }

    public static void prod(Aggregate aggregate, long l) {
        if (aggregate.initialize()) {
            aggregate.lval = 1L;
        }
        if (!aggregate.isFinished()) {
            aggregate.lval *= l;
        }
    }

    public static void sum(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = 0.0f;
        }
        if (!aggregate.isFinished()) {
            aggregate.fval += f;
        }
    }

    public static void mean(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = 0.0f;
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.fval += f;
            ++aggregate.ival1;
        } else {
            aggregate.fval /= (float)aggregate.ival1;
        }
    }

    public static void prod(Aggregate aggregate, float f) {
        if (aggregate.initialize()) {
            aggregate.fval = 1.0f;
        }
        if (!aggregate.isFinished()) {
            aggregate.fval *= f;
        }
    }

    public static void sum(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = 0.0;
        }
        if (!aggregate.isFinished()) {
            aggregate.dval += d;
        }
    }

    public static void mean(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = 0.0;
            aggregate.ival1 = 0;
        }
        if (!aggregate.isFinished()) {
            aggregate.dval += d;
            ++aggregate.ival1;
        } else {
            aggregate.dval /= (double)aggregate.ival1;
        }
    }

    public static void prod(Aggregate aggregate, double d) {
        if (aggregate.initialize()) {
            aggregate.dval = 1.0;
        }
        if (!aggregate.isFinished()) {
            aggregate.dval *= d;
        }
    }
}

