/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashMap<V>
implements Iterable<Entry<V>> {
    private float loadFactor;
    private int size;
    private int resizeThreshold;
    private int lengthM1;
    private Entry<V>[] table;

    public IntHashMap(int n, float f) {
        int n2;
        this.loadFactor = f;
        n = (int)((float)(n + 1) / f) + 2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.resizeThreshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.lengthM1 = n2 - 1;
        this.size = 0;
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap() {
        this(16, 0.75f);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry<V>[] entryArray = this.table;
        for (int i = this.lengthM1; i >= 0; --i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    public void add(int n, V v) {
        this.add(new Entry<V>(n, v));
    }

    public V put(int n, V v) {
        int n2 = IntHashMap.getHashCode(n);
        Entry<V> entry = this.table[n2 & this.lengthM1];
        while (entry != null) {
            if (entry.key == n) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        this.add(new Entry<V>(n, v));
        return null;
    }

    private void add(Entry<V> entry) {
        int n = IntHashMap.getHashCode(entry.key) & this.lengthM1;
        entry.next = this.table[n];
        this.table[n] = entry;
        if (++this.size > this.resizeThreshold) {
            Entry[] entryArray = new Entry[this.lengthM1 + 1 << 1];
            Entry<V>[] entryArray2 = this.table;
            int n2 = entryArray.length - 1;
            for (int i = this.lengthM1; i >= 0; --i) {
                Entry entry2;
                entry = entryArray2[i];
                if (entry == null) continue;
                entryArray2[i] = null;
                do {
                    entry2 = entry.next;
                    n = IntHashMap.getHashCode(entry.key) & n2;
                    entry.next = entryArray[n];
                    entryArray[n] = entry;
                } while ((entry = entry2) != null);
            }
            this.table = entryArray;
            this.lengthM1 = n2;
            this.resizeThreshold = (int)((float)entryArray.length * this.loadFactor);
        }
    }

    public void remove(Entry<V> entry) {
        int n = IntHashMap.getHashCode(entry.key) & this.lengthM1;
        Entry<V> entry2 = this.table[n];
        Entry<V> entry3 = null;
        while (entry2 != null) {
            if (entry2 == entry) {
                --this.size;
                if (entry3 != null) {
                    entry3.next = entry2.next;
                } else {
                    this.table[n] = entry2.next;
                }
                return;
            }
            entry3 = entry2;
            entry2 = entry2.next;
        }
    }

    public V remove(int n) {
        int n2 = IntHashMap.getHashCode(n);
        int n3 = n2 & this.lengthM1;
        Entry<V> entry = this.table[n3];
        Entry<V> entry2 = null;
        while (entry != null) {
            if (entry.key == n) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n3] = entry.next;
                }
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public V remove(int n, V v) {
        int n2 = IntHashMap.getHashCode(n);
        int n3 = n2 & this.lengthM1;
        Entry<V> entry = this.table[n3];
        Entry<V> entry2 = null;
        while (entry != null) {
            if (v == entry.value && entry.key == n) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n3] = entry.next;
                }
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void removeAll(int n) {
        int n2 = IntHashMap.getHashCode(n);
        int n3 = n2 & this.lengthM1;
        Entry<V> entry = this.table[n3];
        Entry<V> entry2 = null;
        while (entry != null) {
            if (entry.key == n) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n3] = entry.next;
                }
            } else {
                entry2 = entry;
            }
            entry = entry.next;
        }
    }

    public Entry getEntry(int n) {
        int n2 = IntHashMap.getHashCode(n);
        Entry<V> entry = this.table[n2 & this.lengthM1];
        while (entry != null) {
            if (entry.key == n) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public V get(int n) {
        Entry entry = this.getEntry(n);
        return entry != null ? (V)entry.value : null;
    }

    public Object get(int n, Object object) {
        Entry entry = this.getEntry(n);
        return entry != null ? entry.value : object;
    }

    public boolean containsKey(int n) {
        return this.getEntry(n) != null;
    }

    static int getHashCode(int n) {
        n ^= n >> 20 ^ n >> 12;
        return n ^ n >> 7 ^ n >> 4;
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return new Iterator<Entry<V>>(){
            private int index = -1;
            private Entry<V> next;
            private Entry<V> current;

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (++this.index > IntHashMap.this.lengthM1) {
                        return false;
                    }
                    this.next = IntHashMap.this.table[this.index];
                }
                return this.next != null;
            }

            @Override
            public Entry<V> next() {
                if (!this.hasNext()) {
                    return null;
                }
                this.current = this.next;
                this.next = this.current.next;
                return this.current;
            }

            @Override
            public void remove() {
                IntHashMap.this.remove(this.current);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        final int key;
        V value;
        Entry<V> next;

        Entry(int n, V v) {
            this.key = n;
            this.value = v;
        }

        public Entry<V> next() {
            Entry<V> entry = this.next;
            while (entry != null) {
                if (entry.key == this.key) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

