/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.BooleanConsumer;
import de.grogra.xl.lang.VoidToBooleanGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BooleanList
implements Cloneable,
Serializable,
BooleanConsumer,
VoidToBooleanGenerator {
    private static final long serialVersionUID = 8918756206414031425L;
    public transient boolean[] elements;
    public int size = 0;
    private static final boolean[] EMPTY = new boolean[0];
    private static final boolean[] BOOLEAN_NULL = new boolean[1024];

    public BooleanList(int n) {
        this.elements = new boolean[Math.max(n, 8)];
    }

    public BooleanList() {
        this(16);
    }

    public BooleanList(boolean[] blArray) {
        this(blArray.length);
        this.size = blArray.length;
        BooleanList.arraycopy(blArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            BooleanList booleanList = (BooleanList)super.clone();
            booleanList.elements = new boolean[Math.max(this.size, 8)];
            BooleanList.arraycopy(this.elements, 0, booleanList.elements, 0, this.size);
            return booleanList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            boolean[] blArray = new boolean[Math.max(n, this.elements.length * 2)];
            BooleanList.arraycopy(this.elements, 0, blArray, 0, this.size);
            this.elements = blArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new boolean[this.size];
                BooleanList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final BooleanList push(boolean bl) {
        this.add(bl);
        return this;
    }

    public final BooleanList push(boolean bl, boolean bl2) {
        this.add(bl);
        this.add(bl2);
        return this;
    }

    public final BooleanList push(boolean bl, boolean bl2, boolean bl3) {
        this.add(bl);
        this.add(bl2);
        this.add(bl3);
        return this;
    }

    public boolean add(boolean bl) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = bl;
        ++this.size;
        return true;
    }

    public void add(int n, boolean bl) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            BooleanList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            BooleanList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = bl;
        ++this.size;
    }

    public void addIfNotContained(boolean bl) {
        if (!this.contains(bl)) {
            this.add(bl);
        }
    }

    public BooleanList addAll(BooleanList booleanList) {
        return this.addAll(booleanList.elements, 0, booleanList.size);
    }

    public BooleanList addAll(boolean[] blArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        BooleanList.arraycopy(blArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public boolean removeAt(int n) {
        boolean bl = this.elements[n];
        BooleanList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return bl;
    }

    public boolean remove(boolean bl) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (bl != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public boolean set(int n, boolean bl) {
        boolean bl2;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            BooleanList.clear(this.elements, this.size, n - this.size);
            bl2 = this.elements[n];
            this.elements[n] = bl;
            this.size = n + 1;
        } else {
            bl2 = this.elements[n];
            this.elements[n] = bl;
        }
        return bl2;
    }

    public boolean get(int n) {
        return n < this.size ? this.elements[n] : false;
    }

    public boolean peek(int n) {
        return n > 0 ? this.elements[this.size - n] : false;
    }

    public boolean contains(boolean bl) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (bl != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(boolean bl) {
        for (int i = 0; i < this.size; ++i) {
            if (bl != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(boolean bl) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (bl != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(boolean[] blArray, int n, boolean[] blArray2, int n2, int n3) {
        if (n3 < 20) {
            if (blArray2 != blArray || n2 > n) {
                while (--n3 >= 0) {
                    blArray2[n2 + n3] = blArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    blArray2[n2 + i] = blArray[n + i];
                }
            }
        } else {
            System.arraycopy(blArray, n, blArray2, n2, n3);
        }
    }

    public static void clear(boolean[] blArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                blArray[n + n2] = false;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                BooleanList.arraycopy(BOOLEAN_NULL, 0, blArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public boolean pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public boolean[] toArray() {
        boolean[] blArray = new boolean[this.size];
        BooleanList.arraycopy(this.elements, 0, blArray, 0, this.size);
        return blArray;
    }

    public boolean[] toArray(boolean[] blArray) {
        int n = blArray.length;
        if (n > this.size) {
            blArray[this.size] = false;
        } else if (n < this.size) {
            blArray = new boolean[this.size];
        }
        BooleanList.arraycopy(this.elements, 0, blArray, 0, this.size);
        return blArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BooleanList)) {
            return false;
        }
        BooleanList booleanList = (BooleanList)object;
        if (this.size != booleanList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == booleanList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + (this.elements[i] ? 1231 : 1237);
        }
        return n;
    }

    public void consume(boolean bl) {
        this.add(bl);
    }

    public void evaluateBoolean(BooleanConsumer booleanConsumer) {
        for (int i = 0; i < this.size; ++i) {
            booleanConsumer.consume(this.elements[i]);
        }
    }

    public void values(BooleanConsumer booleanConsumer) {
        this.evaluateBoolean(booleanConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeBoolean(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new boolean[this.size];
        boolean[] blArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            blArray[i] = objectInputStream.readBoolean();
        }
    }
}

