/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.reflect.TypeLoader;
import de.grogra.util.I18NBundle;
import de.grogra.util.IOWrapException;
import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.StringMap;
import de.grogra.util.UserException;
import de.grogra.util.WrapException;
import de.grogra.util.XByteArrayOutputStream;
import de.grogra.xl.util.ClassLoaderObjectInputStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.tree.TreeModel;
import org.xml.sax.SAXException;

public final class Utils {
    public static final int DEBUG = 1;
    public static final I18NBundle I18N;
    public static final boolean[] BOOLEAN_0;
    public static final byte[] BYTE_0;
    public static final short[] SHORT_0;
    public static final char[] CHAR_0;
    public static final int[] INT_0;
    public static final long[] LONG_0;
    public static final float[] FLOAT_0;
    public static final double[] DOUBLE_0;
    public static final Object[] OBJECT_0;
    public static final String[] STRING_0;
    private static final Method nanoTimeMethod;
    private static final Color[] COLORS;
    public static PrintWriter debug;
    private static final char[] byteToBase64;
    private static final byte[] base64ToByte;
    private static long time;
    private static long lastTime;
    private static StringMap loggerNames;

    public static long nanoTime() {
        if (nanoTimeMethod == null) {
            return System.currentTimeMillis() * 1000000L;
        }
        try {
            return (Long)nanoTimeMethod.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static boolean hasNanoTimeMethod() {
        return nanoTimeMethod != null;
    }

    private static int o2c(int n) {
        return n * 255 / 7;
    }

    public static Color getApproximateColor(int n) {
        return COLORS[(n >> 15 & 0x1C0) + (n >> 10 & 0x38) + (n >> 5 & 7)];
    }

    public static int indexOfOne(int n) {
        switch (n & -n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
            case 131072: {
                return 17;
            }
            case 262144: {
                return 18;
            }
            case 524288: {
                return 19;
            }
            case 0x100000: {
                return 20;
            }
            case 0x200000: {
                return 21;
            }
            case 0x400000: {
                return 22;
            }
            case 0x800000: {
                return 23;
            }
            case 0x1000000: {
                return 24;
            }
            case 0x2000000: {
                return 25;
            }
            case 0x4000000: {
                return 26;
            }
            case 0x8000000: {
                return 27;
            }
            case 0x10000000: {
                return 28;
            }
            case 0x20000000: {
                return 29;
            }
            case 0x40000000: {
                return 30;
            }
            case -2147483648: {
                return 31;
            }
        }
        throw new AssertionError();
    }

    public static URL getURLResource(String string) {
        ClassLoader classLoader;
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null && (classLoader = null) != null) {
            uRL = classLoader.getResource(string);
        }
        return uRL;
    }

    public static InputStream getStreamResource(String string) {
        URL uRL = Utils.getURLResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object get(Map map, Object object, Object object2) {
        return map == null ? object2 : map.get(object, object2);
    }

    public static boolean getBoolean(Map map, Object object) {
        return Utils.getBoolean(map, object, false);
    }

    public static boolean getBoolean(Map map, Object object, boolean bl) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? bl : (Boolean)object2;
    }

    public static byte getByte(Map map, Object object) {
        return Utils.getByte(map, object, (byte)0);
    }

    public static byte getByte(Map map, Object object, byte by) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? by : ((Number)object2).byteValue();
    }

    public static short getShort(Map map, Object object) {
        return Utils.getShort(map, object, (short)0);
    }

    public static short getShort(Map map, Object object, short s) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? s : ((Number)object2).shortValue();
    }

    public static char getChar(Map map, Object object) {
        return Utils.getChar(map, object, '\u0000');
    }

    public static char getChar(Map map, Object object, char c) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? c : ((Character)object2).charValue();
    }

    public static int getInt(Map map, Object object) {
        return Utils.getInt(map, object, 0);
    }

    public static int getInt(Map map, Object object, int n) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? n : ((Number)object2).intValue();
    }

    public static long getLong(Map map, Object object) {
        return Utils.getLong(map, object, 0L);
    }

    public static long getLong(Map map, Object object, long l) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? l : ((Number)object2).longValue();
    }

    public static float getFloat(Map map, Object object) {
        return Utils.getFloat(map, object, 0.0f);
    }

    public static float getFloat(Map map, Object object, float f) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? f : ((Number)object2).floatValue();
    }

    public static double getDouble(Map map, Object object) {
        return Utils.getDouble(map, object, 0.0);
    }

    public static double getDouble(Map map, Object object, double d) {
        Object object2;
        return map == null || (object2 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? d : ((Number)object2).doubleValue();
    }

    public static Object getObject(Map map, Object object) {
        return Utils.getObject(map, object, null);
    }

    public static Object getObject(Map map, Object object, Object object2) {
        Object object3;
        return map == null || (object3 = map.get(object, Map.DEFAULT_VALUE)) == Map.DEFAULT_VALUE ? object2 : object3;
    }

    public static String firstToUpperCase(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public static boolean contentEquals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence.equals(charSequence2)) {
            return true;
        }
        int n = charSequence.length();
        if (n != charSequence2.length()) {
            return false;
        }
        while (--n >= 0) {
            if (charSequence.charAt(n) == charSequence2.charAt(n)) continue;
            return false;
        }
        return true;
    }

    public static int getStringHashCode(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = (n3 << 5) - n3 + charSequence.charAt(i);
        }
        return n3;
    }

    public static int getStringHashCode(CharSequence charSequence) {
        return charSequence != null ? Utils.getStringHashCode(charSequence, 0, charSequence.length()) : 0;
    }

    private Utils() {
    }

    public static Throwable getUserException(Throwable throwable) {
        while (!(throwable instanceof UserException)) {
            if (throwable == null) {
                return null;
            }
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable unwrap(Throwable throwable) {
        while (throwable.getCause() != null && (throwable instanceof WrapException || throwable instanceof IOWrapException)) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable unwrapFully(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable getMainException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = Utils.getUserException(throwable);
        return throwable2 != null ? throwable2 : Utils.unwrap(throwable);
    }

    public static Throwable initCauses(Throwable throwable) {
        if (throwable != null) {
            Throwable throwable2 = throwable;
            while (throwable2 != null) {
                Throwable throwable3 = throwable2 instanceof SAXException ? ((SAXException)throwable2).getException() : null;
                if (throwable3 == null) {
                    throwable3 = throwable2.getCause();
                }
                if (throwable3 != null && throwable2.getCause() == null) {
                    try {
                        throwable2.initCause(throwable3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throwable2 = throwable3;
            }
        }
        return throwable;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public static Object evaluate(String string, Object[] objectArray, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int n;
        int n2 = string.lastIndexOf(46);
        if (Character.isUpperCase(string.charAt(n2 + 1)) && !Character.isUpperCase(string.charAt((n = string.lastIndexOf(46, n2 - 1)) + 1))) {
            return Utils.newInstance(string, objectArray, classLoader);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        if (Character.isUpperCase(string3.charAt(0))) {
            return Class.forName(string2, true, classLoader).getField(string3).get(null);
        }
        return Utils.invokeStatic(string2, string3, objectArray, classLoader);
    }

    public static Object invoke(String string, Object[] objectArray, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int n = string.lastIndexOf(46);
        if (Character.isUpperCase(string.charAt(n + 1))) {
            return Utils.newInstance(string, objectArray, classLoader);
        }
        return Utils.invokeStatic(string.substring(0, n), string.substring(n + 1), objectArray, classLoader);
    }

    public static Object invokeStatic(String string, String string2, Object[] objectArray, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return Utils.invoke(Class.forName(string, true, classLoader), string2, null, objectArray);
    }

    public static Object invokeStatic(Class clazz, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return Utils.invoke(clazz, string, null, objectArray);
    }

    public static Object invokeVirtual(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return Utils.invoke(object.getClass(), string, object, objectArray);
    }

    private static Object invoke(Class clazz, String string, Object object, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string) || !Utils.isApplicable(methodArray[i].getParameterTypes(), objectArray)) continue;
            return methodArray[i].invoke(object, objectArray);
        }
        throw new NoSuchMethodException(clazz.getName() + '.' + string);
    }

    public static Object newInstance(String string, Object[] objectArray, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return Utils.newInstance(Class.forName(string, true, classLoader), objectArray);
    }

    public static Object newInstance(Class clazz, Object[] objectArray) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            if (!Utils.isApplicable(constructorArray[i].getParameterTypes(), objectArray)) continue;
            return constructorArray[i].newInstance(objectArray);
        }
        throw new NoSuchMethodException(clazz.getName() + " " + Arrays.deepToString(objectArray));
    }

    private static boolean isApplicable(Class[] classArray, Object[] objectArray) {
        if (classArray.length != (objectArray != null ? objectArray.length : 0)) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (!(classArray[i].isPrimitive() ? (classArray[i] == Boolean.TYPE ? !(objectArray[i] instanceof Boolean) : (classArray[i] == Byte.TYPE ? !(objectArray[i] instanceof Byte) : (classArray[i] == Short.TYPE ? !(objectArray[i] instanceof Short) : (classArray[i] == Character.TYPE ? !(objectArray[i] instanceof Character) : (classArray[i] == Integer.TYPE ? !(objectArray[i] instanceof Integer) : (classArray[i] == Long.TYPE ? !(objectArray[i] instanceof Long) : (classArray[i] == Float.TYPE ? !(objectArray[i] instanceof Float) : classArray[i] == Double.TYPE && !(objectArray[i] instanceof Double)))))))) : objectArray[i] != null && !classArray[i].isInstance(objectArray[i]))) continue;
            return false;
        }
        return true;
    }

    public static SAXException newSAXException(Exception exception) {
        SAXException sAXException = new SAXException(exception);
        if (sAXException.getCause() == null) {
            sAXException.initCause(exception);
        }
        return sAXException;
    }

    public static void rethrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable != null) {
            throw new WrapException(throwable);
        }
    }

    public static void dumpArray(Object object) {
        if (object == null) {
            System.err.println((Object)null);
        } else {
            for (int i = 0; i < Array.getLength(object); ++i) {
                System.err.println("[" + i + "]=" + Array.get(object, i));
            }
        }
    }

    public static boolean isContained(Object object, Object[] objectArray) {
        if (objectArray != null) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                if (!Utils.equal(object, objectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            n = 31 * n + (object != null ? object.hashCode() : 0);
        }
        return n;
    }

    public static void dumpTree(TreeModel treeModel) {
        Utils.dumpTree(treeModel, treeModel.getRoot(), 0);
    }

    private static void dumpTree(TreeModel treeModel, Object object, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.err.print("  ");
        }
        System.err.println(object);
        if (object != null && !treeModel.isLeaf(object)) {
            int n3 = treeModel.getChildCount(object);
            for (n2 = 0; n2 < n3; ++n2) {
                Utils.dumpTree(treeModel, treeModel.getChild(object, n2), n + 1);
            }
        }
    }

    public static String escape(CharSequence charSequence, String string) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length() * 3 / 2);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (string.indexOf(c) >= 0) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void escapeForXML(StringBuffer stringBuffer, int n) {
        Utils.escapeForXML(stringBuffer, n, stringBuffer.length());
    }

    public static void escapeForXML(StringBuffer stringBuffer, int n, int n2) {
        for (int i = n2 - 1; i >= n; --i) {
            String string;
            switch (stringBuffer.charAt(i)) {
                case '<': {
                    string = "&lt;";
                    break;
                }
                case '>': {
                    string = "&gt;";
                    break;
                }
                case '&': {
                    string = "&amp;";
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (string == null) continue;
            stringBuffer.replace(i, i + 1, string);
        }
    }

    public static File relativize(File file, File file2) {
        if (!file.isAbsolute() || !file2.isAbsolute()) {
            throw new IllegalArgumentException("Files must be absolute");
        }
        return (file = Utils.relativize0(file, file2)) == null ? file2 : file;
    }

    private static File relativize0(File file, File file2) {
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return null;
        }
        if (file.equals(file3)) {
            return new File(file2.getName());
        }
        File file4 = Utils.relativize0(file, file3);
        return file4 == null ? null : new File(file4, file2.getName());
    }

    public static File resolve(File file, File file2) {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Base must be absolute");
        }
        if (file2.isAbsolute()) {
            return file2;
        }
        return Utils.resolve0(file, file2);
    }

    private static File resolve0(File file, File file2) {
        if (file2 == null) {
            return file;
        }
        return new File(Utils.resolve0(file, file2.getParentFile()), file2.getName());
    }

    public static boolean isURL(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static File urlToFile(URL uRL) {
        return new File(URI.create(uRL.toString()));
    }

    public static String quote(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer(2 + charSequence.length() * 3 / 2);
        Utils.quote(charSequence, stringBuffer);
        return stringBuffer.toString();
    }

    public static void quote(CharSequence charSequence, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
    }

    public static String unquote(CharSequence charSequence) {
        return Utils.unquote(charSequence, 0, charSequence.length(), null);
    }

    public static String unquote(CharSequence charSequence, int n, int n2, int[] nArray) {
        if (n == n2) {
            if (nArray != null) {
                nArray[0] = n2;
            }
            return "";
        }
        if (charSequence.charAt(n) != '\"') {
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            if (nArray != null) {
                nArray[0] = n2;
            }
            return ((Object)charSequence.subSequence(n, n2)).toString();
        }
        StringBuffer stringBuffer = new StringBuffer(Math.max(0, n2 - n - 2));
        int n3 = n + 1;
        while (true) {
            char c = charSequence.charAt(n3++);
            if (n3 == n2) {
                if (c != '\"') {
                    throw new IllegalArgumentException();
                }
                if (nArray != null) {
                    nArray[0] = n2;
                }
                return stringBuffer.toString();
            }
            if (c == '\"') {
                if (n2 >= 0) {
                    throw new IllegalArgumentException();
                }
                if (nArray != null) {
                    nArray[0] = n3;
                }
                return stringBuffer.toString();
            }
            if (c == '\\') {
                c = charSequence.charAt(n3++);
            }
            stringBuffer.append(c);
        }
    }

    public static Dimension parseDimension(String string) {
        int[] nArray = new int[1];
        return new Dimension(Utils.parseInt(string, nArray, -1), Utils.parseInt(string, nArray, 120));
    }

    private static int parseInt(String string, int[] nArray, int n) {
        int n2;
        boolean bl = true;
        int n3 = 0;
        do {
            int n4;
            if (nArray[0] < string.length()) {
                int n5 = nArray[0];
                nArray[0] = n5 + 1;
                n4 = string.charAt(n5);
            } else {
                n4 = n2 = 0;
            }
            if (n >= 0) {
                if (n2 != n) continue;
                n = -1;
                continue;
            }
            if (n2 >= 48 && n2 <= 57) {
                if (bl) {
                    n3 = n2 - 48;
                    bl = false;
                    continue;
                }
                n3 = 10 * n3 + n2 - 48;
                continue;
            }
            if (bl) continue;
            nArray[0] = nArray[0] - 1;
            return n3;
        } while (n2 != 0);
        throw new IllegalArgumentException(string);
    }

    public static Point parsePoint(String string) {
        int[] nArray = new int[1];
        return new Point(Utils.parseInt(string, nArray, -1), Utils.parseInt(string, nArray, -1));
    }

    public static Color parseColor(String string) {
        int[] nArray = new int[1];
        return new Color(Utils.parseInt(string, nArray, -1), Utils.parseInt(string, nArray, -1), Utils.parseInt(string, nArray, -1));
    }

    public static Rectangle parseRectangle(String string) {
        int[] nArray = new int[1];
        int n = Utils.parseInt(string, nArray, -1);
        int n2 = Utils.parseInt(string, nArray, 120);
        return new Rectangle(Utils.parseInt(string, nArray, -1), Utils.parseInt(string, nArray, -1), n, n2);
    }

    public static int parseFloatArray(String string, float[] fArray, String string2) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            int n4;
            if (n < n2 && string2.indexOf(string.charAt(n)) >= 0) {
                ++n;
                continue;
            }
            if (n == n2) {
                return n3;
            }
            for (n4 = n; n4 < n2 && string2.indexOf(string.charAt(n4)) < 0; ++n4) {
            }
            fArray[n3++] = Float.parseFloat(string.substring(n, n4));
            if (n3 == fArray.length) {
                return n3;
            }
            n = n4;
        }
    }

    public static void watchShutdown() {
        System.err.println(new Date());
        Thread thread = new Thread("ShutdownWatcher"){

            public void run() {
                ThreadGroup threadGroup = this.getThreadGroup();
                Thread[] threadArray = null;
                int n = 0;
                while (true) {
                    int n2;
                    Thread thread;
                    int n3;
                    Date date = new Date();
                    Thread[] threadArray2 = new Thread[threadGroup.activeCount() * 2];
                    int n4 = threadGroup.enumerate(threadArray2);
                    for (n3 = 0; n3 < n4; ++n3) {
                        thread = threadArray2[n3];
                        for (n2 = n - 1; n2 >= 0 && threadArray[n2] != thread; --n2) {
                        }
                        if (n2 >= 0) continue;
                        System.err.println("Active Thread: " + thread + "  deamon=" + thread.isDaemon());
                    }
                    for (n3 = 0; n3 < n; ++n3) {
                        thread = threadArray[n3];
                        for (n2 = n4 - 1; n2 >= 0 && threadArray2[n2] != thread; --n2) {
                        }
                        if (n2 >= 0) continue;
                        System.err.println(date + ": Terminated: " + thread);
                    }
                    n = n4;
                    threadArray = threadArray2;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static boolean isStringDescription(String string) {
        return string.equals("Name") || string.equals("ShortDescription") || string.equals("Title");
    }

    public static Object get(I18NBundle i18NBundle, String string, String string2, Object object) {
        if (i18NBundle != null) {
            try {
                return i18NBundle.getObject(string.length() > 0 ? string + '.' + string2 : string2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (Utils.isStringDescription(string2)) {
            if (i18NBundle != null) {
                try {
                    return i18NBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (object == null) {
                return string;
            }
        }
        return object;
    }

    private static byte base64ToByte(char c) throws IOException {
        if (c >= base64ToByte.length || base64ToByte[c] < 0) {
            throw new IOException("Illegal Base64-character " + c);
        }
        return base64ToByte[c];
    }

    public static void encodeBase64(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        int n4 = n2 / 3;
        int n5 = n2 % 3;
        int n6 = n;
        while (--n4 >= 0) {
            int n7 = byArray[n6++] & 0xFF;
            n3 = n7;
            int n8 = (n3 & 3) << 4;
            int n9 = byArray[n6++] & 0xFF;
            n3 = n9;
            int n10 = (n3 & 0xF) << 2;
            n3 = byArray[n6++] & 0xFF;
            stringBuffer.append(byteToBase64[n7 >> 2]).append(byteToBase64[n8 | n9 >>> 4]).append(byteToBase64[n10 | n3 >>> 6]).append(byteToBase64[n3 & 0x3F]);
        }
        if (n5 != 0) {
            n3 = byArray[n6++] & 0xFF;
            stringBuffer.append(byteToBase64[n3 >>> 2]);
            if (n5 == 1) {
                stringBuffer.append(byteToBase64[(n3 & 3) << 4]).append("==");
            } else {
                int n11 = (n3 & 3) << 4;
                n3 = byArray[n6++] & 0xFF;
                stringBuffer.append(byteToBase64[n11 | n3 >>> 4]).append(byteToBase64[(n3 & 0xF) << 2]).append('=');
            }
        }
        assert (n6 == n + n2);
    }

    public static int decodeBase64(CharSequence charSequence, int n, int n2, byte[] byArray) throws IOException {
        byte by;
        int n3 = n2 >> 2;
        if (n3 << 2 != n2) {
            throw new IOException("String length must be a multiple of four.");
        }
        int n4 = 0;
        int n5 = n3;
        if (n2 != 0 && charSequence.charAt(n + n2 - 1) == '=') {
            ++n4;
            --n5;
            if (charSequence.charAt(n + n2 - 2) == '=') {
                ++n4;
            }
        }
        int n6 = 0;
        while (--n5 >= 0) {
            int n7 = n6++;
            int n8 = n++;
            by = Utils.base64ToByte(charSequence.charAt(n++));
            byArray[n7] = (byte)(Utils.base64ToByte(charSequence.charAt(n8)) << 2 | by >> 4);
            int n9 = n6++;
            int n10 = by << 4;
            by = Utils.base64ToByte(charSequence.charAt(n++));
            byArray[n9] = (byte)(n10 | by >> 2);
            byArray[n6++] = (byte)(by << 6 | Utils.base64ToByte(charSequence.charAt(n++)));
        }
        if (n4 != 0) {
            int n11 = n6++;
            int n12 = n++;
            by = Utils.base64ToByte(charSequence.charAt(n++));
            byArray[n11] = (byte)(Utils.base64ToByte(charSequence.charAt(n12)) << 2 | by >> 4);
            if (n4 == 1) {
                byArray[n6++] = (byte)(by << 4 | Utils.base64ToByte(charSequence.charAt(n)) >> 2);
            }
        }
        return 3 * n3 - n4;
    }

    public static void encodeBase64(Object object, StringBuffer stringBuffer) throws IOException {
        XByteArrayOutputStream xByteArrayOutputStream = new XByteArrayOutputStream(2048);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(xByteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        Utils.encodeBase64(xByteArrayOutputStream.getBuffer(), 0, xByteArrayOutputStream.size(), stringBuffer);
    }

    public static Object decodeBase64(CharSequence charSequence, int n, int n2, TypeLoader typeLoader) throws IOException, ClassNotFoundException {
        byte[] byArray = new byte[(n2 >> 2) * 3];
        n2 = Utils.decodeBase64(charSequence, n, n2, byArray);
        return new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(byArray, 0, n2), typeLoader).readObject();
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        Utils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void read(Reader reader, StringBuffer stringBuffer) throws IOException {
        int n;
        while ((n = reader.read()) >= 0) {
            stringBuffer.append((char)n);
        }
        reader.close();
    }

    public static final String eval(String string, Map map) {
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n);
        block4: while (n2 < n) {
            char c = string.charAt(n2++);
            switch (c) {
                case '\\': {
                    if (n2 >= n) continue block4;
                    stringBuffer.append(string.charAt(n2++));
                    break;
                }
                case '$': {
                    Object object;
                    int n3;
                    int n4;
                    if (n2 >= n) continue block4;
                    c = string.charAt(n2);
                    if (c == '{') {
                        n4 = ++n2;
                        while (string.charAt(n2) != '}' && ++n2 != n) {
                        }
                        n3 = n2++;
                    } else {
                        n4 = n2;
                        while (Character.isLetter(string.charAt(n2)) && ++n2 != n) {
                        }
                        n3 = n2;
                    }
                    if (n3 <= n4 || (object = map.get(string.substring(n4, n3), null)) == null) continue block4;
                    stringBuffer.append(object);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static char toHexDigit(int n, boolean bl) {
        return (char)(n < 10 ? n + 48 : (bl ? n + 55 : n + 87));
    }

    public static int fromHexDigit(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return n - 48;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        return -1;
    }

    public static void resetTime() {
        time = lastTime = System.currentTimeMillis();
    }

    public static void printTime(String string) {
        long l = System.currentTimeMillis();
        System.err.println(string + ' ' + (l - time) + " ms, Delta " + (l - lastTime) + " ms");
        lastTime = l;
    }

    public static void flushHandlers(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        if (handlerArray != null) {
            for (int i = handlerArray.length - 1; i >= 0; --i) {
                handlerArray[i].flush();
            }
        }
    }

    public static synchronized String getDisplayLoggerName(String string) {
        return (String)loggerNames.get((Object)string, string);
    }

    public static synchronized void setDisplayLoggerName(String string, String string2) {
        loggerNames.put(string, (Object)string2);
    }

    public static void formatDateAndName(LogRecord logRecord, StringBuffer stringBuffer) {
        new MessageFormat("{0,date} {0,time}").format(new Object[]{new Date(logRecord.getMillis())}, stringBuffer, (FieldPosition)null);
        if (logRecord.getLoggerName() != null) {
            stringBuffer.append(' ').append(Utils.getDisplayLoggerName(logRecord.getLoggerName()));
        }
    }

    /*
     * Loose catch block
     */
    public static int executeForcedlyAndUninterruptibly(Lockable lockable, LockProtectedRunnable lockProtectedRunnable, boolean bl) {
        int n = 0;
        while (true) {
            try {
                lockable.executeForcedly(lockProtectedRunnable, bl);
                return n;
            }
            catch (InterruptedException interruptedException) {
                ++n;
                continue;
            }
            break;
        }
        catch (Lockable.DeadLockException deadLockException) {
            throw new IllegalStateException(deadLockException);
        }
    }

    public static int executeForcedlyAndUninterruptibly(Lockable lockable, LockProtectedRunnable lockProtectedRunnable, Lock lock) {
        int n = 0;
        while (true) {
            try {
                lockable.executeForcedly(lockProtectedRunnable, lock);
                return n;
            }
            catch (InterruptedException interruptedException) {
                ++n;
                continue;
            }
            break;
        }
    }

    static {
        Method method;
        I18N = I18NBundle.getInstance(Utils.class);
        BOOLEAN_0 = new boolean[0];
        BYTE_0 = new byte[0];
        SHORT_0 = new short[0];
        CHAR_0 = new char[0];
        INT_0 = new int[0];
        LONG_0 = new long[0];
        FLOAT_0 = new float[0];
        DOUBLE_0 = new double[0];
        OBJECT_0 = new Object[0];
        STRING_0 = new String[0];
        COLORS = new Color[512];
        try {
            method = System.class.getMethod("nanoTime", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        nanoTimeMethod = method;
        for (int i = 0; i < 512; ++i) {
            Utils.COLORS[i] = new Color(Utils.o2c((i & 0x1C0) >> 6), Utils.o2c((i & 0x38) >> 3), Utils.o2c(i & 7));
        }
        debug = new PrintWriter(new FilterOutputStream(System.err){

            public void write(int n) throws IOException {
                this.out.write(n);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.out.write(byArray, n, n2);
            }
        }, true);
        byteToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        base64ToByte = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
        loggerNames = new StringMap();
    }
}

